/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.hadoop.io.Text;
import org.apache.rya.accumulo.mr.merge.util.CopyRule;
import org.apache.rya.accumulo.mr.merge.util.QueryRuleset;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.query.strategy.ByteRange;
import org.apache.rya.api.query.strategy.TriplePatternStrategy;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.api.resolver.RyaTripleContext;
import org.apache.rya.api.utils.NullableStatementImpl;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.Var;

public class AccumuloQueryRuleset
extends QueryRuleset {
    private final Map<RdfCloudTripleStoreConstants.TABLE_LAYOUT, List<Range>> tableRanges = new HashMap<RdfCloudTripleStoreConstants.TABLE_LAYOUT, List<Range>>();
    private final List<String> entireTables = new LinkedList<String>();
    private final RyaTripleContext ryaContext;

    public AccumuloQueryRuleset(RdfCloudTripleStoreConfiguration conf) throws IOException, QueryRuleset.QueryRulesetException {
        super(conf);
        this.ryaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)conf);
        for (CopyRule rule : this.rules) {
            StatementPattern sp = rule.getStatement();
            Map.Entry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange> entry = this.getRange(sp);
            RdfCloudTripleStoreConstants.TABLE_LAYOUT layout = entry.getKey();
            ByteRange byteRange = entry.getValue();
            Range range = new Range(new Text(byteRange.getStart()), new Text(byteRange.getEnd()));
            if (!this.tableRanges.containsKey(layout)) {
                this.tableRanges.put(layout, new LinkedList());
            }
            this.tableRanges.get(layout).add(range);
        }
    }

    private Map.Entry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange> getRange(StatementPattern sp) throws IOException {
        Var context = sp.getContextVar();
        NullableStatementImpl stmt = new NullableStatementImpl((Resource)sp.getSubjectVar().getValue(), (URI)sp.getPredicateVar().getValue(), sp.getObjectVar().getValue(), new Resource[]{context == null ? null : (Resource)context.getValue()});
        RyaStatement rs = RdfToRyaConversions.convertStatement((Statement)stmt);
        TriplePatternStrategy strategy = this.ryaContext.retrieveStrategy(rs);
        Map.Entry entry = strategy.defineRange(rs.getSubject(), rs.getPredicate(), rs.getObject(), rs.getContext(), this.conf);
        return entry;
    }

    public void addTable(String tableName) {
        this.entireTables.add(tableName);
    }

    public Map<String, InputTableConfig> getInputConfigs() {
        HashMap<String, InputTableConfig> configs = new HashMap<String, InputTableConfig>();
        for (RdfCloudTripleStoreConstants.TABLE_LAYOUT layout : this.tableRanges.keySet()) {
            String parentTable = RdfCloudTripleStoreUtils.layoutPrefixToTable((RdfCloudTripleStoreConstants.TABLE_LAYOUT)layout, (String)this.conf.getTablePrefix());
            InputTableConfig config = new InputTableConfig();
            config.setRanges(this.tableRanges.get(layout));
            configs.put(parentTable, config);
        }
        for (String tableName : this.entireTables) {
            InputTableConfig config = new InputTableConfig();
            LinkedList<Range> ranges = new LinkedList<Range>();
            ranges.add(new Range());
            config.setRanges(ranges);
            configs.put(tableName, config);
        }
        return configs;
    }

    public List<CopyRule> getRules(RdfCloudTripleStoreConstants.TABLE_LAYOUT layout, Range range) throws IOException {
        LinkedList<CopyRule> matchingRules = new LinkedList<CopyRule>();
        for (CopyRule rule : this.rules) {
            ByteRange byteRange;
            Range ruleRange;
            Map.Entry<RdfCloudTripleStoreConstants.TABLE_LAYOUT, ByteRange> entry = this.getRange(rule.getStatement());
            RdfCloudTripleStoreConstants.TABLE_LAYOUT ruleLayout = entry.getKey();
            if (!ruleLayout.equals((Object)layout) || !AccumuloQueryRuleset.rangeContainsRange(ruleRange = new Range(new Text((byteRange = entry.getValue()).getStart()), new Text(byteRange.getEnd())), range)) continue;
            matchingRules.add(rule);
        }
        return matchingRules;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (String fullTableName : this.entireTables) {
            sb.append("\n\tCopy entire table ").append(fullTableName).append("\n");
        }
        return sb.toString();
    }

    private static boolean rangeContainsRange(Range r1, Range r2) {
        if (!r1.isInfiniteStartKey()) {
            if (r2.isInfiniteStartKey()) {
                return false;
            }
            Key start2 = r2.getStartKey();
            if (r2.isStartKeyInclusive() ? !r1.contains(start2) : start2.compareTo(r1.getStartKey()) < 0) {
                return false;
            }
        }
        if (!r1.isInfiniteStopKey()) {
            if (r2.isInfiniteStopKey()) {
                return false;
            }
            Key end2 = r2.getEndKey();
            if (r2.isEndKeyInclusive() ? !r1.contains(end2) : end2.compareTo(r1.getEndKey()) > 0) {
                return false;
            }
        }
        return true;
    }
}

