/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.accumulo.mr.merge.MergeTool;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.accumulo.mr.merge.util.ToolConfigUtils;
import org.apache.rya.api.persist.RyaDAOException;

public class AccumuloInstanceDriver {
    private static final Logger log = Logger.getLogger(AccumuloInstanceDriver.class);
    private static final boolean IS_COPY_HADOOP_HOME_ENABLED = true;
    public static final String ROOT_USER_NAME = "root";
    private final String driverName;
    private final boolean isMock;
    private final boolean shouldCreateIndices;
    private final boolean isReadOnly;
    private final boolean isParent;
    private final String user;
    private final String password;
    private final String instanceName;
    private final String tablePrefix;
    private final String auth;
    private Connector connector;
    private AccumuloRyaDAO dao;
    private SecurityOperations secOps;
    private final AccumuloRdfConfiguration config = new AccumuloRdfConfiguration();
    private MiniAccumuloCluster miniAccumuloCluster = null;
    private MockInstance mockInstance = null;
    private ZooKeeperInstance zooKeeperInstance = null;
    private Instance instance = null;
    private String zooKeepers;
    private final Map<String, String> configMap = new LinkedHashMap<String, String>();
    private List<String> indices = null;
    private final List<String> tableList = new ArrayList<String>();
    private File tempDir = null;
    public static final List<String> TABLE_NAME_SUFFIXES = ImmutableList.of((Object)"spo", (Object)"po", (Object)"osp", (Object)"ns", (Object)"eval", (Object)"prospects", (Object)"selectivity");

    public AccumuloInstanceDriver(String driverName, boolean isMock, boolean shouldCreateIndices, boolean isReadOnly, boolean isParent, String user, String password, String instanceName, String tablePrefix, String auth) {
        this.driverName = (String)Preconditions.checkNotNull((Object)driverName);
        this.isMock = isMock;
        this.shouldCreateIndices = shouldCreateIndices;
        this.isReadOnly = isReadOnly;
        this.user = user;
        this.password = password;
        this.instanceName = instanceName;
        this.tablePrefix = tablePrefix;
        this.auth = auth;
        this.isParent = isParent;
        this.config.setTablePrefix(tablePrefix);
    }

    public void setUp() throws Exception {
        this.setUpConfig();
        this.setUpInstance();
        this.setUpTables();
        this.setUpDao();
    }

    public void setUpInstance() throws Exception {
        if (!this.isMock) {
            log.info((Object)("Setting up " + this.driverName + " MiniAccumulo cluster..."));
            this.tempDir = Files.createTempDir();
            this.tempDir.deleteOnExit();
            this.miniAccumuloCluster = new MiniAccumuloCluster(this.tempDir, this.password);
            this.copyHadoopHomeToTemp();
            this.miniAccumuloCluster.getConfig().setInstanceName(this.instanceName);
            log.info((Object)(this.driverName + " MiniAccumulo instance starting up..."));
            this.miniAccumuloCluster.start();
            Thread.sleep(1000L);
            log.info((Object)(this.driverName + " MiniAccumulo instance started"));
            log.info((Object)("Creating connector to " + this.driverName + " MiniAccumulo instance..."));
            this.zooKeeperInstance = new ZooKeeperInstance((Configuration)this.miniAccumuloCluster.getClientConfig());
            this.instance = this.zooKeeperInstance;
            this.connector = this.zooKeeperInstance.getConnector(this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
            log.info((Object)("Created connector to " + this.driverName + " MiniAccumulo instance"));
        } else {
            log.info((Object)("Setting up " + this.driverName + " mock instance..."));
            this.mockInstance = new MockInstance(this.instanceName);
            this.instance = this.mockInstance;
            this.connector = this.mockInstance.getConnector(this.user, (AuthenticationToken)new PasswordToken((CharSequence)this.password));
            log.info((Object)("Created connector to " + this.driverName + " mock instance"));
        }
        this.zooKeepers = this.instance.getZooKeepers();
    }

    private void copyHadoopHomeToTemp() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            String hadoopHomeEnv = System.getenv("HADOOP_HOME");
            if (hadoopHomeEnv != null) {
                File hadoopHomeDir = new File(hadoopHomeEnv);
                if (hadoopHomeDir.exists()) {
                    File binDir = Paths.get(hadoopHomeDir.getAbsolutePath(), "/bin").toFile();
                    if (binDir.exists()) {
                        FileUtils.copyDirectoryToDirectory((File)binDir, (File)this.tempDir);
                    } else {
                        log.warn((Object)("The specified path for the Hadoop bin directory does not exist: " + binDir.getAbsolutePath()));
                    }
                } else {
                    log.warn((Object)("The specified path for HADOOP_HOME does not exist: " + hadoopHomeDir.getAbsolutePath()));
                }
            } else {
                log.warn((Object)"The HADOOP_HOME environment variable was not found.");
            }
        }
    }

    public void setUpTables() throws Exception {
        log.info((Object)("Setting up " + this.driverName + " tables and permissions"));
        for (String tableSuffix : TABLE_NAME_SUFFIXES) {
            String tableName = this.tablePrefix + tableSuffix;
            this.tableList.add(tableName);
            if (this.connector.tableOperations().exists(tableName)) continue;
            this.connector.tableOperations().create(tableName);
        }
        if (this.shouldCreateIndices) {
            this.indices = Arrays.asList(new String[0]);
            this.tableList.addAll(this.indices);
            log.info((Object)("Setting up " + this.driverName + " indices"));
            for (String index : this.indices) {
                if (this.connector.tableOperations().exists(index)) continue;
                this.connector.tableOperations().create(index);
            }
        }
        log.info((Object)("Creating " + this.driverName + " user and authorizations"));
        this.secOps = this.connector.securityOperations();
        if (!this.user.equals(ROOT_USER_NAME)) {
            this.secOps.createLocalUser(this.user, new PasswordToken((CharSequence)this.password));
        }
        this.addAuths(this.auth);
        TablePermission tablePermission = this.isReadOnly ? TablePermission.READ : TablePermission.WRITE;
        for (String tableSuffix : TABLE_NAME_SUFFIXES) {
            this.secOps.grantTablePermission(this.user, this.tablePrefix + tableSuffix, tablePermission);
        }
        if (this.shouldCreateIndices) {
            for (String index : this.indices) {
                this.secOps.grantTablePermission(this.user, index, tablePermission);
            }
        }
    }

    public void setUpDao() throws Exception {
        log.info((Object)("Creating " + this.driverName + " DAO"));
        this.dao = new AccumuloRyaDAO();
        this.dao.setConnector(this.connector);
        this.dao.setConf(this.config);
        for (String tableName : this.tableList) {
            this.connector.tableOperations().flush(tableName, null, null, false);
        }
        this.dao.init();
    }

    public void setUpConfig() {
        log.info((Object)("Setting " + this.driverName + " config"));
        if (this.isMock) {
            this.configMap.put("ac.mock", Boolean.TRUE.toString());
        }
        this.configMap.put("ac.instance", this.instanceName);
        this.configMap.put("ac.username", this.user);
        this.configMap.put("ac.pwd", this.password);
        this.configMap.put("rdf.tablePrefix", this.tablePrefix);
        this.configMap.put("ac.auth", this.auth);
        this.configMap.put("ac.zk", this.zooKeepers != null ? this.zooKeepers : "localhost");
        log.info((Object)(this.driverName + " config properties"));
        this.config.setTablePrefix(this.tablePrefix);
        for (Map.Entry<String, String> entry : this.configMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String argument = ToolConfigUtils.makeArgument(this.isParent ? key : key + ".child", value);
            log.info((Object)argument);
            this.config.set(key, value);
        }
        MergeTool.setDuplicateKeys((org.apache.hadoop.conf.Configuration)this.config);
    }

    public void tearDownTables() throws Exception {
        if (this.connector != null) {
            for (String tableName : this.tableList) {
                if (!this.connector.tableOperations().exists(tableName)) continue;
                this.connector.tableOperations().delete(tableName);
            }
        }
    }

    public void tearDownDao() throws Exception {
        if (this.dao != null) {
            log.info((Object)("Stopping " + this.driverName + " DAO"));
            try {
                this.dao.destroy();
            }
            catch (RyaDAOException e) {
                log.error((Object)("Error stopping " + this.driverName + " DAO"), (Throwable)e);
            }
            this.dao = null;
        }
    }

    public void tearDownInstance() throws Exception {
        if (this.miniAccumuloCluster != null) {
            log.info((Object)("Stopping " + this.driverName + " cluster"));
            try {
                this.miniAccumuloCluster.stop();
            }
            catch (IOException | InterruptedException e) {
                log.error((Object)("Error stopping " + this.driverName + " cluster"), (Throwable)e);
            }
            this.miniAccumuloCluster = null;
        }
    }

    public void tearDown() throws Exception {
        try {
            this.tearDownDao();
            this.tearDownInstance();
        }
        finally {
            this.removeTempDir();
        }
    }

    public void removeTempDir() {
        if (this.tempDir != null) {
            try {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException e) {
                log.error((Object)("Error deleting " + this.driverName + " temp directory"), (Throwable)e);
            }
            this.tempDir = null;
        }
    }

    public void addAuths(String ... auths) throws AccumuloException, AccumuloSecurityException {
        Authorizations newAuths = AccumuloRyaUtils.addUserAuths(this.user, this.secOps, auths);
        this.secOps.changeUserAuthorizations(this.user, newAuths);
    }

    public Authorizations getAuths() throws AccumuloException, AccumuloSecurityException {
        if (this.secOps != null) {
            return this.secOps.getUserAuthorizations(this.user);
        }
        return null;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public boolean shouldCreateIndices() {
        return this.shouldCreateIndices;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getAuth() {
        return this.auth;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public AccumuloRyaDAO getDao() {
        return this.dao;
    }

    public SecurityOperations getSecOps() {
        return this.secOps;
    }

    public AccumuloRdfConfiguration getConfig() {
        return this.config;
    }

    public MiniAccumuloCluster getMiniAccumuloCluster() {
        return this.miniAccumuloCluster;
    }

    public MockInstance getMockInstance() {
        return this.mockInstance;
    }

    public ZooKeeperInstance getZooKeeperInstance() {
        return this.zooKeeperInstance;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public String getZooKeepers() {
        return this.zooKeepers;
    }

    public Map<String, String> getConfigMap() {
        return Collections.unmodifiableMap(this.configMap);
    }

    public List<String> getTableList() {
        return Collections.unmodifiableList(this.tableList);
    }

    public File getTempDir() {
        return this.tempDir;
    }
}

