/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.reducers;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.rya.accumulo.mr.merge.util.GroupedRow;

public class MultipleFileReducer
extends Reducer<GroupedRow, GroupedRow, Key, Value> {
    private MultipleOutputs<Key, Value> mos;

    protected void setup(Reducer.Context context) {
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
    }

    protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        if (this.mos != null) {
            this.mos.close();
        }
    }

    protected void reduce(GroupedRow group, Iterable<GroupedRow> rows, Reducer.Context context) throws IOException, InterruptedException {
        String groupName = group.getGroup().toString();
        String destination = groupName + "/files/part";
        for (GroupedRow row : rows) {
            this.mos.write((Object)row.getKey(), (Object)row.getValue(), destination);
        }
    }
}

