/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfUtils;
import org.apache.rya.accumulo.mr.merge.mappers.BaseCopyToolMapper;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;

public class FileCopyToolMapper
extends BaseCopyToolMapper<Key, Value, Key, Value> {
    private static final Logger log = Logger.getLogger(FileCopyToolMapper.class);

    @Override
    protected void addMetadataKeys(Mapper.Context context) throws IOException {
        try {
            RyaStatement ryaStatement;
            if (this.runTime != null) {
                log.info((Object)("Writing copy tool run time metadata to child table: " + this.runTime));
                ryaStatement = AccumuloRyaUtils.createCopyToolRunTimeRyaStatement(this.runTime);
                this.writeRyaStatement(ryaStatement, context);
            }
            if (this.startTime != null) {
                log.info((Object)("Writing copy split time metadata to child table: " + this.startTime));
                ryaStatement = AccumuloRyaUtils.createCopyToolSplitTimeRyaStatement(this.startTime);
                this.writeRyaStatement(ryaStatement, context);
            }
            if (this.timeOffset != null) {
                log.info((Object)("Writing copy tool time offset metadata to child table: " + this.timeOffset));
                ryaStatement = AccumuloRyaUtils.createTimeOffsetRyaStatement(this.timeOffset);
                this.writeRyaStatement(ryaStatement, context);
            }
        }
        catch (IOException | InterruptedException | TripleRowResolverException e) {
            throw new IOException("Failed to write metadata key", e);
        }
    }

    private void writeRyaStatement(RyaStatement ryaStatement, Mapper.Context context) throws TripleRowResolverException, IOException, InterruptedException {
        Map serialize = this.childRyaContext.getTripleResolver().serialize(ryaStatement);
        TripleRow tripleRow = (TripleRow)serialize.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO);
        Key key = AccumuloRdfUtils.from((TripleRow)tripleRow);
        Value value = AccumuloRdfUtils.extractValue((TripleRow)tripleRow);
        context.write((Object)key, (Object)value);
    }
}

