/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.log4j.Logger;

public final class ToolConfigUtils {
    private static final Logger log = Logger.getLogger(ToolConfigUtils.class);

    private ToolConfigUtils() {
    }

    public static Set<String> getUserArguments(Configuration conf, String[] args) throws IOException {
        String[] filteredArgs = new String[]{};
        if (Arrays.asList(args).contains("-conf")) {
            new GenericOptionsParser(conf, args);
            ArrayList<String> commandLineArgs = new ArrayList<String>();
            for (String arg : args) {
                if (!arg.startsWith("-D")) continue;
                commandLineArgs.add(arg);
            }
            filteredArgs = commandLineArgs.toArray(new String[0]);
        } else {
            filteredArgs = args;
        }
        String confString = conf.toString();
        String resourceString = StringUtils.removeStart((String)confString, (String)"Configuration: ");
        List<String> resourceNames = Arrays.asList(StringUtils.split((String)resourceString, (String)", "));
        String configFilename = resourceNames.get(resourceNames.size() - 1);
        HashSet<String> toolArgsSet = new HashSet<String>();
        File file = new File(configFilename);
        if (file.exists()) {
            XMLConfiguration configuration = null;
            try {
                configuration = new XMLConfiguration(configFilename);
                toolArgsSet.addAll(ToolConfigUtils.getConfigArguments(configuration));
            }
            catch (ConfigurationException e) {
                log.error((Object)"Unable to load configuration file.", (Throwable)e);
            }
        }
        toolArgsSet.addAll(Arrays.asList(filteredArgs));
        return Collections.unmodifiableSet(toolArgsSet);
    }

    public static Set<String> getConfigArguments(XMLConfiguration configuration) {
        int size = configuration.getList("property.name").size();
        TreeSet<String> configArgs = new TreeSet<String>();
        for (int i = 0; i < size; ++i) {
            String propertyName = configuration.getString("property(" + i + ").name");
            String propertyValue = configuration.getString("property(" + i + ").value");
            String argument = ToolConfigUtils.makeArgument(propertyName, propertyValue);
            configArgs.add(argument);
        }
        return configArgs;
    }

    public static String makeArgument(String propertyName, String value) {
        return "-D" + propertyName + "=" + value;
    }
}

