/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.rya.accumulo.mr.merge.util.QueryRuleset;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.And;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class CopyRule
extends QueryModelNodeBase {
    private static final ValueConstant TRUE = new ValueConstant((Value)ValueFactoryImpl.getInstance().createLiteral(true));
    private static final String SUFFIX = UUID.randomUUID().toString();
    private static final Var SUBJ_VAR = new Var("subject_" + SUFFIX);
    private static final Var PRED_VAR = new Var("predicate_" + SUFFIX);
    private static final Var OBJ_VAR = new Var("object_" + SUFFIX);
    private static final Var CON_VAR = new Var("context_" + SUFFIX);
    private static final Var UNDEFINED_VAR = new Var("undefined_" + SUFFIX);
    private final StatementPattern statement;
    private ValueExpr condition;
    private final Map<String, Var> varMap = new HashMap<String, Var>();
    private final RuleVisitor visitor = new RuleVisitor(this);

    public static boolean accept(Statement stmt, ValueExpr condition, EvaluationStrategy strategy) throws ValueExprEvaluationException, QueryEvaluationException {
        QueryBindingSet bindings = new QueryBindingSet();
        bindings.addBinding(SUBJ_VAR.getName(), (Value)stmt.getSubject());
        bindings.addBinding(PRED_VAR.getName(), (Value)stmt.getPredicate());
        bindings.addBinding(OBJ_VAR.getName(), stmt.getObject());
        if (stmt.getContext() != null) {
            bindings.addBinding(CON_VAR.getName(), (Value)stmt.getContext());
        }
        return strategy.isTrue(condition, (BindingSet)bindings);
    }

    private static boolean trivialCondition(ValueExpr expr) {
        if (expr == null || expr.equals(TRUE)) {
            return true;
        }
        VarSearchVisitor visitor = new VarSearchVisitor(UNDEFINED_VAR.getName());
        expr.visit((QueryModelVisitor)visitor);
        return visitor.found;
    }

    public CopyRule(StatementPattern sp) throws QueryRuleset.QueryRulesetException {
        this.statement = sp;
        Var subjVar = this.statement.getSubjectVar();
        Var predVar = this.statement.getPredicateVar();
        Var objVar = this.statement.getObjectVar();
        Var conVar = this.statement.getContextVar();
        int variables = 0;
        if (subjVar == null || !subjVar.hasValue()) {
            sp.setSubjectVar(SUBJ_VAR);
            if (subjVar != null) {
                this.varMap.put(subjVar.getName(), SUBJ_VAR);
            }
            ++variables;
        }
        if (predVar == null || !predVar.hasValue()) {
            sp.setPredicateVar(PRED_VAR);
            if (predVar != null) {
                this.varMap.put(predVar.getName(), PRED_VAR);
            }
            ++variables;
        }
        if (objVar == null || !objVar.hasValue()) {
            sp.setObjectVar(OBJ_VAR);
            if (objVar != null) {
                this.varMap.put(objVar.getName(), OBJ_VAR);
            }
            ++variables;
        }
        if (variables == 3) {
            throw new QueryRuleset.QueryRulesetException("Statement pattern with no constants would match every statement:\n" + sp);
        }
        if (conVar != null && !conVar.hasValue()) {
            sp.setContextVar(CON_VAR);
            this.varMap.put(conVar.getName(), CON_VAR);
        }
    }

    private void setCondition(ValueExpr newCondition) {
        this.condition = newCondition;
        this.condition.setParentNode((QueryModelNode)this);
    }

    public void addCondition(ValueExpr condition) {
        ValueExpr newCondition = condition.clone();
        if (this.condition == null) {
            this.setCondition(newCondition);
        } else {
            this.setCondition((ValueExpr)new And(this.condition, newCondition));
        }
        this.condition.visit((QueryModelVisitor)this.visitor);
        if (CopyRule.trivialCondition(this.condition)) {
            this.condition = null;
        }
    }

    public ValueExpr getCondition() {
        return this.condition;
    }

    public StatementPattern getStatement() {
        return this.statement;
    }

    void validate() throws QueryRuleset.QueryRulesetException {
        if (!(this.statement.getSubjectVar().isConstant() || this.statement.getPredicateVar().isConstant() || this.statement.getObjectVar().isConstant())) {
            throw new QueryRuleset.QueryRulesetException("Statement pattern with no constants would match every statement:\n" + this.statement.toString());
        }
    }

    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (current.equals((Object)this.condition) && replacement instanceof ValueExpr) {
            this.setCondition(((ValueExpr)replacement).clone());
        } else if (current.equals((Object)this.condition) && replacement == null) {
            this.condition = null;
        } else if (this.condition != null) {
            this.condition.replaceChildNode(current, replacement.clone());
        }
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        if (this.statement != null) {
            this.statement.visit(visitor);
        }
        if (this.condition != null) {
            this.condition.visit(visitor);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.statement.toString().trim());
        if (this.condition != null) {
            sb.append("\n   Condition:\n   \t");
            sb.append(this.condition.toString().trim().replace("\n", "\n   \t"));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(CopyRule.class)) {
            return false;
        }
        CopyRule other = (CopyRule)((Object)obj);
        if (this.statement != null && !this.statement.equals((Object)other.statement) || this.statement == null && other.statement != null) {
            return false;
        }
        return (this.condition == null || this.condition.equals(other.condition)) && (this.condition != null || other.condition == null);
    }

    public int hashCode() {
        int result = this.statement == null ? 0 : this.statement.hashCode();
        result += result * 41 + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    public boolean isGeneralizationOf(CopyRule other) {
        if (this.statement == null || other.statement == null) {
            return false;
        }
        return CopyRule.varIsGeneralization(this.statement.getSubjectVar(), other.statement.getSubjectVar()) && CopyRule.varIsGeneralization(this.statement.getPredicateVar(), other.statement.getPredicateVar()) && CopyRule.varIsGeneralization(this.statement.getObjectVar(), other.statement.getObjectVar()) && CopyRule.varIsGeneralization(this.statement.getContextVar(), other.statement.getContextVar()) && (this.condition == null || this.condition.equals(other.condition));
    }

    private static boolean varIsGeneralization(Var first, Var second) {
        if (first == null || !first.hasValue()) {
            return true;
        }
        return second != null && first.getValue().equals(second.getValue());
    }

    private static class RuleVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        private final CopyRule rule;

        RuleVisitor(CopyRule rule) {
            this.rule = rule;
        }

        public void meet(Var node) {
            String oldName = node.getName();
            if (this.rule.varMap.containsKey(oldName)) {
                node.setName(((Var)this.rule.varMap.get(oldName)).getName());
            } else {
                if (node.hasValue() || node.equals((Object)SUBJ_VAR) || node.equals((Object)PRED_VAR) || node.equals((Object)OBJ_VAR) || node.equals((Object)CON_VAR)) {
                    return;
                }
                node.setName(UNDEFINED_VAR.getName());
            }
        }

        public void meet(And expr) {
            ValueExpr left = expr.getLeftArg();
            ValueExpr right = expr.getRightArg();
            left.visit((QueryModelVisitor)this);
            right.visit((QueryModelVisitor)this);
            QueryModelNode parent = expr.getParentNode();
            if (CopyRule.trivialCondition(left)) {
                if (CopyRule.trivialCondition(right)) {
                    parent.replaceChildNode((QueryModelNode)expr, null);
                } else {
                    parent.replaceChildNode((QueryModelNode)expr, (QueryModelNode)right);
                }
            } else if (CopyRule.trivialCondition(right)) {
                parent.replaceChildNode((QueryModelNode)expr, (QueryModelNode)left);
            }
        }
    }

    private static class VarSearchVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        boolean found = false;
        private final String queryVar;

        public VarSearchVisitor(String queryVar) {
            this.queryVar = queryVar;
        }

        public void meet(Var var) {
            if (this.queryVar.equals(var.getName())) {
                this.found = true;
            }
        }

        public void meetNode(QueryModelNode node) {
            if (!this.found) {
                node.visitChildren((QueryModelVisitor)this);
            }
        }
    }
}

