/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.domain.RyaURI;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;

public final class AccumuloRyaUtils {
    private static final Logger log = Logger.getLogger(AccumuloRyaUtils.class);
    public static final String COPY_TOOL_RUN_TIME_LOCAL_NAME = "copy_tool_run_time";
    public static final String COPY_TOOL_SPLIT_TIME_LOCAL_NAME = "copy_tool_split_time";
    public static final String COPY_TOOL_TIME_OFFSET_LOCAL_NAME = "copy_tool_time_offset";
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private static final Date DEFAULT_DATE = new Date(0L);
    private static final String NAMESPACE = "urn:org.apache.rya/2012/05#";
    private static final ValueFactory VALUE_FACTORY = RdfCloudTripleStoreConstants.VALUE_FACTORY;
    public static RyaURI RTS_SUBJECT_RYA = RdfCloudTripleStoreConstants.RTS_SUBJECT_RYA;
    public static RyaURI RTS_COPY_TOOL_RUN_TIME_PREDICATE_RYA = AccumuloRyaUtils.createRyaUri("copy_tool_run_time");
    public static RyaURI RTS_COPY_TOOL_SPLIT_TIME_PREDICATE_RYA = AccumuloRyaUtils.createRyaUri("copy_tool_split_time");
    public static RyaURI RTS_TIME_OFFSET_PREDICATE_RYA = AccumuloRyaUtils.createRyaUri("copy_tool_time_offset");
    public static final ImmutableSet<IteratorSetting> COMMON_REG_EX_FILTER_SETTINGS = ImmutableSet.of((Object)AccumuloRyaUtils.getVersionRegExFilterSetting(), (Object)AccumuloRyaUtils.getCopyToolRunTimeRegExFilterSetting(), (Object)AccumuloRyaUtils.getCopyToolSplitTimeRegExFilterSetting(), (Object)AccumuloRyaUtils.getCopyToolTimeOffsetRegExFilterSetting());

    private AccumuloRyaUtils() {
    }

    public static RyaURI createRyaUri(String localName) {
        return AccumuloRyaUtils.createRyaUri(NAMESPACE, localName);
    }

    public static RyaURI createRyaUri(String namespace, String localName) {
        return RdfToRyaConversions.convertURI((URI)VALUE_FACTORY.createURI(namespace, localName));
    }

    public static RyaStatement createCopyToolRunTimeRyaStatement(Date date) {
        Literal literal = VALUE_FACTORY.createLiteral(date != null ? date : DEFAULT_DATE);
        RyaType timeObject = new RyaType(literal.getDatatype(), literal.stringValue());
        return new RyaStatement(RTS_SUBJECT_RYA, RTS_COPY_TOOL_RUN_TIME_PREDICATE_RYA, timeObject);
    }

    public static RyaStatement createCopyToolSplitTimeRyaStatement(Date date) {
        Literal literal = VALUE_FACTORY.createLiteral(date != null ? date : DEFAULT_DATE);
        RyaType timeObject = new RyaType(literal.getDatatype(), literal.stringValue());
        return new RyaStatement(RTS_SUBJECT_RYA, RTS_COPY_TOOL_SPLIT_TIME_PREDICATE_RYA, timeObject);
    }

    public static Date getCopyToolRunDate(AccumuloRyaDAO dao) throws RyaDAOException {
        String time = AccumuloRyaUtils.getCopyToolRunTime(dao);
        Date date = null;
        if (time != null) {
            try {
                date = TIME_FORMATTER.parse(time);
            }
            catch (ParseException e) {
                log.error((Object)("Unable to parse the copy tool run time found in table: " + time), (Throwable)e);
            }
        }
        return date;
    }

    public static Date getCopyToolSplitDate(AccumuloRyaDAO dao) throws RyaDAOException {
        String time = AccumuloRyaUtils.getCopyToolSplitTime(dao);
        Date date = null;
        if (time != null) {
            try {
                date = TIME_FORMATTER.parse(time);
            }
            catch (ParseException e) {
                log.error((Object)("Unable to parse the copy tool split time found in table: " + time), (Throwable)e);
            }
        }
        return date;
    }

    public static String getCopyToolRunTime(AccumuloRyaDAO dao) throws RyaDAOException {
        return AccumuloRyaUtils.getMetadata(RTS_COPY_TOOL_RUN_TIME_PREDICATE_RYA, dao);
    }

    public static String getCopyToolSplitTime(AccumuloRyaDAO dao) throws RyaDAOException {
        return AccumuloRyaUtils.getMetadata(RTS_COPY_TOOL_SPLIT_TIME_PREDICATE_RYA, dao);
    }

    private static String getMetadata(RyaURI predicateRyaUri, AccumuloRyaDAO dao) throws RyaDAOException {
        RyaStatement ryaStatement = new RyaStatement(RTS_SUBJECT_RYA, predicateRyaUri, null);
        return AccumuloRyaUtils.getMetadata(ryaStatement, dao);
    }

    private static String getMetadata(RyaStatement ryaStatement, AccumuloRyaDAO dao) throws RyaDAOException {
        String metadata = null;
        AccumuloRdfConfiguration config = dao.getConf();
        CloseableIteration iter = dao.getQueryEngine().query(ryaStatement, config);
        if (iter.hasNext()) {
            metadata = ((RyaStatement)iter.next()).getObject().getData();
        }
        iter.close();
        return metadata;
    }

    public static RyaStatement setCopyToolRunDate(Date date, AccumuloRyaDAO dao) throws RyaDAOException {
        RyaStatement ryaStatement = AccumuloRyaUtils.createCopyToolRunTimeRyaStatement(date);
        dao.add(ryaStatement);
        return ryaStatement;
    }

    public static RyaStatement setCopyToolSplitDate(Date date, AccumuloRyaDAO dao) throws RyaDAOException {
        RyaStatement ryaStatement = AccumuloRyaUtils.createCopyToolSplitTimeRyaStatement(date);
        dao.add(ryaStatement);
        return ryaStatement;
    }

    public static RyaStatement setCopyToolRunTime(String time, AccumuloRyaDAO dao) throws RyaDAOException {
        Date date = null;
        try {
            date = TIME_FORMATTER.parse(time);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse the copy tool run time: ", (Throwable)e);
        }
        return AccumuloRyaUtils.setCopyToolRunDate(date, dao);
    }

    public static RyaStatement setCopyToolSplitTime(String time, AccumuloRyaDAO dao) throws RyaDAOException {
        Date date = null;
        try {
            date = TIME_FORMATTER.parse(time);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse the copy tool split time: ", (Throwable)e);
        }
        return AccumuloRyaUtils.setCopyToolSplitDate(date, dao);
    }

    public static IteratorSetting getVersionRegExFilterSetting() {
        IteratorSetting regex = new IteratorSetting(30, "version_regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, (String)"(.*)urn:(.*)#version[\u0000|\u0001](.*)", null, null, null, (boolean)false);
        Filter.setNegate((IteratorSetting)regex, (boolean)true);
        return regex;
    }

    public static IteratorSetting getCopyToolRunTimeRegExFilterSetting() {
        IteratorSetting regex = new IteratorSetting(31, "copy_tool_run_time_regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, (String)"(.*)urn:(.*)#copy_tool_run_time[\u0000|\u0001](.*)", null, null, null, (boolean)false);
        Filter.setNegate((IteratorSetting)regex, (boolean)true);
        return regex;
    }

    public static IteratorSetting getCopyToolSplitTimeRegExFilterSetting() {
        IteratorSetting regex = new IteratorSetting(32, "copy_tool_split_time_regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, (String)"(.*)urn:(.*)#copy_tool_split_time[\u0000|\u0001](.*)", null, null, null, (boolean)false);
        Filter.setNegate((IteratorSetting)regex, (boolean)true);
        return regex;
    }

    public static IteratorSetting getCopyToolTimeOffsetRegExFilterSetting() {
        IteratorSetting regex = new IteratorSetting(33, "copy_tool_time_offset_regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, (String)"(.*)urn:(.*)#copy_tool_time_offset[\u0000|\u0001](.*)", null, null, null, (boolean)false);
        Filter.setNegate((IteratorSetting)regex, (boolean)true);
        return regex;
    }

    public static void addCommonScannerIteratorsTo(Scanner scanner) {
        for (IteratorSetting iteratorSetting : COMMON_REG_EX_FILTER_SETTINGS) {
            scanner.addScanIterator(iteratorSetting);
        }
    }

    public static Scanner getScanner(String tableName, Configuration config) throws IOException {
        return AccumuloRyaUtils.getScanner(tableName, config, true);
    }

    public static Scanner getScanner(String tableName, Configuration config, boolean shouldAddCommonIterators) throws IOException {
        try {
            String instanceName = config.get("sc.cloudbase.instancename");
            String zooKeepers = config.get("sc.cloudbase.zookeepers");
            Object instance = ConfigUtils.useMockInstance((Configuration)config) ? new MockInstance(config.get("sc.cloudbase.instancename")) : new ZooKeeperInstance((org.apache.commons.configuration.Configuration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers));
            String username = ConfigUtils.getUsername((Configuration)config);
            String password = ConfigUtils.getPassword((Configuration)config);
            Connector connector = instance.getConnector(username, (AuthenticationToken)new PasswordToken((CharSequence)password));
            Authorizations auths = ConfigUtils.getAuthorizations((Configuration)config);
            Scanner scanner = connector.createScanner(tableName, auths);
            if (shouldAddCommonIterators) {
                AccumuloRyaUtils.addCommonScannerIteratorsTo(scanner);
            }
            return scanner;
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            log.error((Object)("Error connecting to " + tableName));
            throw new IOException(e);
        }
    }

    public static void printTable(String tableName, AccumuloRdfConfiguration config, IteratorSetting ... settings) throws IOException {
        AccumuloRyaUtils.printTable(tableName, config, true, settings);
    }

    public static void printTable(String tableName, AccumuloRdfConfiguration config, boolean shouldAddCommonIterators, IteratorSetting ... settings) throws IOException {
        Scanner scanner = AccumuloRyaUtils.getScanner(tableName, (Configuration)config, shouldAddCommonIterators);
        for (IteratorSetting setting : settings) {
            scanner.addScanIterator(setting);
        }
        Iterator iterator = scanner.iterator();
        String instance = config.get("ac.instance");
        log.info((Object)"==================");
        log.info((Object)("TABLE: " + tableName + " INSTANCE: " + instance));
        log.info((Object)"------------------");
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Key key = (Key)entry.getKey();
            Value value = (Value)entry.getValue();
            String keyString = AccumuloRyaUtils.getFormattedKeyString(key);
            log.info((Object)(keyString + " - " + value));
        }
        log.info((Object)"==================");
    }

    private static String getFormattedKeyString(Key key) {
        StringBuilder sb = new StringBuilder();
        byte[] row = key.getRow().getBytes();
        byte[] colFamily = key.getColumnFamily().getBytes();
        byte[] colQualifier = key.getColumnQualifier().getBytes();
        byte[] colVisibility = key.getColumnVisibility().getBytes();
        int maxRowDataToPrint = 256;
        Key.appendPrintableString((byte[])row, (int)0, (int)row.length, (int)256, (StringBuilder)sb);
        sb.append(" ");
        Key.appendPrintableString((byte[])colFamily, (int)0, (int)colFamily.length, (int)256, (StringBuilder)sb);
        sb.append(":");
        Key.appendPrintableString((byte[])colQualifier, (int)0, (int)colQualifier.length, (int)256, (StringBuilder)sb);
        sb.append(" [");
        Key.appendPrintableString((byte[])colVisibility, (int)0, (int)colVisibility.length, (int)256, (StringBuilder)sb);
        sb.append("]");
        sb.append(" ");
        sb.append(new Date(key.getTimestamp()));
        return sb.toString();
    }

    public static void printTablePretty(String tableName, Configuration config, IteratorSetting ... settings) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException {
        AccumuloRyaUtils.printTablePretty(tableName, config, true, settings);
    }

    public static void printTablePretty(String tableName, Configuration config, boolean shouldAddCommonIterators, IteratorSetting ... settings) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException {
        Scanner scanner = AccumuloRyaUtils.getScanner(tableName, config, shouldAddCommonIterators);
        for (IteratorSetting setting : settings) {
            scanner.addScanIterator(setting);
        }
        String format = "| %-64s | %-24s | %-28s | %-20s | %-20s | %-10s |";
        int totalFormatLength = String.format("| %-64s | %-24s | %-28s | %-20s | %-20s | %-10s |", 1, 2, 3, 4, 5, 6).length();
        String instance = config.get("ac.instance");
        log.info((Object)StringUtils.rightPad((String)"==================", (int)totalFormatLength, (String)"="));
        log.info((Object)(StringUtils.rightPad((String)("| TABLE: " + tableName + " INSTANCE: " + instance), (int)(totalFormatLength - 1)) + "|"));
        log.info((Object)StringUtils.rightPad((String)"------------------", (int)totalFormatLength, (String)"-"));
        log.info((Object)String.format("| %-64s | %-24s | %-28s | %-20s | %-20s | %-10s |", "--Row--", "--ColumnVisibility--", "--Timestamp--", "--ColumnFamily--", "--ColumnQualifier--", "--Value--"));
        log.info((Object)(StringUtils.rightPad((String)"|-----------------", (int)(totalFormatLength - 1), (String)"-") + "|"));
        for (Map.Entry entry : scanner) {
            Key k = (Key)entry.getKey();
            String rowString = Key.appendPrintableString((byte[])k.getRow().getBytes(), (int)0, (int)k.getRow().getLength(), (int)64, (StringBuilder)new StringBuilder()).toString();
            log.info((Object)String.format("| %-64s | %-24s | %-28s | %-20s | %-20s | %-10s |", rowString, k.getColumnVisibility(), new Date(k.getTimestamp()), k.getColumnFamily(), k.getColumnQualifier(), entry.getValue()));
        }
        log.info((Object)StringUtils.rightPad((String)"==================", (int)totalFormatLength, (String)"="));
    }

    public static Authorizations addUserAuths(String user, SecurityOperations secOps, Authorizations auths) throws AccumuloException, AccumuloSecurityException {
        ArrayList<String> authList = new ArrayList<String>();
        for (byte[] authBytes : auths.getAuthorizations()) {
            String auth = new String(authBytes);
            authList.add(auth);
        }
        return AccumuloRyaUtils.addUserAuths(user, secOps, authList.toArray(new String[0]));
    }

    public static Authorizations addUserAuths(String user, SecurityOperations secOps, String ... auths) throws AccumuloException, AccumuloSecurityException {
        Authorizations currentUserAuths = secOps.getUserAuthorizations(user);
        ArrayList<byte[]> authList = new ArrayList<byte[]>();
        for (byte[] currentAuth : currentUserAuths.getAuthorizations()) {
            authList.add(currentAuth);
        }
        for (String newAuth : auths) {
            authList.add(newAuth.getBytes());
        }
        Authorizations result = new Authorizations(authList);
        return result;
    }

    public static void removeUserAuths(String userName, SecurityOperations secOps, String authsToRemove) throws AccumuloException, AccumuloSecurityException {
        Authorizations currentUserAuths = secOps.getUserAuthorizations(userName);
        List<String> authList = AccumuloRyaUtils.convertAuthStringToList(currentUserAuths.toString());
        List<String> authsToRemoveList = AccumuloRyaUtils.convertAuthStringToList(authsToRemove);
        authList.removeAll(authsToRemoveList);
        String authString = Joiner.on((String)",").join(authList);
        Authorizations newAuths = new Authorizations(new String[]{authString});
        secOps.changeUserAuthorizations(userName, newAuths);
    }

    public static List<String> convertAuthStringToList(String authString) {
        ArrayList<String> authList = new ArrayList<String>();
        if (authString != null) {
            String[] authSplit = authString.split(",");
            authList.addAll(Arrays.asList(authSplit));
        }
        return authList;
    }

    public static Connector setupConnector(AccumuloRdfConfiguration accumuloRdfConfiguration) {
        Connector connector = null;
        try {
            connector = ConfigUtils.getConnector((Configuration)accumuloRdfConfiguration);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            log.error((Object)"Error creating connector", e);
        }
        return connector;
    }

    public static AccumuloRyaDAO setupDao(AccumuloRdfConfiguration accumuloRdfConfiguration) {
        Connector connector = AccumuloRyaUtils.setupConnector(accumuloRdfConfiguration);
        return AccumuloRyaUtils.setupDao(connector, accumuloRdfConfiguration);
    }

    public static AccumuloRyaDAO setupDao(Connector connector, AccumuloRdfConfiguration accumuloRdfConfiguration) {
        AccumuloRyaDAO accumuloRyaDao = new AccumuloRyaDAO();
        accumuloRyaDao.setConnector(connector);
        accumuloRyaDao.setConf(accumuloRdfConfiguration);
        try {
            accumuloRyaDao.init();
        }
        catch (RyaDAOException e) {
            log.error((Object)"Error initializing DAO", (Throwable)e);
        }
        return accumuloRyaDao;
    }

    public static RyaStatement createTimeOffsetRyaStatement(long timeOffset) {
        Literal literal = VALUE_FACTORY.createLiteral(timeOffset);
        RyaType timeObject = new RyaType(literal.getDatatype(), literal.stringValue());
        return new RyaStatement(RTS_SUBJECT_RYA, RTS_TIME_OFFSET_PREDICATE_RYA, timeObject);
    }

    public static Long getTimeOffset(AccumuloRyaDAO dao) throws RyaDAOException {
        String timeOffsetString = AccumuloRyaUtils.getMetadata(RTS_TIME_OFFSET_PREDICATE_RYA, dao);
        Long timeOffset = null;
        if (timeOffsetString != null) {
            timeOffset = Long.valueOf(timeOffsetString);
        }
        return timeOffset;
    }

    public static RyaStatement setTimeOffset(long timeOffset, AccumuloRyaDAO dao) throws RyaDAOException {
        RyaStatement ryaStatement = AccumuloRyaUtils.createTimeOffsetRyaStatement(timeOffset);
        dao.add(ryaStatement);
        return ryaStatement;
    }
}

