/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.mr.merge.MergeTool;
import org.apache.rya.accumulo.mr.merge.mappers.BaseRuleMapper;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.accumulo.mr.merge.util.GroupedRow;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAOException;

public class RowRuleMapper
extends BaseRuleMapper<GroupedRow, GroupedRow> {
    public static final String MAX_STATEMENTS_PROP = "ac.copy.cache.statements.max";
    public static final int MAX_STATEMENTS_DEFAULT = 10000;
    private static final Logger log = Logger.getLogger(RowRuleMapper.class);
    private final GroupedRow compositeKey = new GroupedRow();
    private final GroupedRow compositeVal = new GroupedRow();
    private int cachedStatements = 0;
    private int maxStatements;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.childAccumuloRdfConfiguration.setBoolean("ac.mock", true);
        this.childUser = "root";
        this.childAccumuloRdfConfiguration.set("ac.username", this.childUser);
        this.childAccumuloRdfConfiguration.set("ac.pwd", "");
        MergeTool.setDuplicateKeys((Configuration)this.childAccumuloRdfConfiguration);
        this.childConnector = AccumuloRyaUtils.setupConnector(this.childAccumuloRdfConfiguration);
        this.childDao = AccumuloRyaUtils.setupDao(this.childConnector, this.childAccumuloRdfConfiguration);
        this.copyAuthorizations();
        this.addMetadataKeys(context);
        this.maxStatements = this.childAccumuloRdfConfiguration.getInt(MAX_STATEMENTS_PROP, 10000);
    }

    @Override
    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.flush(context);
        super.cleanup(context);
    }

    @Override
    protected void copyStatement(RyaStatement rstmt, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.childDao.add(rstmt);
            ++this.cachedStatements;
        }
        catch (RyaDAOException e) {
            throw new IOException("Error serializing RyaStatement", e);
        }
        if (this.cachedStatements >= this.maxStatements) {
            this.flush(context);
        }
    }

    @Override
    protected void copyRow(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
        this.compositeKey.setGroup(this.childTableName);
        this.compositeKey.setKey(key);
        this.compositeVal.setKey(key);
        this.compositeVal.setValue(value);
        context.write((Object)this.compositeKey, (Object)this.compositeVal);
    }

    @Override
    protected void addMetadataKeys(Mapper.Context context) throws IOException {
        try {
            if (this.childDao != null && this.childDao.isInitialized()) {
                RyaStatement ryaStatement;
                if (this.runTime != null) {
                    ryaStatement = AccumuloRyaUtils.createCopyToolRunTimeRyaStatement(this.runTime);
                    this.copyStatement(ryaStatement, context);
                }
                if (this.startTime != null) {
                    ryaStatement = AccumuloRyaUtils.createCopyToolSplitTimeRyaStatement(this.startTime);
                    this.copyStatement(ryaStatement, context);
                }
                if (this.timeOffset != null) {
                    ryaStatement = AccumuloRyaUtils.createTimeOffsetRyaStatement(this.timeOffset);
                    this.copyStatement(ryaStatement, context);
                }
            }
        }
        catch (IOException | InterruptedException | RyaDAOException e) {
            throw new IOException("Failed to write metadata key", e);
        }
    }

    private void flush(Mapper.Context context) throws IOException, InterruptedException {
        Authorizations childAuths;
        try {
            this.childDao.flush();
        }
        catch (RyaDAOException e) {
            throw new IOException("Error writing to in-memory table", e);
        }
        TableOperations ops = this.childConnector.tableOperations();
        SecurityOperations secOps = this.childConnector.securityOperations();
        try {
            childAuths = secOps.getUserAuthorizations(this.childUser);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException("Error connecting to mock instance", e);
        }
        for (String table : ops.list()) {
            if (!table.startsWith(this.childTablePrefix)) continue;
            this.compositeKey.setGroup(table);
            try {
                int rows = 0;
                Scanner scanner = this.childDao.getConnector().createScanner(table, childAuths);
                for (Map.Entry row : scanner) {
                    this.compositeKey.setKey((Key)row.getKey());
                    this.compositeVal.setKey((Key)row.getKey());
                    this.compositeVal.setValue((Value)row.getValue());
                    context.write((Object)this.compositeKey, (Object)this.compositeVal);
                    ++rows;
                }
                log.info((Object)("Flushed " + rows + " in-memory rows to output (" + table + ")."));
                if (rows <= 0) continue;
                ops.deleteRows(table, null, null);
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                throw new IOException("Error flushing in-memory table", e);
            }
        }
        this.cachedStatements = 0;
    }
}

