/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRdfConstants;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.accumulo.RyaTableMutationsFactory;
import org.apache.rya.accumulo.mr.merge.MergeTool;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.accumulo.mr.merge.util.TimeUtils;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.resolver.RyaTripleContext;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;

public class MergeToolMapper
extends Mapper<Key, Value, Text, Mutation> {
    private static final Logger log = Logger.getLogger(MergeToolMapper.class);
    private boolean usesStartTime;
    private String startTimeString;
    private Date startTime;
    private String parentTableName;
    private String childTableName;
    private String parentTablePrefix;
    private String childTablePrefix;
    private Text spoTable;
    private Text poTable;
    private Text ospTable;
    private Mapper.Context context;
    private Configuration parentConfig;
    private Configuration childConfig;
    private AccumuloRdfConfiguration parentAccumuloRdfConfiguration;
    private AccumuloRdfConfiguration childAccumuloRdfConfiguration;
    private RyaTripleContext parentRyaContext;
    private RyaTripleContext childRyaContext;
    private RyaTableMutationsFactory ryaTableMutationFactory;
    private Scanner childScanner;
    private Iterator<Map.Entry<Key, Value>> childIterator;
    private Connector childConnector;
    private AccumuloRyaDAO childDao;
    private Date copyToolInputTime;
    private Date copyToolRunTime;
    private Long parentTimeOffset = 0L;
    private Long childTimeOffset = 0L;
    private boolean useTimeSync = false;
    private boolean useMergeFileInput = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.setup(context);
        this.context = context;
        try {
            RyaStatement parentRyaStatement = this.nextParentRyaStatement();
            RyaStatement childRyaStatement = this.nextChildRyaStatement();
            CompareKeysResult compareKeysResult = null;
            block13: while (compareKeysResult != CompareKeysResult.FINISHED) {
                compareKeysResult = this.compareKeys(parentRyaStatement, childRyaStatement);
                switch (compareKeysResult) {
                    case ADVANCE_CHILD: {
                        childRyaStatement = this.nextChildRyaStatement();
                        continue block13;
                    }
                    case ADVANCE_PARENT: {
                        parentRyaStatement = this.nextParentRyaStatement();
                        continue block13;
                    }
                    case ADVANCE_CHILD_AND_ADD: {
                        RyaStatement tempChildRyaStatement = childRyaStatement;
                        childRyaStatement = this.nextChildRyaStatement();
                        this.addKey(tempChildRyaStatement, context);
                        continue block13;
                    }
                    case ADVANCE_PARENT_AND_DELETE: {
                        RyaStatement tempParentRyaStatement = parentRyaStatement;
                        parentRyaStatement = this.nextParentRyaStatement();
                        this.deleteKey(tempParentRyaStatement, context);
                        continue block13;
                    }
                    case ADVANCE_BOTH: {
                        ColumnVisibility cv1 = new ColumnVisibility(parentRyaStatement.getColumnVisibility());
                        ColumnVisibility cv2 = new ColumnVisibility(childRyaStatement.getColumnVisibility());
                        if (!cv1.equals(cv2) && !cv2.equals(AccumuloRdfConstants.EMPTY_CV)) {
                            ColumnVisibility newCv = MergeToolMapper.combineColumnVisibilities(cv1, cv2);
                            RyaStatement newCvRyaStatement = MergeToolMapper.updateRyaStatementColumnVisibility(parentRyaStatement, newCv);
                            this.deleteKey(parentRyaStatement, context);
                            this.addKey(newCvRyaStatement, context);
                        }
                        parentRyaStatement = this.nextParentRyaStatement();
                        childRyaStatement = this.nextChildRyaStatement();
                        continue block13;
                    }
                    case FINISHED: {
                        log.info((Object)"Finished scanning parent and child tables");
                        continue block13;
                    }
                }
                log.error((Object)("Unknown result: " + (Object)((Object)compareKeysResult)));
            }
        }
        catch (MutationsRejectedException | TripleRowResolverException e) {
            log.error((Object)"Error encountered while merging", e);
        }
        finally {
            this.cleanup(context);
        }
    }

    private RyaStatement nextParentRyaStatement() throws IOException, InterruptedException {
        return MergeToolMapper.nextRyaStatement(this.context, this.parentRyaContext);
    }

    private RyaStatement nextChildRyaStatement() throws IOException, InterruptedException {
        return MergeToolMapper.nextRyaStatement(this.childIterator, this.childRyaContext);
    }

    private static RyaStatement nextRyaStatement(Iterator<Map.Entry<Key, Value>> iterator, RyaTripleContext ryaContext) {
        RyaStatement ryaStatement = null;
        if (iterator.hasNext()) {
            Map.Entry<Key, Value> entry = iterator.next();
            Key key = entry.getKey();
            Value value = entry.getValue();
            try {
                ryaStatement = MergeToolMapper.createRyaStatement(key, value, ryaContext);
            }
            catch (TripleRowResolverException e) {
                log.error((Object)"TripleRowResolverException encountered while creating statement", (Throwable)e);
            }
        }
        return ryaStatement;
    }

    private static RyaStatement nextRyaStatement(Mapper.Context context, RyaTripleContext ryaContext) throws IOException, InterruptedException {
        RyaStatement ryaStatement = null;
        if (context.nextKeyValue()) {
            Key key = (Key)context.getCurrentKey();
            Value value = (Value)context.getCurrentValue();
            try {
                ryaStatement = MergeToolMapper.createRyaStatement(key, value, ryaContext);
            }
            catch (TripleRowResolverException e) {
                log.error((Object)"TripleRowResolverException encountered while creating statement", (Throwable)e);
            }
        }
        return ryaStatement;
    }

    private static RyaStatement createRyaStatement(Key key, Value value, RyaTripleContext ryaTripleContext) throws TripleRowResolverException {
        byte[] row = key.getRowData() != null && key.getRowData().toArray().length > 0 ? key.getRowData().toArray() : null;
        byte[] columnFamily = key.getColumnFamilyData() != null && key.getColumnFamilyData().toArray().length > 0 ? key.getColumnFamilyData().toArray() : null;
        byte[] columnQualifier = key.getColumnQualifierData() != null && key.getColumnQualifierData().toArray().length > 0 ? key.getColumnQualifierData().toArray() : null;
        Long timestamp = key.getTimestamp();
        byte[] columnVisibility = key.getColumnVisibilityData() != null && key.getColumnVisibilityData().toArray().length > 0 ? key.getColumnVisibilityData().toArray() : null;
        byte[] valueBytes = value != null && value.get().length > 0 ? value.get() : null;
        TripleRow tripleRow = new TripleRow(row, columnFamily, columnQualifier, timestamp, columnVisibility, valueBytes);
        RyaStatement ryaStatement = ryaTripleContext.deserializeTriple(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO, tripleRow);
        return ryaStatement;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        log.info((Object)"Setting up mapper");
        this.parentConfig = context.getConfiguration();
        this.childConfig = MergeToolMapper.getChildConfig(this.parentConfig);
        this.startTimeString = this.parentConfig.get("tool.start.time", null);
        if (this.startTimeString != null) {
            this.startTime = MergeTool.convertStartTimeStringToDate(this.startTimeString);
        }
        this.usesStartTime = this.startTime != null;
        this.useTimeSync = this.parentConfig.getBoolean("use.ntp.server", false);
        this.useMergeFileInput = this.parentConfig.getBoolean("use.merge.file.input", false);
        this.parentTableName = this.parentConfig.get("tool.table.name", null);
        this.parentTablePrefix = this.parentConfig.get("rdf.tablePrefix", null);
        this.childTablePrefix = this.childConfig.get("rdf.tablePrefix", null);
        this.childTableName = this.useMergeFileInput ? this.parentTableName.replaceFirst(this.parentTablePrefix, this.childTablePrefix) + "_temp_child" : this.parentTableName.replaceFirst(this.parentTablePrefix, this.childTablePrefix);
        this.spoTable = new Text(this.parentTablePrefix + "spo");
        this.poTable = new Text(this.parentTablePrefix + "po");
        this.ospTable = new Text(this.parentTablePrefix + "osp");
        this.childScanner = this.setupChildScanner(context);
        this.childIterator = this.childScanner.iterator();
        this.parentAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.parentConfig);
        this.parentAccumuloRdfConfiguration.setTablePrefix(this.parentTablePrefix);
        this.parentRyaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)this.parentAccumuloRdfConfiguration);
        this.ryaTableMutationFactory = new RyaTableMutationsFactory(this.parentRyaContext);
        this.childAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.childConfig);
        this.childAccumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
        this.childRyaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)this.childAccumuloRdfConfiguration);
        this.childConnector = AccumuloRyaUtils.setupConnector(this.childAccumuloRdfConfiguration);
        this.childDao = AccumuloRyaUtils.setupDao(this.childConnector, this.childAccumuloRdfConfiguration);
        if (this.startTime != null && this.useTimeSync) {
            try {
                this.copyToolInputTime = AccumuloRyaUtils.getCopyToolSplitDate(this.childDao);
                this.copyToolRunTime = AccumuloRyaUtils.getCopyToolRunDate(this.childDao);
                this.parentTimeOffset = AccumuloRyaUtils.getTimeOffset(this.childDao);
                String durationBreakdown = TimeUtils.getDurationBreakdown(this.parentTimeOffset);
                log.info((Object)("The table " + this.parentTableName + " has a time offset of: " + durationBreakdown));
                this.childTimeOffset = Long.valueOf(this.childConfig.get("time.offset.child", null));
                Date adjustedParentStartTime = new Date(this.startTime.getTime() - this.parentTimeOffset);
                Date adjustedChildStartTime = new Date(this.startTime.getTime() - this.childTimeOffset);
                log.info((Object)("Adjusted parent start time: " + adjustedParentStartTime));
                log.info((Object)("Adjusted child start time: " + adjustedChildStartTime));
            }
            catch (RyaDAOException e) {
                log.error((Object)"Error getting time offset", (Throwable)e);
            }
        }
        log.info((Object)"Finished setting up mapper");
    }

    public static Configuration getChildConfig(Configuration parentConfig) {
        Configuration childConfig = new Configuration(parentConfig);
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.mock");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.instance");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.username");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.pwd");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "rdf.tablePrefix");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.auth");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "query.auth");
        MergeToolMapper.convertChildPropToParentProp(childConfig, parentConfig, "ac.zk");
        MergeTool.setDuplicateKeys(childConfig);
        return childConfig;
    }

    public static void convertChildPropToParentProp(Configuration childConfig, Configuration parentConfig, String parentPropertyName) {
        String childValue = parentConfig.get(parentPropertyName + ".child", "");
        childConfig.set(parentPropertyName, childValue);
    }

    public static ColumnVisibility combineColumnVisibilities(ColumnVisibility cv1, ColumnVisibility cv2) {
        String columnVisibilityExpression = cv1.equals(AccumuloRdfConstants.EMPTY_CV) ? new String(cv2.getExpression(), Charsets.UTF_8) : "(" + new String(cv1.getExpression(), Charsets.UTF_8) + ")|(" + new String(cv2.getExpression(), Charsets.UTF_8) + ")";
        ColumnVisibility newCv = new ColumnVisibility(new Text(columnVisibilityExpression));
        newCv = new ColumnVisibility(newCv.flatten());
        return newCv;
    }

    private Scanner setupChildScanner(Mapper.Context context) throws IOException {
        return MergeToolMapper.setupScanner(context, this.childTableName, this.childConfig);
    }

    private static Scanner setupScanner(Mapper.Context context, String tableName, Configuration config) throws IOException {
        RangeInputSplit split = (RangeInputSplit)context.getInputSplit();
        Range splitRange = split.getRange();
        Scanner scanner = AccumuloRyaUtils.getScanner(tableName, config);
        scanner.setRange(splitRange);
        return scanner;
    }

    private void writeRyaMutations(RyaStatement ryaStatement, Mapper.Context context, boolean isDelete) throws IOException, InterruptedException {
        if (ryaStatement.getColumnVisibility() == null) {
            ryaStatement.setColumnVisibility(AccumuloRdfConstants.EMPTY_CV.getExpression());
        }
        Map mutationMap = this.ryaTableMutationFactory.serialize(ryaStatement);
        Collection spoMutations = (Collection)mutationMap.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO);
        Collection poMutations = (Collection)mutationMap.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.PO);
        Collection ospMutations = (Collection)mutationMap.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.OSP);
        for (Mutation mutation : spoMutations) {
            MergeToolMapper.writeMutation(this.spoTable, mutation, context, isDelete);
        }
        for (Mutation mutation : poMutations) {
            MergeToolMapper.writeMutation(this.poTable, mutation, context, isDelete);
        }
        for (Mutation mutation : ospMutations) {
            MergeToolMapper.writeMutation(this.ospTable, mutation, context, isDelete);
        }
    }

    private void addKey(RyaStatement ryaStatement, Mapper.Context context) throws IOException, InterruptedException {
        this.writeRyaMutations(ryaStatement, context, false);
    }

    private void deleteKey(RyaStatement ryaStatement, Mapper.Context context) throws IOException, InterruptedException {
        this.writeRyaMutations(ryaStatement, context, true);
    }

    private static void writeMutation(Text table, Mutation mutation, Mapper.Context context, boolean isDelete) throws IOException, InterruptedException {
        if (isDelete) {
            List updates = mutation.getUpdates();
            ColumnUpdate columnUpdate = (ColumnUpdate)updates.get(0);
            ColumnVisibility cv = columnUpdate.getColumnVisibility() != null ? new ColumnVisibility(columnUpdate.getColumnVisibility()) : null;
            Mutation deleteMutation = new Mutation(new Text(mutation.getRow()));
            deleteMutation.putDelete(columnUpdate.getColumnFamily(), columnUpdate.getColumnQualifier(), cv, columnUpdate.getTimestamp());
            context.write((Object)table, (Object)deleteMutation);
        } else {
            context.write((Object)table, (Object)mutation);
        }
    }

    private Date normalizeDate(Date date, boolean isParentTable) {
        Date normalizedDate = date;
        if (this.useTimeSync) {
            normalizedDate = isParentTable ? new Date(date.getTime() - this.parentTimeOffset) : (TimeUtils.dateBeforeInclusive(date, this.copyToolRunTime) ? new Date(date.getTime() - this.parentTimeOffset) : new Date(date.getTime() - this.childTimeOffset));
        }
        return normalizedDate;
    }

    private CompareKeysResult compareKeys(RyaStatement key1, RyaStatement key2) throws MutationsRejectedException, IOException, InterruptedException, TripleRowResolverException {
        log.trace((Object)("key1 = " + key1));
        log.trace((Object)("key2 = " + key2));
        if (key1 == null && key2 == null) {
            return CompareKeysResult.FINISHED;
        }
        if (key1 == null) {
            Date t2 = this.normalizeDate(new Date(key2.getTimestamp()), false);
            boolean doNothing = this.usesStartTime && t2.before(this.startTime);
            return doNothing ? CompareKeysResult.ADVANCE_CHILD : CompareKeysResult.ADVANCE_CHILD_AND_ADD;
        }
        if (key2 == null) {
            Date t1 = this.normalizeDate(new Date(key1.getTimestamp()), true);
            boolean doNothing = this.usesStartTime && (this.copyToolInputTime != null && (t1.before(this.copyToolInputTime) || t1.after(this.copyToolInputTime) && t1.after(this.startTime)) || this.copyToolInputTime == null && t1.after(this.startTime));
            return doNothing ? CompareKeysResult.ADVANCE_PARENT : CompareKeysResult.ADVANCE_PARENT_AND_DELETE;
        }
        Map map1 = this.parentRyaContext.serializeTriple(key1);
        Text row1 = new Text(((TripleRow)map1.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO)).getRow());
        Map map2 = this.childRyaContext.serializeTriple(key2);
        Text row2 = new Text(((TripleRow)map2.get(RdfCloudTripleStoreConstants.TABLE_LAYOUT.SPO)).getRow());
        Date t1 = this.normalizeDate(new Date(key1.getTimestamp()), true);
        Date t2 = this.normalizeDate(new Date(key2.getTimestamp()), false);
        if (row1.compareTo((BinaryComparable)row2) < 0) {
            boolean doNothing = this.usesStartTime && (this.copyToolInputTime != null && (t1.before(this.copyToolInputTime) || t1.after(this.copyToolInputTime) && t1.after(this.startTime)) || this.copyToolInputTime == null && t1.after(this.startTime));
            return doNothing ? CompareKeysResult.ADVANCE_PARENT : CompareKeysResult.ADVANCE_PARENT_AND_DELETE;
        }
        if (row1.compareTo((BinaryComparable)row2) > 0) {
            boolean doNothing = this.usesStartTime && t2.before(this.startTime);
            return doNothing ? CompareKeysResult.ADVANCE_CHILD : CompareKeysResult.ADVANCE_CHILD_AND_ADD;
        }
        return CompareKeysResult.ADVANCE_BOTH;
    }

    private static RyaStatement updateRyaStatementColumnVisibility(RyaStatement ryaStatement, ColumnVisibility newCv) {
        RyaStatement newCvRyaStatement = new RyaStatement(ryaStatement.getSubject(), ryaStatement.getPredicate(), ryaStatement.getObject(), ryaStatement.getContext(), ryaStatement.getQualifer(), newCv.getExpression(), ryaStatement.getValue(), ryaStatement.getTimestamp());
        return newCvRyaStatement;
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        log.info((Object)"Cleaning up mapper...");
        if (this.childScanner != null) {
            this.childScanner.close();
        }
        try {
            if (this.childDao != null) {
                this.childDao.destroy();
            }
        }
        catch (RyaDAOException e) {
            log.error((Object)"Error destroying child DAO", (Throwable)e);
        }
        log.info((Object)"Cleaned up mapper");
    }

    private static enum CompareKeysResult {
        ADVANCE_CHILD,
        ADVANCE_CHILD_AND_ADD,
        ADVANCE_PARENT,
        ADVANCE_PARENT_AND_DELETE,
        ADVANCE_BOTH,
        FINISHED;

    }
}

