/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import java.io.IOException;
import java.util.List;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.mr.merge.mappers.BaseCopyToolMapper;
import org.apache.rya.accumulo.mr.merge.util.AccumuloQueryRuleset;
import org.apache.rya.accumulo.mr.merge.util.CopyRule;
import org.apache.rya.accumulo.mr.merge.util.QueryRuleset;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.api.resolver.triple.TripleRow;
import org.apache.rya.api.resolver.triple.TripleRowResolver;
import org.apache.rya.api.resolver.triple.TripleRowResolverException;
import org.apache.rya.api.resolver.triple.impl.WholeRowTripleResolver;
import org.apache.rya.rdftriplestore.evaluation.ParallelEvaluationStrategyImpl;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Or;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;

public abstract class BaseRuleMapper<KEYOUT, VALUEOUT>
extends BaseCopyToolMapper<Key, Value, KEYOUT, VALUEOUT> {
    private static final Logger log = Logger.getLogger(BaseRuleMapper.class);
    private final TripleRowResolver resolver = new WholeRowTripleResolver();
    private RdfCloudTripleStoreConstants.TABLE_LAYOUT parentLayout = null;
    private ValueExpr condition;
    private ParallelEvaluationStrategyImpl strategy;
    private RangeInputSplit split;

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.split = (RangeInputSplit)context.getInputSplit();
        Range range = this.split.getRange();
        this.parentTableName = this.split.getTableName();
        this.parentTablePrefix = conf.get("rdf.tablePrefix");
        for (RdfCloudTripleStoreConstants.TABLE_LAYOUT layout : RdfCloudTripleStoreConstants.TABLE_LAYOUT.values()) {
            String tableName = RdfCloudTripleStoreUtils.layoutPrefixToTable((RdfCloudTripleStoreConstants.TABLE_LAYOUT)layout, (String)this.parentTablePrefix);
            if (!tableName.equals(this.parentTableName)) continue;
            this.parentLayout = layout;
        }
        conf.set("tool.table.name", this.parentTableName);
        super.setup(context);
        if (this.parentLayout != null) {
            AccumuloQueryRuleset ruleset;
            try {
                ruleset = new AccumuloQueryRuleset((RdfCloudTripleStoreConfiguration)new AccumuloRdfConfiguration(conf));
            }
            catch (QueryRuleset.QueryRulesetException e) {
                throw new IOException("Error parsing the input query", e);
            }
            List<CopyRule> rules = ruleset.getRules(this.parentLayout, range);
            for (CopyRule rule : rules) {
                log.info((Object)"Mapper applies to rule:");
                for (String line : rule.toString().split("\n")) {
                    log.info((Object)("\t" + line));
                }
            }
            for (CopyRule rule : rules) {
                if (rule.getCondition() == null) {
                    this.condition = null;
                    break;
                }
                if (this.condition == null) {
                    this.condition = rule.getCondition();
                    continue;
                }
                this.condition = new Or(this.condition, rule.getCondition());
            }
            this.strategy = new ParallelEvaluationStrategyImpl(null, null, null, (RdfCloudTripleStoreConfiguration)this.childAccumuloRdfConfiguration);
            log.info((Object)("Table: " + this.parentTableName));
            log.info((Object)"Range:");
            log.info((Object)("\tfrom " + BaseRuleMapper.keyToString(range.getStartKey(), Integer.MAX_VALUE)));
            log.info((Object)("\tto " + BaseRuleMapper.keyToString(range.getEndKey(), Integer.MAX_VALUE)));
            if (this.condition == null) {
                log.info((Object)"Condition: none");
            } else {
                log.info((Object)"Condition:");
                for (String line : this.condition.toString().split("\n")) {
                    log.info((Object)("\t" + line));
                }
            }
        } else {
            log.info((Object)("(Copying all rows from " + this.parentTableName + " directly.)"));
        }
    }

    protected void map(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
        TripleRow row = new TripleRow(key.getRowData().toArray(), key.getColumnFamilyData().toArray(), key.getColumnQualifierData().toArray(), Long.valueOf(key.getTimestamp()), key.getColumnVisibilityData().toArray(), value == null ? null : value.get());
        try {
            if (this.parentLayout == null) {
                this.copyRow(key, value, context);
                context.getCounter((Enum)Counters.DIRECT_ROWS_COPIED).increment(1L);
            } else {
                RyaStatement rs = this.resolver.deserialize(this.parentLayout, row);
                if (this.condition == null || CopyRule.accept(RyaToRdfConversions.convertStatement((RyaStatement)rs), this.condition, (EvaluationStrategy)this.strategy)) {
                    this.copyStatement(rs, context);
                    context.getCounter((Enum)Counters.STATEMENTS_COPIED).increment(1L);
                }
            }
        }
        catch (TripleRowResolverException e) {
            throw new IOException("Error deserializing triple", e);
        }
        catch (QueryEvaluationException e) {
            throw new IOException("Error evaluating the filter condition", e);
        }
    }

    protected abstract void copyStatement(RyaStatement var1, Mapper.Context var2) throws IOException, InterruptedException;

    protected abstract void copyRow(Key var1, Value var2, Mapper.Context var3) throws IOException, InterruptedException;

    private static String keyToString(Key key, int max) {
        StringBuilder sb = new StringBuilder();
        byte[] row = key.getRow().copyBytes();
        byte[] colFamily = key.getColumnFamily().copyBytes();
        byte[] colQualifier = key.getColumnQualifier().copyBytes();
        byte[] colVisibility = key.getColumnVisibility().copyBytes();
        Key.appendPrintableString((byte[])row, (int)0, (int)row.length, (int)max, (StringBuilder)sb);
        sb.append(" ");
        Key.appendPrintableString((byte[])colFamily, (int)0, (int)colFamily.length, (int)max, (StringBuilder)sb);
        sb.append(":");
        Key.appendPrintableString((byte[])colQualifier, (int)0, (int)colQualifier.length, (int)max, (StringBuilder)sb);
        sb.append(" [");
        Key.appendPrintableString((byte[])colVisibility, (int)0, (int)colVisibility.length, (int)max, (StringBuilder)sb);
        sb.append("] ");
        sb.append(Long.toString(key.getTimestamp()));
        return sb.toString();
    }

    public static enum Counters {
        STATEMENTS_COPIED,
        DIRECT_ROWS_COPIED;

    }
}

