/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.AccumuloRyaDAO;
import org.apache.rya.accumulo.mr.merge.MergeTool;
import org.apache.rya.accumulo.mr.merge.mappers.MergeToolMapper;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.persist.RyaDAOException;
import org.apache.rya.api.resolver.RyaTripleContext;

public class BaseCopyToolMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private static final Logger log = Logger.getLogger(BaseCopyToolMapper.class);
    protected String startTimeString;
    protected Date startTime;
    protected Date runTime;
    protected Long timeOffset;
    protected boolean useCopyFileOutput;
    protected String parentTableName;
    protected String childTableName;
    protected String parentTablePrefix;
    protected String childTablePrefix;
    protected Text childTableNameText;
    protected Configuration parentConfig;
    protected Configuration childConfig;
    protected String parentUser;
    protected String childUser;
    protected Connector parentConnector;
    protected Connector childConnector;
    protected AccumuloRdfConfiguration parentAccumuloRdfConfiguration;
    protected AccumuloRdfConfiguration childAccumuloRdfConfiguration;
    protected RyaTripleContext childRyaContext;
    protected AccumuloRyaDAO childDao;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String offsetString;
        String runTimeString;
        super.setup(context);
        log.info((Object)"Setting up mapper");
        this.parentConfig = context.getConfiguration();
        this.childConfig = MergeToolMapper.getChildConfig(this.parentConfig);
        this.startTimeString = this.parentConfig.get("tool.start.time", null);
        if (this.startTimeString != null) {
            this.startTime = MergeTool.convertStartTimeStringToDate(this.startTimeString);
        }
        if ((runTimeString = this.parentConfig.get("copy.run.time", null)) != null) {
            this.runTime = MergeTool.convertStartTimeStringToDate(runTimeString);
        }
        if ((offsetString = this.parentConfig.get("time.offset", null)) != null) {
            this.timeOffset = Long.valueOf(offsetString);
        }
        this.useCopyFileOutput = this.parentConfig.getBoolean("use.copy.file.output", false);
        this.parentTableName = this.parentConfig.get("tool.table.name", null);
        this.parentTablePrefix = this.parentConfig.get("rdf.tablePrefix", null);
        this.childTablePrefix = this.childConfig.get("rdf.tablePrefix", null);
        this.childTableName = this.parentTableName.replaceFirst(this.parentTablePrefix, this.childTablePrefix);
        this.childTableNameText = new Text(this.childTableName);
        log.info((Object)("Copying data from parent table, \"" + this.parentTableName + "\", to child table, \"" + this.childTableName + "\""));
        this.parentUser = this.parentConfig.get("ac.username", null);
        this.childUser = this.childConfig.get("ac.username", null);
        this.parentAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.parentConfig);
        this.parentAccumuloRdfConfiguration.setTablePrefix(this.parentTablePrefix);
        this.parentConnector = AccumuloRyaUtils.setupConnector(this.parentAccumuloRdfConfiguration);
        this.childAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.childConfig);
        this.childAccumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
        this.childRyaContext = RyaTripleContext.getInstance((RdfCloudTripleStoreConfiguration)this.childAccumuloRdfConfiguration);
        if (this.useCopyFileOutput) {
            this.fixSplitsInCachedLocalFiles();
        } else {
            this.childConnector = AccumuloRyaUtils.setupConnector(this.childAccumuloRdfConfiguration);
            this.childDao = AccumuloRyaUtils.setupDao(this.childConnector, this.childAccumuloRdfConfiguration);
            this.createTableIfNeeded();
            this.copyAuthorizations();
        }
        this.addMetadataKeys(context);
        log.info((Object)"Finished setting up mapper");
    }

    private void fixSplitsInCachedLocalFiles() {
        String cachedLocalFiles;
        if (this.useCopyFileOutput && (cachedLocalFiles = this.parentConfig.get("mapreduce.job.cache.local.files")) != null) {
            ArrayList cachedLocalFilesList = Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)cachedLocalFiles));
            ArrayList<String> formattedCachedLocalFilesList = new ArrayList<String>();
            Iterator iterator = cachedLocalFilesList.iterator();
            while (iterator.hasNext()) {
                String cachedLocalFile;
                String pathToAdd = cachedLocalFile = (String)iterator.next();
                if (cachedLocalFile.endsWith("splits.txt")) {
                    URI uri = null;
                    try {
                        uri = new URI(cachedLocalFiles);
                        pathToAdd = uri.getPath();
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)"Invalid syntax in local cache file path", (Throwable)e);
                    }
                }
                formattedCachedLocalFilesList.add(pathToAdd);
            }
            String formattedCachedLocalFiles = Joiner.on((char)',').join(formattedCachedLocalFilesList);
            if (!cachedLocalFiles.equals(formattedCachedLocalFiles)) {
                this.parentConfig.set("mapreduce.job.cache.local.files", formattedCachedLocalFiles);
            }
        }
    }

    protected void addMetadataKeys(Mapper.Context context) throws IOException {
        try {
            if (AccumuloRyaUtils.getCopyToolRunDate(this.childDao) == null) {
                log.info((Object)("Writing copy tool run time metadata to child table: " + this.runTime));
                AccumuloRyaUtils.setCopyToolRunDate(this.runTime, this.childDao);
            }
            if (AccumuloRyaUtils.getCopyToolSplitDate(this.childDao) == null) {
                log.info((Object)("Writing copy split time metadata to child table: " + this.startTime));
                AccumuloRyaUtils.setCopyToolSplitDate(this.startTime, this.childDao);
            }
            if (this.timeOffset != null) {
                log.info((Object)("Writing copy tool time offset metadata to child table: " + this.timeOffset));
                AccumuloRyaUtils.setTimeOffset(this.timeOffset, this.childDao);
            }
        }
        catch (RyaDAOException e) {
            throw new IOException("Failed to set time metadata key for table: " + this.childTableName, e);
        }
    }

    private void createTableIfNeeded() throws IOException {
        try {
            if (!this.childConnector.tableOperations().exists(this.childTableName)) {
                log.info((Object)("Creating table: " + this.childTableName));
                this.childConnector.tableOperations().create(this.childTableName);
                log.info((Object)("Created table: " + this.childTableName));
                log.info((Object)("Granting authorizations to table: " + this.childTableName));
                this.childConnector.securityOperations().grantTablePermission(this.childUser, this.childTableName, TablePermission.WRITE);
                log.info((Object)("Granted authorizations to table: " + this.childTableName));
            }
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException e) {
            throw new IOException(e);
        }
    }

    protected void copyAuthorizations() throws IOException {
        try {
            SecurityOperations parentSecOps = this.parentConnector.securityOperations();
            SecurityOperations childSecOps = this.childConnector.securityOperations();
            Authorizations parentAuths = parentSecOps.getUserAuthorizations(this.parentUser);
            Authorizations childAuths = childSecOps.getUserAuthorizations(this.childUser);
            if (!childAuths.equals((Object)parentAuths)) {
                log.info((Object)("Adding the authorization, \"" + parentAuths.toString() + "\", to the child user, \"" + this.childUser + "\""));
                Authorizations newChildAuths = AccumuloRyaUtils.addUserAuths(this.childUser, childSecOps, parentAuths);
                childSecOps.changeUserAuthorizations(this.childUser, newChildAuths);
            }
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        log.info((Object)"Cleaning up mapper...");
        try {
            if (this.childDao != null) {
                this.childDao.destroy();
            }
        }
        catch (RyaDAOException e) {
            log.error((Object)"Error destroying child DAO", (Throwable)e);
        }
        log.info((Object)"Cleaned up mapper");
    }
}

