/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge.mappers;

import java.io.IOException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.rya.accumulo.mr.merge.mappers.BaseRuleMapper;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.persist.RyaDAOException;

public class AccumuloRyaRuleMapper
extends BaseRuleMapper<Text, Mutation> {
    @Override
    protected void copyStatement(RyaStatement rstmt, Mapper.Context context) throws IOException {
        try {
            this.childDao.add(rstmt);
        }
        catch (RyaDAOException e) {
            throw new IOException("Error inserting statement into child Rya DAO", e);
        }
    }

    @Override
    protected void copyRow(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
        Mutation mutation = new Mutation(key.getRow().getBytes());
        mutation.put(key.getColumnFamily(), key.getColumnQualifier(), key.getColumnVisibilityParsed(), key.getTimestamp(), value);
        context.write((Object)this.childTableNameText, (Object)mutation);
    }
}

