/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mapreduce.AbstractInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.mr.AccumuloHDFSFileInputFormat;
import org.apache.rya.accumulo.mr.merge.AbstractDualInstanceAccumuloMRTool;
import org.apache.rya.accumulo.mr.merge.CopyTool;
import org.apache.rya.accumulo.mr.merge.mappers.MergeToolMapper;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.accumulo.mr.merge.util.TimeUtils;
import org.apache.rya.accumulo.mr.merge.util.ToolConfigUtils;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;

public class MergeTool
extends AbstractDualInstanceAccumuloMRTool {
    private static final Logger log = Logger.getLogger(MergeTool.class);
    public static final SimpleDateFormat START_TIME_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmssSSSz");
    public static final String CHILD_SUFFIX = ".child";
    public static final String TEMP_SUFFIX = "_temp_child";
    public static final String START_TIME_PROP = "tool.start.time";
    public static final String TABLE_NAME_PROP = "tool.table.name";
    public static final String USE_MERGE_FILE_INPUT = "use.merge.file.input";
    public static final String MERGE_FILE_INPUT_PATH = "merge.file.input.path";
    private String startTime = null;
    private String tempDir = null;
    private boolean useMergeFileInput = false;
    private String localMergeFileImportDir = null;
    private String baseImportDir = null;
    private String tempChildAuths = null;
    private final List<String> tables = new ArrayList<String>();
    public static final ImmutableMap<String, List<String>> DUPLICATE_KEY_MAP = ImmutableMap.builder().put((Object)"ac.mock", (Object)ImmutableList.of((Object)".useMockInstance")).put((Object)"ac.instance", (Object)ImmutableList.of((Object)"sc.cloudbase.instancename")).put((Object)"ac.username", (Object)ImmutableList.of((Object)"sc.cloudbase.username")).put((Object)"ac.pwd", (Object)ImmutableList.of((Object)"sc.cloudbase.password")).put((Object)"ac.auth", (Object)ImmutableList.of((Object)"query.auth", (Object)"query.auth")).put((Object)"ac.zk", (Object)ImmutableList.of((Object)"sc.cloudbase.zookeepers")).put((Object)"rdf.tablePrefix", (Object)ImmutableList.of((Object)"query.tblprefix")).put((Object)"ac.mock.child", (Object)ImmutableList.of((Object)".useMockInstance.child")).put((Object)"ac.instance.child", (Object)ImmutableList.of((Object)"sc.cloudbase.instancename.child")).put((Object)"ac.username.child", (Object)ImmutableList.of((Object)"sc.cloudbase.username.child")).put((Object)"ac.pwd.child", (Object)ImmutableList.of((Object)"sc.cloudbase.password.child")).put((Object)"ac.auth.child", (Object)ImmutableList.of((Object)"query.auth.child", (Object)"query.auth.child")).put((Object)"ac.zk.child", (Object)ImmutableList.of((Object)"sc.cloudbase.zookeepers.child")).put((Object)"rdf.tablePrefix.child", (Object)ImmutableList.of((Object)"query.tblprefix.child")).build();

    public static void setDuplicateKeys(Configuration config) {
        for (Map.Entry entry : DUPLICATE_KEY_MAP.entrySet()) {
            String key = (String)entry.getKey();
            List duplicateKeys = (List)entry.getValue();
            String value = config.get(key);
            if (value == null) continue;
            for (String duplicateKey : duplicateKeys) {
                config.set(duplicateKey, value);
            }
        }
    }

    public static void setDuplicateKeysForProperty(Configuration config, String property, String value) {
        List duplicateKeys = (List)DUPLICATE_KEY_MAP.get((Object)property);
        config.set(property, value);
        if (duplicateKeys != null) {
            for (String key : duplicateKeys) {
                config.set(key, value);
            }
        }
    }

    public void setup() throws Exception {
        super.init();
        this.tempDir = this.conf.get("hadoop.tmp.dir", null);
        if (this.tempDir == null) {
            throw new Exception("Invalid hadoop temp directory. \"hadoop.tmp.dir\" could not be found in the configuration.");
        }
        this.useMergeFileInput = this.conf.getBoolean(USE_MERGE_FILE_INPUT, false);
        this.localMergeFileImportDir = this.conf.get(MERGE_FILE_INPUT_PATH, null);
        this.baseImportDir = this.tempDir + "/merge_tool_file_input/";
        this.startTime = this.conf.get(START_TIME_PROP, null);
        if (!this.useMergeFileInput) {
            boolean useTimeSync;
            if (this.startTime != null) {
                try {
                    Date date = START_TIME_FORMATTER.parse(this.startTime);
                    log.info((Object)("Will merge all data after " + date));
                }
                catch (ParseException e) {
                    throw new Exception("Unable to parse the provided start time: " + this.startTime, e);
                }
            }
            if (useTimeSync = this.conf.getBoolean("use.ntp.server", false)) {
                String tomcatUrl = this.conf.get("tomcat.url.child", null);
                String ntpServerHost = this.conf.get("ntp.server.host", null);
                Long timeOffset = null;
                try {
                    log.info((Object)"Comparing child machine's time to NTP server time...");
                    timeOffset = TimeUtils.getNtpServerAndMachineTimeDifference(ntpServerHost, tomcatUrl);
                }
                catch (IOException | ParseException e) {
                    throw new Exception("Unable to get time difference between machine and NTP server.", e);
                }
                if (timeOffset != null) {
                    this.conf.set("time.offset.child", "" + timeOffset);
                }
            }
        }
        MergeTool.setDuplicateKeys(this.conf);
        this.tables.add(this.tablePrefix + "spo");
    }

    @Override
    public int run(String[] strings) throws Exception {
        this.useMergeFileInput = this.conf.getBoolean(USE_MERGE_FILE_INPUT, false);
        log.info((Object)"Setting up Merge Tool...");
        this.setup();
        if (this.useMergeFileInput) {
            MergeTool.copyParentPropertiesToChild(this.conf);
        }
        for (String table : this.tables) {
            int exitCode;
            String childTable = table.replaceFirst(this.tablePrefix, this.childTablePrefix);
            String jobName = "Merge Tool, merging Child Table: " + childTable + ", into Parent Table: " + table + ", " + System.currentTimeMillis();
            log.info((Object)("Initializing job: " + jobName));
            this.conf.set("mapred.job.name", jobName);
            this.conf.set(TABLE_NAME_PROP, table);
            Job job = Job.getInstance((Configuration)this.conf);
            job.setJarByClass(MergeTool.class);
            if (this.useMergeFileInput) {
                this.importChildFilesToTempParentTable(childTable);
            }
            this.setupAccumuloInput(job);
            InputFormatBase.setInputTableName((Job)job, (String)table);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(Mutation.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            this.setupAccumuloOutput(job, table);
            job.setMapperClass(MergeToolMapper.class);
            job.setReducerClass(Reducer.class);
            Date beginTime = new Date();
            log.info((Object)("Job for table \"" + table + "\" started: " + beginTime));
            int n = exitCode = job.waitForCompletion(true) ? 0 : 1;
            if (this.useMergeFileInput && StringUtils.isNotBlank((String)this.tempChildAuths)) {
                AccumuloRdfConfiguration parentAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.conf);
                parentAccumuloRdfConfiguration.setTablePrefix(this.tablePrefix);
                Connector parentConnector = AccumuloRyaUtils.setupConnector(parentAccumuloRdfConfiguration);
                SecurityOperations secOps = parentConnector.securityOperations();
                AccumuloRyaUtils.removeUserAuths(this.userName, secOps, this.tempChildAuths);
            }
            if (exitCode == 0) {
                Date endTime = new Date();
                log.info((Object)("Job for table \"" + table + "\" finished: " + endTime));
                log.info((Object)("The job took " + (endTime.getTime() - beginTime.getTime()) / 1000L + " seconds."));
                continue;
            }
            log.error((Object)("Job for table \"" + table + "\" Failed!!!"));
            return exitCode;
        }
        return 0;
    }

    public void createTempTableIfNeeded(String childTableName) throws IOException {
        try {
            AccumuloRdfConfiguration accumuloRdfConfiguration = new AccumuloRdfConfiguration(this.conf);
            accumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
            Connector connector = AccumuloRyaUtils.setupConnector(accumuloRdfConfiguration);
            if (!connector.tableOperations().exists(childTableName)) {
                log.info((Object)("Creating table: " + childTableName));
                connector.tableOperations().create(childTableName);
                log.info((Object)("Created table: " + childTableName));
                log.info((Object)("Granting authorizations to table: " + childTableName));
                SecurityOperations secOps = connector.securityOperations();
                secOps.grantTablePermission(this.userName, childTableName, TablePermission.WRITE);
                log.info((Object)("Granted authorizations to table: " + childTableName));
                Authorizations parentAuths = secOps.getUserAuthorizations(this.userName);
                if (!parentAuths.equals((Object)this.childAuthorizations)) {
                    List<String> childAuthList = MergeTool.findUniqueAuthsFromChild(parentAuths.toString(), this.childAuthorizations.toString());
                    this.tempChildAuths = Joiner.on((String)",").join(childAuthList);
                    log.info((Object)("Adding the authorization, \"" + this.tempChildAuths + "\", to the parent user, \"" + this.userName + "\""));
                    Authorizations newAuths = AccumuloRyaUtils.addUserAuths(this.userName, secOps, new Authorizations(new String[]{this.tempChildAuths}));
                    secOps.changeUserAuthorizations(this.userName, newAuths);
                }
            }
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException e) {
            throw new IOException(e);
        }
    }

    private static List<String> findUniqueAuthsFromChild(String parentAuths, String childAuths) {
        List<String> parentAuthList = AccumuloRyaUtils.convertAuthStringToList(parentAuths);
        List<String> childAuthList = AccumuloRyaUtils.convertAuthStringToList(childAuths);
        childAuthList.removeAll(parentAuthList);
        return childAuthList;
    }

    public void importChildFilesToTempParentTable(String childTableName) throws Exception {
        String tempChildTable = childTableName + TEMP_SUFFIX;
        this.createTempTableIfNeeded(tempChildTable);
        AccumuloRdfConfiguration parentAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.conf);
        parentAccumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
        Connector parentConnector = AccumuloRyaUtils.setupConnector(parentAccumuloRdfConfiguration);
        TableOperations parentTableOperations = parentConnector.tableOperations();
        Path localWorkDir = CopyTool.getPath(this.localMergeFileImportDir, childTableName);
        Path hdfsBaseWorkDir = CopyTool.getPath(this.baseImportDir, childTableName);
        CopyTool.copyLocalToHdfs(localWorkDir, hdfsBaseWorkDir, this.conf);
        Path files = CopyTool.getPath(hdfsBaseWorkDir.toString(), "files");
        Path failures = CopyTool.getPath(hdfsBaseWorkDir.toString(), "failures");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.setPermission(hdfsBaseWorkDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        if (fs.exists(failures)) {
            fs.delete(failures, true);
        }
        fs.mkdirs(failures);
        parentTableOperations.importDirectory(tempChildTable, files.toString(), failures.toString(), false);
        AccumuloRyaUtils.printTablePretty(tempChildTable, this.conf, new IteratorSetting[0]);
    }

    public static void copyParentPropertiesToChild(Configuration config) {
        MergeTool.copyParentPropToChild(config, "ac.mock");
        MergeTool.copyParentPropToChild(config, "ac.instance");
        MergeTool.copyParentPropToChild(config, "ac.username");
        MergeTool.copyParentPropToChild(config, "ac.pwd");
        MergeTool.copyParentPropToChild(config, "ac.zk");
        MergeTool.setDuplicateKeys(config);
    }

    public static void copyParentPropToChild(Configuration config, String parentPropertyName) {
        String parentValue = config.get(parentPropertyName, "");
        config.set(parentPropertyName + CHILD_SUFFIX, parentValue);
    }

    protected void setupAccumuloInput(Job job) throws AccumuloSecurityException {
        if (!this.hdfsInput) {
            job.setInputFormatClass(AccumuloInputFormat.class);
        } else {
            job.setInputFormatClass(AccumuloHDFSFileInputFormat.class);
        }
        AbstractInputFormat.setConnectorInfo((Job)job, (String)this.userName, (AuthenticationToken)new PasswordToken((CharSequence)this.pwd));
        InputFormatBase.setInputTableName((Job)job, (String)RdfCloudTripleStoreUtils.layoutPrefixToTable((RdfCloudTripleStoreConstants.TABLE_LAYOUT)this.rdfTableLayout, (String)this.tablePrefix));
        AbstractInputFormat.setScanAuthorizations((Job)job, (Authorizations)this.authorizations);
        if (!this.mock) {
            AbstractInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(this.instance).withZkHosts(this.zk));
        } else {
            AbstractInputFormat.setMockInstance((Job)job, (String)this.instance);
        }
        if (this.ttl != null) {
            IteratorSetting setting = new IteratorSetting(1, "fi", AgeOffFilter.class);
            AgeOffFilter.setTTL((IteratorSetting)setting, (Long)Long.valueOf(this.ttl));
            InputFormatBase.addIterator((Job)job, (IteratorSetting)setting);
        }
        for (IteratorSetting iteratorSetting : AccumuloRyaUtils.COMMON_REG_EX_FILTER_SETTINGS) {
            InputFormatBase.addIterator((Job)job, (IteratorSetting)iteratorSetting);
        }
    }

    public static int setupAndRun(String[] args) {
        int returnCode = -1;
        try {
            Configuration conf = new Configuration();
            Set<String> toolArgs = ToolConfigUtils.getUserArguments(conf, args);
            if (!toolArgs.isEmpty()) {
                String parameters = Joiner.on((String)"\r\n\t").join(toolArgs);
                log.info((Object)("Running Merge Tool with the following parameters...\r\n\t" + parameters));
            }
            returnCode = ToolRunner.run((Configuration)conf, (Tool)new MergeTool(), (String[])args);
        }
        catch (Exception e) {
            log.error((Object)"Error running merge tool", (Throwable)e);
        }
        return returnCode;
    }

    public static void main(String[] args) {
        String log4jConfiguration = System.getProperties().getProperty("log4j.configuration");
        if (StringUtils.isNotBlank((String)log4jConfiguration)) {
            String parsedConfiguration = StringUtils.removeStart((String)log4jConfiguration, (String)"file:");
            File configFile = new File(parsedConfiguration);
            if (configFile.exists()) {
                DOMConfigurator.configure((String)parsedConfiguration);
            } else {
                BasicConfigurator.configure();
            }
        }
        log.info((Object)"Starting Merge Tool");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                log.error((Object)("Uncaught exception in " + thread.getName()), throwable);
            }
        });
        int returnCode = MergeTool.setupAndRun(args);
        log.info((Object)"Finished running Merge Tool");
        System.exit(returnCode);
    }

    public static String getStartTimeString(Date startDate) {
        return MergeTool.convertDateToStartTimeString(startDate);
    }

    public static String convertDateToStartTimeString(Date date) {
        String startTimeString = START_TIME_FORMATTER.format(date);
        return startTimeString;
    }

    public static Date convertStartTimeStringToDate(String startTimeString) {
        Date date;
        try {
            date = START_TIME_FORMATTER.parse(startTimeString);
        }
        catch (ParseException e) {
            log.error((Object)"Could not parse date", (Throwable)e);
            return null;
        }
        return date;
    }
}

