/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge;

import com.google.common.base.Joiner;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.mapreduce.AbstractInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloMultiTableInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.lib.partition.KeyRangePartitioner;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.rfile.bcfile.Compression;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.iterators.user.TimestampFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.rya.accumulo.AccumuloRdfConfiguration;
import org.apache.rya.accumulo.mr.AccumuloHDFSFileInputFormat;
import org.apache.rya.accumulo.mr.merge.AbstractDualInstanceAccumuloMRTool;
import org.apache.rya.accumulo.mr.merge.MergeTool;
import org.apache.rya.accumulo.mr.merge.common.InstanceType;
import org.apache.rya.accumulo.mr.merge.mappers.AccumuloCopyToolMapper;
import org.apache.rya.accumulo.mr.merge.mappers.AccumuloRyaRuleMapper;
import org.apache.rya.accumulo.mr.merge.mappers.FileCopyToolMapper;
import org.apache.rya.accumulo.mr.merge.mappers.MergeToolMapper;
import org.apache.rya.accumulo.mr.merge.mappers.RowRuleMapper;
import org.apache.rya.accumulo.mr.merge.reducers.MultipleFileReducer;
import org.apache.rya.accumulo.mr.merge.util.AccumuloInstanceDriver;
import org.apache.rya.accumulo.mr.merge.util.AccumuloQueryRuleset;
import org.apache.rya.accumulo.mr.merge.util.AccumuloRyaUtils;
import org.apache.rya.accumulo.mr.merge.util.GroupedRow;
import org.apache.rya.accumulo.mr.merge.util.TimeUtils;
import org.apache.rya.accumulo.mr.merge.util.ToolConfigUtils;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.RdfCloudTripleStoreConstants;
import org.apache.rya.api.RdfCloudTripleStoreUtils;
import org.apache.rya.api.layout.TablePrefixLayoutStrategy;
import org.apache.rya.indexing.accumulo.ConfigUtils;

public class CopyTool
extends AbstractDualInstanceAccumuloMRTool {
    private static final Logger log = Logger.getLogger(CopyTool.class);
    public static final String COPY_TABLE_LIST_PROP = "copy.table.list";
    public static final String CREATE_CHILD_INSTANCE_TYPE_PROP = "create.child.instance.type";
    public static final String PARENT_TIME_OFFSET_PROP = "time.offset";
    public static final String CHILD_TIME_OFFSET_PROP = "time.offset.child";
    public static final String NTP_SERVER_HOST_PROP = "ntp.server.host";
    public static final String PARENT_TOMCAT_URL_PROP = "tomcat.url";
    public static final String CHILD_TOMCAT_URL_PROP = "tomcat.url.child";
    public static final String COPY_RUN_TIME_PROP = "copy.run.time";
    public static final String USE_NTP_SERVER_PROP = "use.ntp.server";
    public static final String USE_COPY_FILE_OUTPUT = "use.copy.file.output";
    public static final String COPY_FILE_OUTPUT_PATH = "copy.file.output.path";
    public static final String COPY_FILE_OUTPUT_COMPRESSION_TYPE = "copy.file.output.compression.type";
    public static final String USE_COPY_FILE_OUTPUT_DIRECTORY_CLEAR = "use.copy.file.output.directory.clear";
    public static final String COPY_FILE_IMPORT_DIRECTORY = "copy.file.import.directory";
    public static final String USE_COPY_FILE_IMPORT = "use.copy.file.import";
    public static final String USE_COPY_QUERY_SPARQL = "use.copy.query.sparql";
    public static final String QUERY_STRING_PROP = "ac.copy.query";
    public static final String QUERY_FILE_PROP = "ac.copy.queryfile";
    private String startTime = null;
    private boolean useCopyFileOutput = false;
    private String baseOutputDir = null;
    private String localBaseOutputDir = null;
    private String compressionType = null;
    private boolean useCopyFileOutputDirectoryClear = false;
    private String tempDir = null;
    private boolean useCopyFileImport = false;
    private boolean useQuery = false;
    private String localCopyFileImportDir = null;
    private String baseImportDir = null;
    private final List<String> tables = new ArrayList<String>();
    private AccumuloInstanceDriver childAccumuloInstanceDriver = null;

    public void setup() throws Exception {
        super.init();
        this.tempDir = this.conf.get("hadoop.tmp.dir", null);
        if (this.tempDir == null) {
            throw new Exception("Invalid hadoop temp directory. \"hadoop.tmp.dir\" could not be found in the configuration.");
        }
        this.useCopyFileOutput = this.conf.getBoolean(USE_COPY_FILE_OUTPUT, false);
        this.baseOutputDir = this.tempDir + "/copy_tool_file_output/";
        this.localBaseOutputDir = this.conf.get(COPY_FILE_OUTPUT_PATH, null);
        this.compressionType = this.conf.get(COPY_FILE_OUTPUT_COMPRESSION_TYPE, null);
        this.useCopyFileOutputDirectoryClear = this.conf.getBoolean(USE_COPY_FILE_OUTPUT_DIRECTORY_CLEAR, false);
        this.localCopyFileImportDir = this.conf.get(COPY_FILE_IMPORT_DIRECTORY, null);
        this.baseImportDir = this.tempDir + "/copy_tool_import/";
        this.startTime = this.conf.get("tool.start.time", null);
        if (!this.useCopyFileImport) {
            if (this.startTime != null) {
                try {
                    Date date = MergeTool.START_TIME_FORMATTER.parse(this.startTime);
                    log.info((Object)("Will copy all data after " + date));
                }
                catch (ParseException e) {
                    throw new Exception("Unable to parse the provided start time: " + this.startTime, e);
                }
            }
            Date copyRunTime = new Date();
            boolean useTimeSync = this.conf.getBoolean(USE_NTP_SERVER_PROP, false);
            if (useTimeSync) {
                String tomcatUrl = this.conf.get(PARENT_TOMCAT_URL_PROP, null);
                String ntpServerHost = this.conf.get(NTP_SERVER_HOST_PROP, null);
                Long timeOffset = null;
                Date ntpDate = null;
                try {
                    log.info((Object)"Comparing parent machine's time to NTP server time...");
                    ntpDate = TimeUtils.getNtpServerDate(ntpServerHost);
                    Date parentMachineDate = TimeUtils.getMachineDate(tomcatUrl);
                    boolean isMachineLocal = TimeUtils.isUrlLocalMachine(tomcatUrl);
                    timeOffset = TimeUtils.getTimeDifference(ntpDate, parentMachineDate, isMachineLocal);
                }
                catch (IOException | ParseException e) {
                    throw new Exception("Unable to get time difference between machine and NTP server.", e);
                }
                if (timeOffset != null) {
                    this.conf.set(PARENT_TIME_OFFSET_PROP, "" + timeOffset);
                }
                copyRunTime = ntpDate;
            }
            String copyRunTimeString = MergeTool.START_TIME_FORMATTER.format(copyRunTime);
            if (copyRunTime != null) {
                this.conf.set(COPY_RUN_TIME_PROP, copyRunTimeString);
            }
        }
        MergeTool.setDuplicateKeys(this.conf);
        String copyTableListProperty = this.conf.get(COPY_TABLE_LIST_PROP);
        if (StringUtils.isNotBlank((String)copyTableListProperty)) {
            String[] split = copyTableListProperty.split(",");
            this.tables.addAll(Arrays.asList(split));
        } else if (this.useCopyFileImport) {
            File importDir = new File(this.localCopyFileImportDir);
            String[] files = importDir.list();
            this.tables.addAll(Arrays.asList(files));
        } else {
            this.tables.add(this.tablePrefix + "spo");
            this.tables.add(this.tablePrefix + "osp");
            this.tables.add(this.tablePrefix + "po");
            this.tables.add(this.tablePrefix + "ns");
            this.tables.add(this.tablePrefix + "eval");
            this.tables.add(this.tablePrefix + "prospects");
            this.tables.add(this.tablePrefix + "selectivity");
        }
        if (this.tables.isEmpty()) {
            log.warn((Object)"No list of tables to copy was provided.");
        } else {
            String tablesToCopy = Joiner.on((String)"\r\n\t").join(this.tables);
            log.info((Object)("Will attempt to copy the following tables/indices from the parent:\r\n\t" + tablesToCopy));
        }
    }

    @Override
    public int run(String[] strings) throws Exception {
        this.useCopyFileImport = this.conf.getBoolean(USE_COPY_FILE_IMPORT, false);
        this.useQuery = this.conf.getBoolean(USE_COPY_QUERY_SPARQL, false);
        if (this.useCopyFileImport) {
            return this.runImport();
        }
        if (this.useQuery) {
            return this.runQueryCopy();
        }
        return this.runCopy();
    }

    private int runCopy() throws Exception {
        log.info((Object)"Setting up Copy Tool...");
        this.setup();
        if (!this.useCopyFileOutput) {
            this.createChildInstance(this.conf);
        }
        AccumuloRdfConfiguration parentAccumuloRdfConfiguration = new AccumuloRdfConfiguration(this.conf);
        parentAccumuloRdfConfiguration.setTablePrefix(this.tablePrefix);
        Connector parentConnector = AccumuloRyaUtils.setupConnector(parentAccumuloRdfConfiguration);
        TableOperations parentTableOperations = parentConnector.tableOperations();
        for (String table : this.tables) {
            if (parentTableOperations.exists(table)) {
                int exitCode;
                String childTable = table.replaceFirst(this.tablePrefix, this.childTablePrefix);
                String jobName = "Copy Tool, copying Parent Table: " + table + ", into Child Table: " + childTable + ", " + System.currentTimeMillis();
                log.info((Object)("Initializing job: " + jobName));
                this.conf.set("mapred.job.name", jobName);
                this.conf.set("tool.table.name", table);
                Job job = Job.getInstance((Configuration)this.conf);
                job.setJarByClass(CopyTool.class);
                this.setupAccumuloInput(job);
                InputFormatBase.setInputTableName((Job)job, (String)table);
                if (this.useCopyFileOutput) {
                    job.setMapOutputKeyClass(Key.class);
                    job.setMapOutputValueClass(Value.class);
                    job.setOutputKeyClass(Key.class);
                    job.setOutputValueClass(Value.class);
                } else {
                    job.setMapOutputKeyClass(Text.class);
                    job.setMapOutputValueClass(Mutation.class);
                    job.setOutputKeyClass(Text.class);
                    job.setOutputValueClass(Mutation.class);
                }
                this.setupAccumuloOutput(job, childTable);
                if (this.useCopyFileOutput) {
                    this.setupSplitsFile(job, parentTableOperations, table, childTable);
                    job.setMapperClass(FileCopyToolMapper.class);
                } else {
                    job.setMapperClass(AccumuloCopyToolMapper.class);
                }
                job.setReducerClass(Reducer.class);
                Date beginTime = new Date();
                log.info((Object)("Job for table \"" + table + "\" started: " + beginTime));
                int n = exitCode = job.waitForCompletion(true) ? 0 : 1;
                if (exitCode == 0) {
                    if (this.useCopyFileOutput) {
                        log.info((Object)("Moving data from HDFS to the local file system for the table: " + childTable));
                        org.apache.hadoop.fs.Path hdfsPath = CopyTool.getPath(this.baseOutputDir, childTable);
                        org.apache.hadoop.fs.Path localPath = CopyTool.getPath(this.localBaseOutputDir, childTable);
                        log.info((Object)("HDFS directory: " + hdfsPath.toString()));
                        log.info((Object)("Local directory: " + localPath.toString()));
                        this.copyHdfsToLocal(hdfsPath, localPath);
                    }
                    Date endTime = new Date();
                    log.info((Object)("Job for table \"" + table + "\" finished: " + endTime));
                    log.info((Object)("The job took " + (endTime.getTime() - beginTime.getTime()) / 1000L + " seconds."));
                    continue;
                }
                log.error((Object)("Job for table \"" + table + "\" Failed!!!"));
                return exitCode;
            }
            log.warn((Object)("The table \"" + table + "\" was NOT found in the parent instance and cannot be copied."));
        }
        return 0;
    }

    private int runImport() throws Exception {
        log.info((Object)"Setting up Copy Tool for importing...");
        this.setup();
        this.createChildInstance(this.conf);
        for (String childTable : this.tables) {
            String jobName = "Copy Tool, importing Exported Parent Table files from: " + CopyTool.getPath(this.localCopyFileImportDir, childTable).toString() + ", into Child Table: " + childTable + ", " + System.currentTimeMillis();
            log.info((Object)("Initializing job: " + jobName));
            this.conf.set("mapred.job.name", jobName);
            Date beginTime = new Date();
            log.info((Object)("Job for table \"" + childTable + "\" started: " + beginTime));
            this.createTableIfNeeded(childTable);
            this.importFilesToChildTable(childTable);
            Date endTime = new Date();
            log.info((Object)("Job for table \"" + childTable + "\" finished: " + endTime));
            log.info((Object)("The job took " + (endTime.getTime() - beginTime.getTime()) / 1000L + " seconds."));
        }
        return 0;
    }

    private int runQueryCopy() throws Exception {
        log.info((Object)"Setting up Copy Tool with a query-based ruleset...");
        this.setup();
        if (!this.useCopyFileOutput) {
            this.createChildInstance(this.conf);
        }
        AccumuloRdfConfiguration aconf = new AccumuloRdfConfiguration(this.conf);
        aconf.setBoolean(".useMockInstance", this.mock);
        aconf.setTablePrefix(this.tablePrefix);
        aconf.setFlush(false);
        ConfigUtils.setIndexers((RdfCloudTripleStoreConfiguration)aconf);
        TablePrefixLayoutStrategy prefixStrategy = new TablePrefixLayoutStrategy(this.tablePrefix);
        this.tables.clear();
        this.tables.add(prefixStrategy.getSpo());
        this.tables.add(prefixStrategy.getOsp());
        this.tables.add(prefixStrategy.getPo());
        this.tables.add(prefixStrategy.getNs());
        AccumuloQueryRuleset ruleset = new AccumuloQueryRuleset((RdfCloudTripleStoreConfiguration)aconf);
        ruleset.addTable(prefixStrategy.getNs());
        for (String line : ruleset.toString().split("\n")) {
            log.info((Object)line);
        }
        Job job = Job.getInstance((Configuration)aconf);
        job.setJarByClass(((Object)((Object)this)).getClass());
        this.setupMultiTableInputFormat(job, ruleset);
        this.setupAccumuloOutput(job, "");
        if (this.useCopyFileOutput) {
            job.setJobName("Ruleset-based export to file: " + this.tablePrefix + " -> " + this.localBaseOutputDir);
            job.setMapperClass(RowRuleMapper.class);
            job.setMapOutputKeyClass(GroupedRow.class);
            job.setMapOutputValueClass(GroupedRow.class);
            job.setGroupingComparatorClass(GroupedRow.GroupComparator.class);
            job.setSortComparatorClass(GroupedRow.SortComparator.class);
            job.setReducerClass(MultipleFileReducer.class);
            job.setOutputKeyClass(Key.class);
            job.setOutputValueClass(Value.class);
        } else {
            job.setJobName("Ruleset-based copy: " + this.tablePrefix + " -> " + this.childTablePrefix);
            job.setMapperClass(AccumuloRyaRuleMapper.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Mutation.class);
            job.setNumReduceTasks(0);
            for (String parentTable : this.tables) {
                String childTable = parentTable.replaceFirst(this.tablePrefix, this.childTablePrefix);
                this.createTableIfNeeded(childTable);
            }
        }
        Date beginTime = new Date();
        log.info((Object)("Job started: " + beginTime));
        boolean success = job.waitForCompletion(true);
        if (success) {
            if (this.useCopyFileOutput) {
                log.info((Object)"Moving data from HDFS to the local file system");
                org.apache.hadoop.fs.Path baseOutputPath = new org.apache.hadoop.fs.Path(this.baseOutputDir);
                for (FileStatus status : FileSystem.get((Configuration)this.conf).listStatus(baseOutputPath)) {
                    if (!status.isDirectory()) continue;
                    String tableName = status.getPath().getName();
                    org.apache.hadoop.fs.Path hdfsPath = CopyTool.getPath(this.baseOutputDir, tableName);
                    org.apache.hadoop.fs.Path localPath = CopyTool.getPath(this.localBaseOutputDir, tableName);
                    log.info((Object)("HDFS directory: " + hdfsPath.toString()));
                    log.info((Object)("Local directory: " + localPath.toString()));
                    this.copyHdfsToLocal(hdfsPath, localPath);
                }
            }
            Date endTime = new Date();
            log.info((Object)("Job finished: " + endTime));
            log.info((Object)("The job took " + (endTime.getTime() - beginTime.getTime()) / 1000L + " seconds."));
            return 0;
        }
        log.error((Object)"Job failed!!!");
        return 1;
    }

    public void createTableIfNeeded(String childTableName) throws IOException {
        try {
            Configuration childConfig = MergeToolMapper.getChildConfig(this.conf);
            AccumuloRdfConfiguration childAccumuloRdfConfiguration = new AccumuloRdfConfiguration(childConfig);
            childAccumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
            Connector childConnector = AccumuloRyaUtils.setupConnector(childAccumuloRdfConfiguration);
            if (!childConnector.tableOperations().exists(childTableName)) {
                log.info((Object)("Creating table: " + childTableName));
                childConnector.tableOperations().create(childTableName);
                log.info((Object)("Created table: " + childTableName));
                log.info((Object)("Granting authorizations to table: " + childTableName));
                childConnector.securityOperations().grantTablePermission(this.childUserName, childTableName, TablePermission.WRITE);
                log.info((Object)("Granted authorizations to table: " + childTableName));
            }
        }
        catch (AccumuloException | AccumuloSecurityException | TableExistsException e) {
            throw new IOException(e);
        }
    }

    private void setupSplitsFile(Job job, TableOperations parentTableOperations, String parentTableName, String childTableName) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.setPermission(CopyTool.getPath(this.baseOutputDir, childTableName), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        org.apache.hadoop.fs.Path splitsPath = CopyTool.getPath(this.baseOutputDir, childTableName, "splits.txt");
        Collection splits = parentTableOperations.listSplits(parentTableName, 100);
        log.info((Object)("Creating splits file at: " + splitsPath));
        try (PrintStream out = new PrintStream(new BufferedOutputStream((OutputStream)fs.create(splitsPath)));){
            for (Text split : splits) {
                String encoded = new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)split)));
                out.println(encoded);
            }
        }
        fs.setPermission(splitsPath, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        String userDir = System.getProperty("user.dir");
        Files.deleteIfExists(new File(userDir, "splits.txt").toPath());
        job.setPartitionerClass(KeyRangePartitioner.class);
        KeyRangePartitioner.setSplitFile((Job)job, (String)splitsPath.toString());
        job.setNumReduceTasks(splits.size() + 1);
    }

    public static org.apache.hadoop.fs.Path getPath(String first, String ... more) {
        Path path = Paths.get(first, more);
        String stringPath = FilenameUtils.separatorsToUnix((String)path.toAbsolutePath().toString());
        org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(stringPath);
        return hadoopPath;
    }

    public void importFilesToChildTable(String childTableName) throws Exception {
        Configuration childConfig = MergeToolMapper.getChildConfig(this.conf);
        AccumuloRdfConfiguration childAccumuloRdfConfiguration = new AccumuloRdfConfiguration(childConfig);
        childAccumuloRdfConfiguration.setTablePrefix(this.childTablePrefix);
        Connector childConnector = AccumuloRyaUtils.setupConnector(childAccumuloRdfConfiguration);
        TableOperations childTableOperations = childConnector.tableOperations();
        org.apache.hadoop.fs.Path localWorkDir = CopyTool.getPath(this.localCopyFileImportDir, childTableName);
        org.apache.hadoop.fs.Path hdfsBaseWorkDir = CopyTool.getPath(this.baseImportDir, childTableName);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (fs.exists(hdfsBaseWorkDir)) {
            fs.delete(hdfsBaseWorkDir, true);
        }
        log.info((Object)("Importing from the local directory: " + localWorkDir));
        log.info((Object)("Importing to the HDFS directory: " + hdfsBaseWorkDir));
        this.copyLocalToHdfs(localWorkDir, hdfsBaseWorkDir);
        org.apache.hadoop.fs.Path files = CopyTool.getPath(hdfsBaseWorkDir.toString(), "files");
        org.apache.hadoop.fs.Path failures = CopyTool.getPath(hdfsBaseWorkDir.toString(), "failures");
        FsShell shell = new FsShell(this.conf);
        shell.run(new String[]{"-chmod", "777", hdfsBaseWorkDir.toString()});
        if (fs.exists(failures)) {
            fs.delete(failures, true);
        }
        fs.mkdirs(failures);
        childTableOperations.importDirectory(childTableName, files.toString(), failures.toString(), false);
    }

    public void copyLocalToHdfs(org.apache.hadoop.fs.Path localInputPath, org.apache.hadoop.fs.Path hdfsOutputPath) throws IOException {
        CopyTool.copyLocalToHdfs(localInputPath, hdfsOutputPath, this.conf);
    }

    public static void copyLocalToHdfs(org.apache.hadoop.fs.Path localInputPath, org.apache.hadoop.fs.Path hdfsOutputPath, Configuration configuration) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)configuration);
        fs.copyFromLocalFile(localInputPath, hdfsOutputPath);
    }

    public void copyHdfsToLocal(org.apache.hadoop.fs.Path hdfsInputPath, org.apache.hadoop.fs.Path localOutputPath) throws IOException {
        CopyTool.copyHdfsToLocal(hdfsInputPath, localOutputPath, this.conf);
    }

    public static void copyHdfsToLocal(org.apache.hadoop.fs.Path hdfsInputPath, org.apache.hadoop.fs.Path localOutputPath, Configuration configuration) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)configuration);
        fs.copyToLocalFile(hdfsInputPath, localOutputPath);
    }

    protected void setupAccumuloInput(Job job) throws AccumuloSecurityException {
        if (this.useCopyFileImport) {
            try {
                FileInputFormat.setInputPaths((Job)job, (String)this.localCopyFileImportDir);
            }
            catch (IOException e) {
                log.error((Object)"Failed to set copy file import directory", (Throwable)e);
            }
        } else {
            IteratorSetting setting;
            if (!this.hdfsInput) {
                job.setInputFormatClass(AccumuloInputFormat.class);
            } else {
                job.setInputFormatClass(AccumuloHDFSFileInputFormat.class);
            }
            AbstractInputFormat.setConnectorInfo((Job)job, (String)this.userName, (AuthenticationToken)new PasswordToken((CharSequence)this.pwd));
            InputFormatBase.setInputTableName((Job)job, (String)RdfCloudTripleStoreUtils.layoutPrefixToTable((RdfCloudTripleStoreConstants.TABLE_LAYOUT)this.rdfTableLayout, (String)this.tablePrefix));
            AbstractInputFormat.setScanAuthorizations((Job)job, (Authorizations)this.authorizations);
            if (!this.mock) {
                AbstractInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(this.instance).withZkHosts(this.zk));
            } else {
                AbstractInputFormat.setMockInstance((Job)job, (String)this.instance);
            }
            if (this.ttl != null) {
                setting = new IteratorSetting(1, "fi", AgeOffFilter.class);
                AgeOffFilter.setTTL((IteratorSetting)setting, (Long)Long.valueOf(this.ttl));
                InputFormatBase.addIterator((Job)job, (IteratorSetting)setting);
            }
            if (this.startTime != null) {
                setting = CopyTool.getStartTimeSetting(this.startTime);
                InputFormatBase.addIterator((Job)job, (IteratorSetting)setting);
            }
            for (IteratorSetting iteratorSetting : AccumuloRyaUtils.COMMON_REG_EX_FILTER_SETTINGS) {
                InputFormatBase.addIterator((Job)job, (IteratorSetting)iteratorSetting);
            }
        }
    }

    protected void setupMultiTableInputFormat(Job job, AccumuloQueryRuleset rules) throws AccumuloSecurityException {
        AbstractInputFormat.setConnectorInfo((Job)job, (String)this.userName, (AuthenticationToken)new PasswordToken((CharSequence)this.pwd));
        AbstractInputFormat.setScanAuthorizations((Job)job, (Authorizations)this.authorizations);
        if (!this.mock) {
            AbstractInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(this.instance).withZkHosts(this.zk));
        } else {
            AbstractInputFormat.setMockInstance((Job)job, (String)this.instance);
        }
        Map<String, InputTableConfig> configs = rules.getInputConfigs();
        LinkedList<IteratorSetting> additionalSettings = new LinkedList<IteratorSetting>((Collection<IteratorSetting>)AccumuloRyaUtils.COMMON_REG_EX_FILTER_SETTINGS);
        if (this.ttl != null) {
            IteratorSetting ttlSetting = new IteratorSetting(1, "fi", AgeOffFilter.class);
            AgeOffFilter.setTTL((IteratorSetting)ttlSetting, (Long)Long.valueOf(this.ttl));
            additionalSettings.add(ttlSetting);
        }
        if (this.startTime != null) {
            IteratorSetting startTimeSetting = CopyTool.getStartTimeSetting(this.startTime);
            additionalSettings.add(startTimeSetting);
        }
        for (Map.Entry<String, InputTableConfig> entry : configs.entrySet()) {
            List iterators = entry.getValue().getIterators();
            iterators.addAll(additionalSettings);
            entry.getValue().setIterators(iterators);
        }
        AccumuloMultiTableInputFormat.setInputTableConfigs((Job)job, configs);
        job.setInputFormatClass(AccumuloMultiTableInputFormat.class);
    }

    protected void setupAccumuloOutput(Job job, String outputTable) throws AccumuloSecurityException {
        AccumuloOutputFormat.setConnectorInfo((Job)job, (String)this.childUserName, (AuthenticationToken)new PasswordToken((CharSequence)this.childPwd));
        AccumuloOutputFormat.setCreateTables((Job)job, (boolean)true);
        AccumuloOutputFormat.setDefaultTableName((Job)job, (String)outputTable);
        if (!this.childMock) {
            AccumuloOutputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)new ClientConfiguration(new org.apache.commons.configuration.Configuration[0]).withInstance(this.childInstance).withZkHosts(this.childZk));
        } else {
            AccumuloOutputFormat.setMockInstance((Job)job, (String)this.childInstance);
        }
        if (this.useCopyFileOutput) {
            log.info((Object)"Using file output format mode.");
            if (StringUtils.isNotBlank((String)this.baseOutputDir)) {
                org.apache.hadoop.fs.Path baseOutputPath;
                org.apache.hadoop.fs.Path filesOutputPath;
                if (StringUtils.isNotBlank((String)outputTable)) {
                    filesOutputPath = CopyTool.getPath(this.baseOutputDir, outputTable, "files");
                    baseOutputPath = filesOutputPath.getParent();
                    job.setOutputFormatClass(AccumuloFileOutputFormat.class);
                } else {
                    baseOutputPath = filesOutputPath = CopyTool.getPath(this.baseOutputDir, new String[0]);
                    LazyOutputFormat.setOutputFormatClass((Job)job, AccumuloFileOutputFormat.class);
                    MultipleOutputs.setCountersEnabled((Job)job, (boolean)true);
                }
                log.info((Object)("File output destination: " + filesOutputPath));
                if (this.useCopyFileOutputDirectoryClear) {
                    try {
                        this.clearOutputDir(baseOutputPath);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error clearing out output path.", (Throwable)e);
                    }
                }
                try {
                    FileSystem fs = FileSystem.get((Configuration)this.conf);
                    fs.mkdirs(filesOutputPath.getParent());
                    fs.setPermission(filesOutputPath.getParent(), new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
                }
                catch (IOException e) {
                    log.error((Object)"Failed to set permission for output path.", (Throwable)e);
                }
                FileOutputFormat.setOutputPath((Job)job, (org.apache.hadoop.fs.Path)filesOutputPath);
                if (StringUtils.isNotBlank((String)this.compressionType)) {
                    if (CopyTool.isValidCompressionType(this.compressionType)) {
                        log.info((Object)("File compression type: " + this.compressionType));
                        AccumuloFileOutputFormat.setCompressionType((Job)job, (String)this.compressionType);
                    } else {
                        log.warn((Object)("Invalid compression type: " + this.compressionType));
                    }
                }
            }
        } else {
            log.info((Object)"Using accumulo output format mode.");
            job.setOutputFormatClass(AccumuloOutputFormat.class);
        }
    }

    public int setupAndRun(String[] args) {
        int returnCode = -1;
        try {
            Configuration conf = new Configuration();
            Set<String> toolArgs = ToolConfigUtils.getUserArguments(conf, args);
            if (!toolArgs.isEmpty()) {
                String parameters = Joiner.on((String)"\r\n\t").join(toolArgs);
                log.info((Object)("Running Copy Tool with the following parameters...\r\n\t" + parameters));
            }
            returnCode = ToolRunner.run((Configuration)conf, (Tool)this, (String[])args);
        }
        catch (Exception e) {
            log.error((Object)"Error running copy tool", (Throwable)e);
        }
        return returnCode;
    }

    public static void main(String[] args) {
        String log4jConfiguration = System.getProperties().getProperty("log4j.configuration");
        if (StringUtils.isNotBlank((String)log4jConfiguration)) {
            String parsedConfiguration = StringUtils.removeStart((String)log4jConfiguration, (String)"file:");
            File configFile = new File(parsedConfiguration);
            if (configFile.exists()) {
                DOMConfigurator.configure((String)parsedConfiguration);
            } else {
                BasicConfigurator.configure();
            }
        }
        log.info((Object)"Starting Copy Tool");
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                log.error((Object)("Uncaught exception in " + thread.getName()), throwable);
            }
        });
        CopyTool copyTool = new CopyTool();
        int returnCode = copyTool.setupAndRun(args);
        log.info((Object)"Finished running Copy Tool");
        System.exit(returnCode);
    }

    public static IteratorSetting getStartTimeSetting(String startTimeString) {
        Date date = null;
        try {
            date = MergeTool.START_TIME_FORMATTER.parse(startTimeString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't parse " + startTimeString, e);
        }
        return CopyTool.getStartTimeSetting(date);
    }

    public static IteratorSetting getStartTimeSetting(Date date) {
        return CopyTool.getStartTimeSetting(date.getTime());
    }

    public static IteratorSetting getStartTimeSetting(long time) {
        IteratorSetting setting = new IteratorSetting(1, "startTimeIterator", TimestampFilter.class);
        TimestampFilter.setStart((IteratorSetting)setting, (long)time, (boolean)true);
        TimestampFilter.setEnd((IteratorSetting)setting, (long)Long.MAX_VALUE, (boolean)true);
        return setting;
    }

    private static boolean isValidCompressionType(String compressionType) {
        for (Compression.Algorithm algorithm : Compression.Algorithm.values()) {
            if (!algorithm.getName().equals(compressionType)) continue;
            return true;
        }
        return false;
    }

    private void clearOutputDir(org.apache.hadoop.fs.Path path) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(path, true);
    }

    private Instance createChildInstance(Configuration config) throws Exception {
        MockInstance instance = null;
        String instanceTypeProp = config.get(CREATE_CHILD_INSTANCE_TYPE_PROP);
        String childAuth = config.get("ac.auth.child");
        if (StringUtils.isBlank((String)instanceTypeProp)) {
            instanceTypeProp = InstanceType.DISTRIBUTION.toString();
        }
        InstanceType instanceType = InstanceType.fromName(instanceTypeProp);
        switch (instanceType) {
            case DISTRIBUTION: {
                if (this.childInstance == null) {
                    throw new IllegalArgumentException("Must specify instance name for distributed mode");
                }
                if (this.childZk == null) {
                    throw new IllegalArgumentException("Must specify ZooKeeper hosts for distributed mode");
                }
                instance = new ZooKeeperInstance(this.childInstance, this.childZk);
                break;
            }
            case MINI: {
                this.childAccumuloInstanceDriver = new AccumuloInstanceDriver("Child", false, true, false, false, this.childUserName, this.childPwd, this.childInstance, this.childTablePrefix, childAuth);
                this.childAccumuloInstanceDriver.setUpInstance();
                this.childAccumuloInstanceDriver.setUpTables();
                this.childZk = this.childAccumuloInstanceDriver.getZooKeepers();
                MergeTool.setDuplicateKeysForProperty(config, "ac.zk.child", this.childZk);
                instance = new ZooKeeperInstance(this.childInstance, this.childZk);
                break;
            }
            case MOCK: {
                instance = new MockInstance(this.childInstance);
                break;
            }
            default: {
                throw new AccumuloException("Unexpected instance type: " + (Object)((Object)instanceType));
            }
        }
        return instance;
    }

    public AccumuloInstanceDriver getChildAccumuloInstanceDriver() {
        return this.childAccumuloInstanceDriver;
    }

    public void shutdown() throws Exception {
        if (this.childAccumuloInstanceDriver != null) {
            this.childAccumuloInstanceDriver.tearDown();
        }
    }
}

