/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.accumulo.mr.merge;

import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.util.Tool;
import org.apache.rya.accumulo.AccumuloRdfConstants;
import org.apache.rya.accumulo.mr.AbstractAccumuloMRTool;
import org.apache.rya.api.RdfCloudTripleStoreConstants;

public abstract class AbstractDualInstanceAccumuloMRTool
extends AbstractAccumuloMRTool
implements Tool {
    protected String childUserName = "root";
    protected String childPwd = "root";
    protected String childInstance = "instance";
    protected String childZk = "zoo";
    protected Authorizations childAuthorizations = AccumuloRdfConstants.ALL_AUTHORIZATIONS;
    protected boolean childMock = false;
    protected String childTablePrefix = "rya_";

    protected void init() {
        String childAuth;
        super.init();
        this.childZk = this.conf.get("ac.zk.child", this.childZk);
        this.childInstance = this.conf.get("ac.instance.child", this.childInstance);
        this.childUserName = this.conf.get("ac.username.child", this.childUserName);
        this.childPwd = this.conf.get("ac.pwd.child", this.pwd);
        this.childMock = this.conf.getBoolean("ac.mock.child", this.mock);
        this.childTablePrefix = this.conf.get("rdf.tablePrefix.child", this.childTablePrefix);
        if (this.childTablePrefix != null) {
            RdfCloudTripleStoreConstants.prefixTables((String)this.childTablePrefix);
        }
        if ((childAuth = this.conf.get("ac.auth.child")) != null) {
            this.childAuthorizations = new Authorizations(childAuth.split(","));
        }
    }

    public abstract int run(String[] var1) throws Exception;
}

