////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package org.apache.royale.html.staticControls.beads
{
	import org.apache.royale.core.IBeadView;
	import org.apache.royale.core.IStrand;
	import org.apache.royale.core.IUIBase;
	import org.apache.royale.core.UIBase;
	import org.apache.royale.html.Label;
	
	public class BoxGridView implements IBeadView
	{
		public function BoxGridView()
		{
		}
		
		private var label:Label;
		
		private var _strand:IStrand;
		public function set strand(value:IStrand):void
		{
			_strand = value;
			
			label = new Label();
			label.text = "BoxGrid";
			label.x = 0;
			label.y = 0;
			label.width = 100;
			label.height = 25;
			UIBase(_strand).addElement(label);
		}
		/**
		 * @royaleignorecoercion org.apache.royale.core.IUIBase
		 */
		public function get host():IUIBase
		{
			return _strand as IUIBase;
		}
	}
}
