/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import java.util.AbstractList;
import java.util.ArrayList;

public class StringIntArray
extends AbstractList<Object> {
    Object[] m_ar;
    int m_size = 0;
    double m_growthRatio = 1.6;

    public StringIntArray(Object[] ar) {
        this.m_ar = ar;
        this.m_size = this.m_ar.length;
    }

    public StringIntArray() {
        this(10);
    }

    public StringIntArray(int size) {
        this.m_ar = new Object[size];
        this.m_size = 0;
    }

    @Override
    public Object get(int at) {
        return this.m_ar[at];
    }

    @Override
    public int size() {
        return this.m_size;
    }

    public Object[] getElement(int at) {
        return (Object[])this.get(at);
    }

    public String getString(int at) {
        return (String)this.getElement(at)[0];
    }

    public Integer getInteger(int at) {
        return (Integer)this.getElement(at)[1];
    }

    public int getInt(int at) {
        return this.getInteger(at);
    }

    public ArrayList<Integer> elementsStartingWith(String s) {
        ArrayList<Integer> alist = new ArrayList<Integer>();
        for (int i = 0; i < this.m_size; ++i) {
            if (!this.getString(i).startsWith(s)) continue;
            alist.add(new Integer(i));
        }
        return alist;
    }

    @Override
    public void add(int at, Object e) {
        this.ensureCapacity(1);
        int size = this.size();
        System.arraycopy(this.m_ar, at, this.m_ar, at + 1, size - at);
        this.m_ar[at] = e;
        ++this.m_size;
    }

    @Override
    public Object remove(int at) {
        int size = this.size();
        Object o = this.m_ar[at];
        System.arraycopy(this.m_ar, at + 1, this.m_ar, at, size - at + 1);
        --this.m_size;
        return o;
    }

    void ensureCapacity(int amt) {
        int size = this.size();
        int newSize = amt + size;
        if (newSize > this.m_ar.length) {
            double growTo = (double)this.m_ar.length * this.m_growthRatio;
            if ((double)newSize > growTo) {
                growTo += (double)newSize + (double)newSize * this.m_growthRatio;
            }
            Object[] nAr = new Object[(int)growTo + 1];
            System.arraycopy(this.m_ar, 0, nAr, 0, this.m_ar.length);
            this.m_ar = nAr;
        }
    }
}

