/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.expression.ASTBuilder;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.PlayerFaultException;

public class ECMA {
    private static final double _2pow31 = Math.pow(2.0, 31.0);
    private static final double _2pow32 = Math.pow(2.0, 32.0);

    public static boolean isPrimitive(Value v) {
        Object o = (v = ECMA.safeValue(v, 1)).getValueAsObject();
        return o == Value.UNDEFINED || o == null || o instanceof Boolean || o instanceof Double || o instanceof String;
    }

    private static Value callFunction(Session session, Value v, String functionName, Value[] args, int isolateId) {
        v = ECMA.safeValue(v, isolateId);
        try {
            return session.getWorkerSession(isolateId).callFunction(v, functionName, args);
        }
        catch (PlayerDebugException e) {
            throw new ExpressionEvaluatorException(e);
        }
    }

    private static Value callValueOf(Session session, Value v, int isolateId) {
        v = ECMA.safeValue(v, isolateId);
        return ECMA.callFunction(session, v, "valueOf", new Value[0], isolateId);
    }

    private static Value callToString(Session session, Value v, int isolateId) {
        v = ECMA.safeValue(v, isolateId);
        return ECMA.callFunction(session, v, "toString", new Value[0], isolateId);
    }

    public static Value defaultValue(Session session, Value v, PreferredType optionalPreferredType, int isolateId) {
        String typename = (v = ECMA.safeValue(v, isolateId)).getTypeName();
        int at = typename.indexOf(64);
        if (at != -1) {
            typename = typename.substring(0, at);
        }
        if (optionalPreferredType == null) {
            optionalPreferredType = typename.equals("Date") ? PreferredType.STRING : PreferredType.NUMBER;
        }
        if (optionalPreferredType == PreferredType.NUMBER) {
            Value result = ECMA.callValueOf(session, v, isolateId);
            if (ECMA.isPrimitive(result)) {
                return result;
            }
            result = ECMA.callToString(session, v, isolateId);
            if (ECMA.isPrimitive(result)) {
                return result;
            }
            throw new RuntimeException(new PlayerFaultException(new ExceptionFault(ASTBuilder.getLocalizationManager().getLocalizedTextString("typeError"), false, null, isolateId)));
        }
        Value result = ECMA.callToString(session, v, isolateId);
        if (ECMA.isPrimitive(result)) {
            return result;
        }
        result = ECMA.callValueOf(session, v, isolateId);
        if (ECMA.isPrimitive(result)) {
            return result;
        }
        throw new RuntimeException(new PlayerFaultException(new ExceptionFault(ASTBuilder.getLocalizationManager().getLocalizedTextString("typeError"), false, null, isolateId)));
    }

    public static Value toPrimitive(Session session, Value v, PreferredType optionalPreferredType, int isolateId) {
        v = ECMA.safeValue(v, isolateId);
        switch (v.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return v;
            }
        }
        return ECMA.defaultValue(session, v, optionalPreferredType, isolateId);
    }

    public static boolean toBoolean(Value v) {
        v = ECMA.safeValue(v, 1);
        switch (v.getType()) {
            case 6: 
            case 7: {
                return false;
            }
            case 1: {
                return (Boolean)v.getValueAsObject();
            }
            case 0: {
                double d = (Double)v.getValueAsObject();
                return d != 0.0 && !Double.isNaN(d);
            }
            case 2: {
                return ((String)v.getValueAsObject()).length() != 0;
            }
        }
        return true;
    }

    public static double toNumber(Session session, Value v) {
        v = ECMA.safeValue(v, 1);
        switch (v.getType()) {
            case 7: {
                return Double.NaN;
            }
            case 6: {
                return 0.0;
            }
            case 1: {
                return (Boolean)v.getValueAsObject() != false ? 1.0 : 0.0;
            }
            case 0: {
                return (Double)v.getValueAsObject();
            }
            case 2: {
                String s = (String)v.getValueAsObject();
                if (s.length() == 0) {
                    return 0.0;
                }
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException e) {
                    return Double.NaN;
                }
            }
        }
        return ECMA.toNumber(session, ECMA.toPrimitive(session, v, PreferredType.NUMBER, v.getIsolateId()));
    }

    public static int toInt32(Session session, Value v) {
        double d = ECMA.toNumber(session, v = ECMA.safeValue(v, 1));
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double sign = Math.signum(d);
        d = Math.floor(Math.abs(d));
        d %= _2pow32;
        while (d >= _2pow31) {
            d -= _2pow32;
        }
        return (int)(sign * d);
    }

    public static long toUint32(Session session, Value v) {
        long n = ECMA.toInt32(session, v = ECMA.safeValue(v, 1));
        if (n < 0L) {
            n += 0x100000000L;
        }
        return n;
    }

    public static String toString(Session session, Value v) {
        v = ECMA.safeValue(v, 1);
        switch (v.getType()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return v.getValueAsString();
            }
            case 0: {
                double d = (Double)v.getValueAsObject();
                if (d == (double)((long)d)) {
                    return Long.toString((long)d);
                }
                return v.toString();
            }
        }
        return ECMA.toString(session, ECMA.toPrimitive(session, v, PreferredType.STRING, v.getIsolateId()));
    }

    public static Value lessThan(Session session, Value x, Value y) {
        x = ECMA.safeValue(x, 1);
        y = ECMA.safeValue(y, 1);
        Value px = ECMA.toPrimitive(session, x, PreferredType.NUMBER, x.getIsolateId());
        Value py = ECMA.toPrimitive(session, y, PreferredType.NUMBER, y.getIsolateId());
        if (px.getType() == 2 && py.getType() == 2) {
            String sy;
            String sx = px.getValueAsString();
            return DValue.forPrimitive(new Boolean(sx.compareTo(sy = py.getValueAsString()) < 0), x.getIsolateId());
        }
        double dx = ECMA.toNumber(session, px);
        double dy = ECMA.toNumber(session, py);
        if (Double.isNaN(dx) || Double.isNaN(dy)) {
            return DValue.forPrimitive(Value.UNDEFINED, x.getIsolateId());
        }
        return DValue.forPrimitive(new Boolean(dx < dy), x.getIsolateId());
    }

    public static boolean equals(Session session, Value xv, Value yv) {
        xv = ECMA.safeValue(xv, 1);
        yv = ECMA.safeValue(yv, 1);
        Object x = xv.getValueAsObject();
        Object y = yv.getValueAsObject();
        if (xv.getType() == yv.getType()) {
            if (x == Value.UNDEFINED) {
                return true;
            }
            if (x == null) {
                return true;
            }
            if (x instanceof Double) {
                double dy;
                double dx = (Double)x;
                return dx == (dy = ((Double)y).doubleValue());
            }
            if (x instanceof String || x instanceof Boolean) {
                return x.equals(y);
            }
            if (xv.getId() != -1L || yv.getId() != -1L) {
                return xv.getId() == yv.getId();
            }
            return false;
        }
        if (x == null && y == Value.UNDEFINED) {
            return true;
        }
        if (x == Value.UNDEFINED && y == null) {
            return true;
        }
        if (x instanceof Double && y instanceof String) {
            double dy;
            double dx = (Double)x;
            return dx == (dy = ECMA.toNumber(session, yv));
        }
        if (x instanceof String && y instanceof Double) {
            double dy;
            double dx = ECMA.toNumber(session, xv);
            return dx == (dy = ((Double)y).doubleValue());
        }
        if (x instanceof Boolean) {
            return ECMA.equals(session, DValue.forPrimitive(new Double(ECMA.toNumber(session, xv)), xv.getIsolateId()), yv);
        }
        if (y instanceof Boolean) {
            return ECMA.equals(session, xv, DValue.forPrimitive(new Double(ECMA.toNumber(session, yv)), xv.getIsolateId()));
        }
        if ((x instanceof String || x instanceof Double) && yv.getType() == 3) {
            return ECMA.equals(session, xv, ECMA.toPrimitive(session, yv, null, yv.getIsolateId()));
        }
        if (xv.getType() == 3 && (y instanceof String || y instanceof Double)) {
            return ECMA.equals(session, ECMA.toPrimitive(session, xv, null, xv.getIsolateId()), yv);
        }
        return false;
    }

    public static boolean strictEquals(Value xv, Value yv) {
        xv = ECMA.safeValue(xv, 1);
        yv = ECMA.safeValue(yv, 1);
        Object x = xv.getValueAsObject();
        Object y = yv.getValueAsObject();
        if (xv.getType() == yv.getType()) {
            if (x == Value.UNDEFINED) {
                return true;
            }
            if (x == null) {
                return true;
            }
            if (x instanceof Double) {
                double dy;
                double dx = (Double)x;
                return dx == (dy = ((Double)y).doubleValue());
            }
            if (x instanceof String || x instanceof Boolean) {
                return x.equals(y);
            }
            if (xv.getId() != -1L || yv.getId() != -1L) {
                return xv.getId() == yv.getId();
            }
            return false;
        }
        return false;
    }

    public static Value safeValue(Value v, int isolateId) {
        if (v == null) {
            v = DValue.forPrimitive(null, isolateId);
            assert (v != null);
        }
        return v;
    }

    private static enum PreferredType {
        NUMBER,
        STRING;

    }
}

