/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.DebuggerExpressionEvaluator;
import flash.tools.debugger.expression.DebuggerValue;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flash.tools.debugger.expression.ValueExp;
import java.util.HashSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;

class DebuggerExpression
implements ValueExp {
    private static final HashSet<ASTNodeID> ASSIGN_OPRATORS = new HashSet();
    private IASNode m_programNode;
    private boolean m_lookupMembers = false;

    DebuggerExpression() {
    }

    public IASNode getProgramNode() {
        return this.m_programNode;
    }

    public void setProgramNode(IASNode programNode) {
        this.m_programNode = programNode;
    }

    @Override
    public boolean isLookupMembers() {
        return this.m_lookupMembers;
    }

    public void setLookupMembers(boolean value) {
        this.m_lookupMembers = value;
    }

    @Override
    public boolean containsAssignment() {
        return this.containsAssignment(this.m_programNode);
    }

    private boolean containsAssignment(IASNode node) {
        if (ASSIGN_OPRATORS.contains((Object)node.getNodeID())) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.containsAssignment(node.getChild(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object evaluate(Context context) throws NumberFormatException, NoSuchVariableException, PlayerFaultException, PlayerDebugException {
        DebuggerValue value;
        block9: {
            DebuggerExpressionEvaluator eval = new DebuggerExpressionEvaluator();
            value = eval.evaluate(context, this.m_programNode);
            if (!this.isLookupMembers()) break block9;
            Object object = context.lookupMembers(value.debuggerValue);
            return object;
        }
        try {
            Object object = value.debuggerValue;
            return object;
        }
        catch (Exception e) {
            if (e.getCause() instanceof NumberFormatException) {
                throw (NumberFormatException)e.getCause();
            }
            if (e.getCause() instanceof NoSuchVariableException) {
                throw (NoSuchVariableException)e.getCause();
            }
            if (e.getCause() instanceof PlayerFaultException) {
                throw (PlayerFaultException)e.getCause();
            }
            if (e.getCause() instanceof PlayerDebugException) {
                throw (PlayerDebugException)e.getCause();
            }
            e.printStackTrace();
            throw new PlayerDebugException(e.getLocalizedMessage());
        }
    }

    static {
        ASSIGN_OPRATORS.add(ASTNodeID.Op_AssignId);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LeftShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_RightShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_UnsignedRightShiftAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_MultiplyAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_DivideAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_ModuloAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseAndAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseXorAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_BitwiseOrAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_AddAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_SubtractAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LogicalAndAssignID);
        ASSIGN_OPRATORS.add(ASTNodeID.Op_LogicalOrAssignID);
    }
}

