/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Isolate;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DIsolate;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.ConsoleErrorFault;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.DivideByZeroFault;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.FileListModifiedEvent;
import flash.tools.debugger.events.InvalidWithFault;
import flash.tools.debugger.events.IsolateCreateEvent;
import flash.tools.debugger.events.IsolateExitEvent;
import flash.tools.debugger.events.ProtoLimitFault;
import flash.tools.debugger.events.RecursionLimitFault;
import flash.tools.debugger.events.ScriptTimeoutFault;
import flash.tools.debugger.events.StackUnderFlowFault;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import flash.util.Trace;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DManager
implements DProtocolNotifierIF,
SourceLocator {
    private final HashMap<String, String> m_parms;
    private final HashMap<Integer, DIsolate> m_isolates;
    private Isolate m_activeIsolate = DEFAULT_ISOLATE;
    private LinkedList<DebugEvent> m_event;
    private SourceLocator m_sourceLocator;
    private boolean m_squelchEnabled;
    private int m_playerVersion;
    private boolean m_sourceListModified;
    private byte[] m_actions;
    private String[] m_lastConstantPool;
    private String m_uri;
    private byte[] m_swf;
    private byte[] m_swd;
    private Map<String, String> m_options = new HashMap<String, String>();
    public static final String ARGUMENTS_MARKER = "$arguments";
    public static final String SCOPE_CHAIN_MARKER = "$scopechain";
    private static final DIsolate DEFAULT_ISOLATE = DIsolate.DEFAULT_ISOLATE;
    private Isolate m_inIsolate = DEFAULT_ISOLATE;
    private final Object m_inIsolateLock;
    private final Object m_activeIsolateLock;
    private boolean m_wideLines;
    private DManagerIsolateState m_mainState;
    private HashMap<Integer, DManagerIsolateState> m_isolateState;

    private DManagerIsolateState getIsolateState(int isolateId) {
        if (isolateId == 1) {
            return this.m_mainState;
        }
        DManagerIsolateState isolateState = null;
        if (!this.m_isolateState.containsKey(isolateId)) {
            isolateState = new DManagerIsolateState();
            this.m_isolateState.put(isolateId, isolateState);
        } else {
            isolateState = this.m_isolateState.get(isolateId);
        }
        return isolateState;
    }

    public DManager() {
        this.m_parms = new HashMap();
        this.m_isolates = new HashMap();
        this.m_isolates.put(1, DEFAULT_ISOLATE);
        this.m_event = new LinkedList();
        this.m_sourceLocator = null;
        this.m_squelchEnabled = false;
        this.m_lastConstantPool = null;
        this.m_playerVersion = -1;
        this.m_isolateState = new HashMap();
        this.m_mainState = new DManagerIsolateState();
        this.m_isolateState.put(1, this.m_mainState);
        this.m_inIsolateLock = new Object();
        this.m_activeIsolateLock = new Object();
        this.m_wideLines = false;
    }

    public void setWideLines(boolean value) {
        this.m_wideLines = value;
    }

    public String getURI() {
        return this.m_uri;
    }

    public byte[] getSWF() {
        return this.m_swf;
    }

    public byte[] getSWD() {
        return this.m_swd;
    }

    public byte[] getActions() {
        return this.m_actions;
    }

    public int getVersion() {
        return this.m_playerVersion;
    }

    public SourceLocator getSourceLocator() {
        return this.m_sourceLocator;
    }

    public void setSourceLocator(SourceLocator sl) {
        this.m_sourceLocator = sl;
    }

    public void enableChildAttach(boolean enable, int isolateId) {
        this.getIsolateState((int)isolateId).m_attachChildren = enable;
    }

    public DVariable lastVariable(int isolateId) {
        return this.getIsolateState((int)isolateId).m_lastInGetVariable;
    }

    public void clearLastVariable(int isolateId) {
        this.getIsolateState((int)isolateId).m_lastInGetVariable = null;
    }

    public DVariable lastFunctionCall(int isolateId) {
        return this.getIsolateState((int)isolateId).m_lastInCallFunction;
    }

    public void clearLastFunctionCall(int isolateId) {
        this.getIsolateState((int)isolateId).m_lastInCallFunction = null;
    }

    public DVariable lastBinaryOp(int isolateId) {
        return this.getIsolateState((int)isolateId).m_lastInBinaryOp;
    }

    public void clearLastBinaryOp(int isolateId) {
        this.getIsolateState((int)isolateId).m_lastInBinaryOp = null;
    }

    void freeCaches(int isolateId) {
        this.clearFrames(isolateId);
        this.freeValueCache(isolateId);
    }

    void freeValueCache(int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        state.m_previousValues = state.m_values;
        state.m_values = new HashMap<Long, DValue>();
        int size = this.getFrameCount(isolateId);
        for (int i = 0; i < size; ++i) {
            this.getFrame(i, isolateId).markStale();
        }
    }

    void continuing(int isolateId) {
        this.freeCaches(isolateId);
        this.getIsolateState((int)isolateId).m_suspendInfo = null;
    }

    DValue getOrCreateValue(long id, int isolateId) {
        DValue v = this.getValue(id, isolateId);
        if (v == null) {
            v = new DValue(id, isolateId);
            this.putValue(id, v, isolateId);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo[] getSwfInfos(int isolateId) {
        ArrayList swfInfos;
        ArrayList arrayList = swfInfos = this.getIsolateState(isolateId).m_swfInfo;
        synchronized (arrayList) {
            return swfInfos.toArray(new DSwfInfo[swfInfos.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo getSwfInfo(int at, int isolateId) {
        ArrayList swfInfos;
        ArrayList arrayList = swfInfos = this.getIsolateState(isolateId).m_swfInfo;
        synchronized (arrayList) {
            return (DSwfInfo)swfInfos.get(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSwfInfoCount(int isolateId) {
        ArrayList swfInfos;
        ArrayList arrayList = swfInfos = this.getIsolateState(isolateId).m_swfInfo;
        synchronized (arrayList) {
            return swfInfos.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DSwfInfo getOrCreateSwfInfo(int at, int isolateId) {
        ArrayList swfInfos;
        ArrayList arrayList = swfInfos = this.getIsolateState(isolateId).m_swfInfo;
        synchronized (arrayList) {
            DSwfInfo i;
            DSwfInfo dSwfInfo = i = at > -1 && at < this.getSwfInfoCount(isolateId) ? this.getSwfInfo(at, isolateId) : null;
            if (i == null) {
                int n = at = at < 0 ? 0 : at;
                while (at >= swfInfos.size()) {
                    swfInfos.add(null);
                }
                i = new DSwfInfo(at, isolateId);
                swfInfos.set(at, i);
            }
            return i;
        }
    }

    DSwfInfo getActiveSwfInfo(int isolateId) {
        int count = this.getSwfInfoCount(isolateId);
        DSwfInfo swf = this.getIsolateState((int)isolateId).m_lastSwfInfo;
        if (swf == null) {
            swf = this.getOrCreateSwfInfo(count - 1, isolateId);
        }
        if (swf.hasAllSource()) {
            swf = this.getOrCreateSwfInfo(count, isolateId);
        }
        return swf;
    }

    void tieScriptsToSwf(DSwfInfo info, int isolateId) {
        if (!info.hasAllSource()) {
            int min = info.getFirstSourceId();
            int max = info.getLastSourceId();
            for (int i = min; i <= max; ++i) {
                DModule m = this.getSource(i, isolateId);
                if (m == null) continue;
                info.addSource(i, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSource(int swfIndex, int moduleId, int bitmap, String name, String text, int isolateId) {
        Map<Integer, DModule> source;
        Map<Integer, DModule> map = source = this.getIsolateState((int)isolateId).m_source;
        synchronized (map) {
            if (!source.containsKey(moduleId)) {
                DModule s = new DModule(this, moduleId, bitmap, name, text, isolateId);
                source.put(moduleId, s);
                DSwfInfo swf = swfIndex == -1 ? this.getActiveSwfInfo(isolateId) : this.getOrCreateSwfInfo(swfIndex, isolateId);
                swf.addSource(moduleId, s);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSource(int id, int isolateId) {
        Map<Integer, DModule> source;
        Map<Integer, DModule> map = source = this.getIsolateState((int)isolateId).m_source;
        synchronized (map) {
            try {
                source.remove(id);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule getSource(int id, int isolateId) {
        Map<Integer, DModule> source;
        Map<Integer, DModule> map = source = this.getIsolateState((int)isolateId).m_source;
        synchronized (map) {
            return source.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule[] getSources() {
        Map<Integer, DModule> source;
        Map<Integer, DModule> map = source = this.getIsolateState((int)1).m_source;
        synchronized (map) {
            this.m_sourceListModified = false;
            int count = source.size();
            DModule[] ar = new DModule[count];
            count = 0;
            for (DModule sf : source.values()) {
                ar[count++] = sf;
            }
            return ar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sourceListModified() {
        Map<Integer, DModule> source;
        Map<Integer, DModule> map = source = this.getIsolateState((int)1).m_source;
        synchronized (map) {
            return this.m_sourceListModified;
        }
    }

    public DValue getValue(long id, int isolateId) {
        return this.getIsolateState((int)isolateId).m_values.get(id);
    }

    public DValue getPreviousValue(long id, int isolateId) {
        return this.getIsolateState((int)isolateId).m_previousValues.get(id);
    }

    void putValue(long id, DValue v, int isolateId) {
        if (id != -1L) {
            this.getIsolateState((int)isolateId).m_values.put(id, v);
        }
    }

    DValue removeValue(long id, int isolateId) {
        return this.getIsolateState((int)isolateId).m_values.remove((int)id);
    }

    void addVariableMember(long parentId, DVariable child, int isolateId) {
        DValue parent = this.getValue(parentId, isolateId);
        this.addVariableMember(parent, child, isolateId);
    }

    void addVariableMember(DValue parent, DVariable child, int isolateId) {
        if (this.getIsolateState((int)isolateId).m_attachChildren) {
            DValue childValue;
            long childId;
            if (parent != null) {
                DVariable existingChildWithSameName = parent.findMember(child.getName());
                if (existingChildWithSameName != null) {
                    int existingScope = existingChildWithSameName.getScope();
                    int newScope = child.getScope();
                    if (existingScope == 0x2000000 && newScope == 0) {
                        parent.addMember(child);
                    } else if (existingScope == 0 && newScope == 0x2000000) {
                        child.makePublic();
                        parent.addMember(child);
                    } else if (existingScope != 0x800000 && existingScope == newScope) {
                        parent.addMember(child);
                    } else if (existingScope == 0x800000 && existingScope == newScope) {
                        parent.addInheritedPrivateMember(child);
                    }
                } else {
                    parent.addMember(child);
                }
            }
            if ((childId = (childValue = (DValue)child.getValue()).getId()) != -1L) {
                DValue existingValue = this.getValue(childId, isolateId);
                if (existingValue != null) {
                    assert (existingValue == childValue);
                } else {
                    this.putValue(childId, childValue, isolateId);
                }
            }
        }
    }

    void addVariableMember(long parentId, DVariable child, long doubleAsId, int isolateId) {
        this.addVariableMember(parentId, child, isolateId);
        if (this.getIsolateState((int)isolateId).m_attachChildren) {
            this.putValue(doubleAsId, (DValue)child.getValue(), isolateId);
        }
    }

    public String[] getConstantPool() {
        return this.m_lastConstantPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation getBreakpoint(int id, int isolateId) {
        ArrayList<DLocation> breakpoints;
        ArrayList<DLocation> arrayList = breakpoints = this.getIsolateState((int)isolateId).m_breakpoints;
        synchronized (arrayList) {
            DLocation loc = null;
            int which = this.findBreakpoint(id, isolateId);
            if (which > -1) {
                loc = breakpoints.get(which);
            }
            return loc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findBreakpoint(int id, int isolateId) {
        ArrayList<DLocation> breakpoints;
        ArrayList<DLocation> arrayList = breakpoints = this.getIsolateState((int)isolateId).m_breakpoints;
        synchronized (arrayList) {
            int which = -1;
            int size = breakpoints.size();
            for (int i = 0; which < 0 && i < size; ++i) {
                DLocation l = breakpoints.get(i);
                if (l.getId() != id) continue;
                which = i;
            }
            return which;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DLocation removeBreakpoint(int id, int isolateId) {
        ArrayList<DLocation> breakpoints;
        ArrayList<DLocation> arrayList = breakpoints = this.getIsolateState((int)isolateId).m_breakpoints;
        synchronized (arrayList) {
            DLocation loc = null;
            int which = this.findBreakpoint(id, isolateId);
            if (which > -1) {
                loc = breakpoints.get(which);
                breakpoints.remove(which);
            }
            return loc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(int id, DLocation l, int isolateId) {
        ArrayList<DLocation> breakpoints;
        ArrayList<DLocation> arrayList = breakpoints = this.getIsolateState((int)isolateId).m_breakpoints;
        synchronized (arrayList) {
            breakpoints.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation[] getBreakpoints(int isolateId) {
        ArrayList<DLocation> breakpoints;
        ArrayList<DLocation> arrayList = breakpoints = this.getIsolateState((int)isolateId).m_breakpoints;
        synchronized (arrayList) {
            return breakpoints.toArray(new DLocation[breakpoints.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch getWatchpoint(int at, int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        ArrayList arrayList = state.m_watchpoints;
        synchronized (arrayList) {
            return (DWatch)state.m_watchpoints.get(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWatchpointCount(int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        ArrayList arrayList = state.m_watchpoints;
        synchronized (arrayList) {
            return state.m_watchpoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch[] getWatchpoints(int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        ArrayList arrayList = state.m_watchpoints;
        synchronized (arrayList) {
            return state.m_watchpoints.toArray(new DWatch[state.m_watchpoints.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addWatchpoint(DWatch w, int isolateId) {
        ArrayList lockObject;
        ArrayList arrayList = lockObject = this.getIsolateState(isolateId).m_watchpoints;
        synchronized (arrayList) {
            return lockObject.add(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DWatch removeWatchpoint(int tag, int isolateId) {
        ArrayList lockObject;
        ArrayList arrayList = lockObject = this.getIsolateState(isolateId).m_watchpoints;
        synchronized (arrayList) {
            DWatch w = null;
            int at = this.findWatchpoint(tag, isolateId);
            if (at > -1) {
                w = (DWatch)lockObject.remove(at);
            }
            return w;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findWatchpoint(int tag, int isolateId) {
        ArrayList lockObject;
        ArrayList arrayList = lockObject = this.getIsolateState(isolateId).m_watchpoints;
        synchronized (arrayList) {
            int at = -1;
            int size = this.getWatchpointCount(isolateId);
            for (int i = 0; i < size && at < 0; ++i) {
                DWatch w = this.getWatchpoint(i, isolateId);
                if (w.getTag() != tag) continue;
                at = i;
            }
            return at;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate getIsolate(int at) {
        if (at == 1) {
            return DEFAULT_ISOLATE;
        }
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.get(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate getOrCreateIsolate(int at) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            if (this.m_isolates.containsKey(at)) {
                return this.m_isolates.get(at);
            }
            DIsolate isolate = new DIsolate(at);
            this.m_isolates.put(at, isolate);
            return isolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIsolateCount() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate[] getIsolates() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.values().toArray(new DIsolate[this.m_isolates.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addIsolate(DIsolate t) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            this.m_isolates.put(t.getId(), t);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearIsolates() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            this.m_isolates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DIsolate removeIsolate(int id) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            DIsolate t = null;
            int at = this.findIsolate(id);
            if (at > -1) {
                t = this.m_isolates.remove(at);
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findIsolate(int id) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            if (this.m_isolates.containsKey(id)) {
                return id;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveIsolate(Isolate t) {
        Object object = this.m_activeIsolateLock;
        synchronized (object) {
            this.m_activeIsolate = t == null ? DEFAULT_ISOLATE : t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Isolate getActiveIsolate() {
        Object object = this.m_activeIsolateLock;
        synchronized (object) {
            return this.m_activeIsolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInIsolate(Isolate t) {
        Object object = this.m_inIsolateLock;
        synchronized (object) {
            this.m_inIsolate = t == null ? DEFAULT_ISOLATE : t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Isolate getInIsolate() {
        Object object = this.m_inIsolateLock;
        synchronized (object) {
            return this.m_inIsolate;
        }
    }

    Isolate getDefaultIsolate() {
        return DEFAULT_ISOLATE;
    }

    boolean addFrame(DStackContext ds, int isolateId) {
        this.getIsolateState((int)isolateId).m_frames.add(ds);
        return true;
    }

    void clearFrames(int isolateId) {
        if (this.getIsolateState((int)isolateId).m_frames.size() > 0) {
            this.getIsolateState((int)isolateId).m_previousFrames = this.getIsolateState((int)isolateId).m_frames;
        }
        this.getIsolateState((int)isolateId).m_frames = new ArrayList();
    }

    public DStackContext getFrame(int at, int isolateId) {
        return this.getIsolateState((int)isolateId).m_frames.get(at);
    }

    public int getFrameCount(int isolateId) {
        return this.getIsolateState((int)isolateId).m_frames.size();
    }

    public DStackContext[] getFrames(int isolateId) {
        ArrayList<DStackContext> frames = this.getIsolateState((int)isolateId).m_frames;
        return frames.toArray(new DStackContext[frames.size()]);
    }

    private boolean stringsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    private void mapOldFramesToNew(int isolateId) {
        ArrayList<DStackContext> previousFrames = null;
        ArrayList<DStackContext> frames = null;
        Map<Long, DValue> previousValues = null;
        previousFrames = this.getIsolateState((int)isolateId).m_previousFrames;
        frames = this.getIsolateState((int)isolateId).m_frames;
        previousValues = this.getIsolateState((int)isolateId).m_previousValues;
        int oldSize = previousFrames.size();
        int newSize = frames.size();
        DValue[] oldFrames = new DValue[oldSize];
        for (int depth = 0; depth < oldSize; ++depth) {
            oldFrames[depth] = previousValues.remove(-100L - (long)depth);
        }
        int oldDepth = oldSize - 1;
        for (int newDepth = newSize - 1; oldDepth >= 0 && newDepth >= 0; --oldDepth, --newDepth) {
            DValue frame;
            DStackContext oldFrame = previousFrames.get(oldDepth);
            DStackContext newFrame = frames.get(newDepth);
            if (oldFrame == null || newFrame == null || !this.stringsEqual(oldFrame.getCallSignature(), newFrame.getCallSignature()) || (frame = oldFrames[oldDepth]) == null) continue;
            previousValues.put(-100L - (long)newDepth, frame);
        }
    }

    public boolean isGetSupported() {
        return this.m_squelchEnabled;
    }

    public DSuspendInfo getSuspendInfo(int isolateId) {
        if (this.m_isolateState.containsKey(isolateId)) {
            return this.m_isolateState.get((Object)Integer.valueOf((int)isolateId)).m_suspendInfo;
        }
        return null;
    }

    public ArrayList<SwfInfo> getIsolateSwfList() {
        ArrayList<SwfInfo> result = new ArrayList<SwfInfo>();
        for (DManagerIsolateState state : this.m_isolateState.values()) {
            if (state.m_swfInfo == null) continue;
            result.addAll(state.m_swfInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventCount() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            return this.m_event.size();
        }
    }

    public Object getEventNotifier() {
        return this.m_event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugEvent nextEvent() {
        DebugEvent s = null;
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            if (this.m_event.size() > 0) {
                s = this.m_event.removeFirst();
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(DebugEvent e) {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.add(e);
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(DMessage msg, DProtocol which) {
        int inIsolateId;
        int type = msg.getType();
        int n = inIsolateId = this.getInIsolate() != null ? this.getInIsolate().getId() : 1;
        if (inIsolateId != 1) {
            msg.setTargetIsolate(inIsolateId);
        }
        switch (type) {
            case 26: {
                long ver = msg.getDWord();
                this.m_playerVersion = (int)ver;
                int pointerSize = msg.getRemaining() >= 1 ? msg.getByte() : 4;
                DMessage.setSizeofPtr(pointerSize);
                break;
            }
            case 7: {
                this.handleFaultEvent(new RecursionLimitFault(msg.getTargetIsolate()));
                break;
            }
            case 8: {
                this.handleFaultEvent(new InvalidWithFault(msg.getTargetIsolate()));
                break;
            }
            case 9: {
                this.handleFaultEvent(new ProtoLimitFault(msg.getTargetIsolate()));
                break;
            }
            case 24: {
                break;
            }
            case 6: {
                break;
            }
            case 36: {
                String exceptionMessage;
                long offset = msg.getDWord();
                boolean willExceptionBeCaught = false;
                Value thrown = null;
                if (msg.getRemaining() > 0) {
                    exceptionMessage = msg.getString();
                    if (msg.getRemaining() > 0 && msg.getByte() != 0) {
                        willExceptionBeCaught = msg.getByte() != 0;
                        msg.getPtr();
                        DVariable thrownVar = this.extractVariable(msg);
                        thrown = thrownVar.getValue();
                    }
                } else {
                    exceptionMessage = "";
                }
                ExceptionFault exceptionFault = new ExceptionFault(exceptionMessage, willExceptionBeCaught, thrown, msg.getTargetIsolate());
                exceptionFault.isolateId = msg.getTargetIsolate();
                this.handleFaultEvent(exceptionFault);
                break;
            }
            case 37: {
                this.handleFaultEvent(new StackUnderFlowFault(msg.getTargetIsolate()));
                break;
            }
            case 38: {
                this.handleFaultEvent(new DivideByZeroFault(msg.getTargetIsolate()));
                break;
            }
            case 39: {
                this.handleFaultEvent(new ScriptTimeoutFault(msg.getTargetIsolate()));
                break;
            }
            case 44: {
                String s = msg.getString();
                this.handleFaultEvent(new ConsoleErrorFault(s, msg.getTargetIsolate()));
                break;
            }
            case 5: {
                String text = msg.getString();
                this.addEvent(new TraceEvent(text));
                break;
            }
            case 29: {
                long state = msg.getDWord();
                this.m_squelchEnabled = state != 0L;
                break;
            }
            case 12: {
                String name = msg.getString();
                String value = msg.getString();
                this.m_parms.put(name, value);
                if (!name.startsWith("movie")) break;
                this.m_uri = DManager.convertToURI(value);
                break;
            }
            case 13: {
                long objId = msg.getPtr();
                String path = msg.getString();
                break;
            }
            case 1: {
                long objId = msg.getPtr();
                int item = msg.getWord();
                String value = msg.getString();
                break;
            }
            case 3: {
                long objId = msg.getPtr();
                break;
            }
            case 4: {
                long objId = msg.getPtr();
                break;
            }
            case 10: {
                long objId = msg.getPtr();
                String name = msg.getString();
                int dType = msg.getWord();
                int flags = (int)msg.getDWord();
                String value = msg.getString();
                break;
            }
            case 11: {
                long objId = msg.getPtr();
                String name = msg.getString();
                break;
            }
            case 14: {
                int module = (int)msg.getDWord();
                int bitmap = (int)msg.getDWord();
                String name = msg.getString();
                String text = msg.getString();
                int swfIndex = -1;
                int isolateIndex = -1;
                if (msg.getRemaining() >= 4) {
                    swfIndex = (int)msg.getDWord();
                }
                isolateIndex = msg.getTargetIsolate();
                this.getOrCreateIsolate(isolateIndex);
                if (!this.putSource(swfIndex, module, bitmap, name, text, isolateIndex)) break;
                if (!this.m_sourceListModified) {
                    this.addEvent(new FileListModifiedEvent());
                }
                this.m_sourceListModified = true;
                break;
            }
            case 21: {
                Map<Integer, DModule> source;
                long module = msg.getDWord();
                int isolateId = msg.getTargetIsolate();
                Map<Integer, DModule> swfIndex = source = this.getIsolateState((int)isolateId).m_source;
                synchronized (swfIndex) {
                    if (this.removeSource((int)module, isolateId)) {
                        if (!this.m_sourceListModified) {
                            this.addEvent(new FileListModifiedEvent());
                        }
                        this.m_sourceListModified = true;
                    }
                    break;
                }
            }
            case 15: {
                int targetIsolate = msg.getTargetIsolate();
                DSuspendInfo iSusInfo = this.getIsolateState((int)targetIsolate).m_suspendInfo;
                if (iSusInfo != null) break;
                iSusInfo = new DSuspendInfo(7, 0, 0, 0, 0);
                break;
            }
            case 16: {
                long bp = 0L;
                long wideLine = 0L;
                long wideModule = 0L;
                if (!this.m_wideLines) {
                    bp = msg.getDWord();
                } else {
                    wideModule = msg.getDWord();
                    wideLine = msg.getDWord();
                }
                long id = msg.getPtr();
                String stack = msg.getString();
                int targetIsolate = msg.getTargetIsolate();
                int module = DLocation.decodeFile(bp);
                int line = DLocation.decodeLine(bp);
                if (this.m_wideLines) {
                    module = (int)wideModule;
                    line = (int)wideLine;
                }
                this.addEvent(new BreakEvent(module, line, targetIsolate));
                break;
            }
            case 17: {
                this.continuing(msg.getTargetIsolate());
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                long count = msg.getDWord();
                int targetIsolate = msg.getTargetIsolate();
                while (count-- > 0L) {
                    long bp = 0L;
                    long moduleNumber = 0L;
                    long lineNumber = 0L;
                    if (!this.m_wideLines) {
                        bp = msg.getDWord();
                    } else {
                        moduleNumber = msg.getDWord();
                        lineNumber = msg.getDWord();
                    }
                    int fileId = DLocation.decodeFile(bp);
                    int line = DLocation.decodeLine(bp);
                    if (this.m_wideLines) {
                        fileId = (int)moduleNumber;
                        line = (int)lineNumber;
                    }
                    DModule file = null;
                    file = this.getSource(fileId, targetIsolate);
                    DLocation l = new DLocation(file, line, targetIsolate);
                    if (file == null) continue;
                    this.addBreakpoint((int)bp, l, targetIsolate);
                }
                break;
            }
            case 20: {
                DSwfInfo swf;
                int num = (int)msg.getDWord();
                int targetIsolate = msg.getTargetIsolate();
                if (msg.getRemaining() >= 4) {
                    int swfIndex = (int)msg.getDWord();
                    this.getIsolateState((int)targetIsolate).m_lastSwfInfo = swf = this.getOrCreateSwfInfo(swfIndex, targetIsolate);
                } else {
                    swf = this.getActiveSwfInfo(targetIsolate);
                }
                swf.setSourceExpectedCount(num);
                break;
            }
            case 22: {
                long count = msg.getDWord();
                int isolateId = msg.getTargetIsolate();
                while (count-- > 0L) {
                    long bp = msg.getDWord();
                    this.removeBreakpoint((int)bp, isolateId);
                }
                break;
            }
            case 27: {
                long bp = 0L;
                long wideLine = 0L;
                long wideModule = 0L;
                if (!this.m_wideLines) {
                    bp = msg.getDWord();
                } else {
                    wideModule = msg.getDWord();
                    wideLine = msg.getDWord();
                }
                long num = msg.getDWord();
                int targetIsolate = msg.getTargetIsolate();
                this.clearFrames(targetIsolate);
                int depth = 0;
                while (num-- > 0L) {
                    long bpi = 0L;
                    long wideLinei = 0L;
                    long wideModulei = 0L;
                    if (!this.m_wideLines) {
                        bpi = msg.getDWord();
                    } else {
                        wideModulei = msg.getDWord();
                        wideLinei = msg.getDWord();
                    }
                    long id = msg.getPtr();
                    String stack = msg.getString();
                    int module = DLocation.decodeFile(bpi);
                    int line = DLocation.decodeLine(bpi);
                    if (this.m_wideLines) {
                        module = (int)wideModulei;
                        line = (int)wideLinei;
                    }
                    DModule m = null;
                    m = this.getSource(module, targetIsolate);
                    DStackContext c = new DStackContext(module, line, m, id, stack, depth, targetIsolate);
                    if (!this.addFrame(c, targetIsolate)) continue;
                    ++depth;
                }
                this.mapOldFramesToNew(targetIsolate);
                if (targetIsolate == 1) break;
                this.appendIsolateInfoToFrame(targetIsolate);
                break;
            }
            case 31: {
                DValue frame = null;
                DVariable child = null;
                ArrayList<DVariable> v = new ArrayList<DVariable>();
                ArrayList<DVariable> registers = new ArrayList<DVariable>();
                int targetIsolate = msg.getTargetIsolate();
                int depth = (int)msg.getDWord();
                if (depth > -1) {
                    int num = (int)msg.getDWord();
                    for (int i = 0; i < num; ++i) {
                        registers.add(this.extractRegister(msg, i + 1));
                    }
                }
                int currentArg = -1;
                boolean gettingScopeChain = false;
                while (msg.getRemaining() > 0) {
                    long frameId = msg.getPtr();
                    if (frame == null) {
                        frame = this.getOrCreateValue(frameId, targetIsolate);
                        this.extractVariable(msg);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (currentArg == -1 && child.getName().equals(ARGUMENTS_MARKER)) {
                        currentArg = 0;
                        gettingScopeChain = false;
                    } else if (child.getName().equals(SCOPE_CHAIN_MARKER)) {
                        currentArg = -1;
                        gettingScopeChain = true;
                    } else if (currentArg >= 0) {
                        ++currentArg;
                        if (child.getName().equals("undefined")) {
                            child.setName("_arg" + currentArg);
                        }
                    }
                    if (!gettingScopeChain) {
                        this.addVariableMember(frameId, child, targetIsolate);
                    }
                    v.add(child);
                }
                if (depth == 0) {
                    this.populateRootNode(frame, v, targetIsolate);
                    break;
                }
                this.populateFrame(depth, v, targetIsolate);
                break;
            }
            case 32: {
                String s = msg.getString();
                String v = msg.getString();
                this.m_options.put(s, v);
                break;
            }
            case 30: {
                DValue parent = null;
                DVariable child = null;
                String definingClass = null;
                int level = 0;
                int targetIsolate = msg.getTargetIsolate();
                int highestLevelWithMembers = -1;
                ArrayList<String> classes = new ArrayList<String>();
                while (msg.getRemaining() > 0) {
                    String classWithoutDollar;
                    int indexOfClass;
                    long parentId = msg.getPtr();
                    if (parent == null) {
                        String name = msg.getString();
                        this.getIsolateState((int)targetIsolate).m_lastInGetVariable = this.extractVariable(msg, name);
                        parent = this.getOrCreateValue(parentId, targetIsolate);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (this.showMember(child)) {
                        if (child.isAttributeSet(131072)) {
                            if (classes.size() > 0) {
                                child.setDefiningClass(0, (String)classes.get(0));
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, 0);
                            }
                        } else {
                            child.setDefiningClass(level, definingClass);
                            if (definingClass != null) {
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, level);
                            }
                        }
                        this.addVariableMember(parent.getId(), child, targetIsolate);
                        continue;
                    }
                    if (!this.isTraits(child)) continue;
                    definingClass = child.getQualifiedName();
                    level = classes.size();
                    if (definingClass.endsWith("$") && (indexOfClass = classes.indexOf(classWithoutDollar = definingClass.substring(0, definingClass.length() - 1))) != -1) {
                        level = indexOfClass;
                        definingClass = classWithoutDollar;
                    }
                    if (level != classes.size()) continue;
                    classes.add(definingClass);
                }
                if (parent == null || parent.getClassHierarchy(true) != null) break;
                parent.setClassHierarchy(classes.toArray(new String[classes.size()]), highestLevelWithMembers + 1);
                break;
            }
            case 33: 
            case 55: {
                int success = msg.getWord();
                int oldFlags = msg.getWord();
                int oldTag = msg.getWord();
                int flags = msg.getWord();
                int tag = msg.getWord();
                long id = type == 55 ? msg.getPtr() : (long)msg.getWord();
                String name = msg.getString();
                int targetIsolate = msg.getTargetIsolate();
                if (success == 0) break;
                if (flags == 0) {
                    this.removeWatchpoint(oldTag, targetIsolate);
                    break;
                }
                this.removeWatchpoint(oldTag, targetIsolate);
                DWatch w = new DWatch(id, name, flags, tag, targetIsolate);
                this.addWatchpoint(w, targetIsolate);
                break;
            }
            case 34: {
                this.m_swf = msg.getData();
                break;
            }
            case 35: {
                this.m_swd = msg.getData();
                break;
            }
            case 40: {
                int suspendReason = msg.getWord();
                int suspendPlayer = msg.getWord();
                int breakOffset = (int)msg.getDWord();
                int prevBreakOffset = (int)msg.getDWord();
                int nextBreakOffset = (int)msg.getDWord();
                int targetIsolate = msg.getTargetIsolate();
                this.getIsolateState((int)targetIsolate).m_suspendInfo = new DSuspendInfo(suspendReason, suspendPlayer, breakOffset, prevBreakOffset, nextBreakOffset);
                try {
                    DStackContext c = this.getFrame(0, targetIsolate);
                    c.setOffset(breakOffset);
                    c.setSwfIndex(suspendPlayer);
                }
                catch (Exception e) {
                    if (!Trace.error) break;
                    Trace.trace("Oh my god, gag me with a spoon...getFrame(0) call failed");
                    e.printStackTrace();
                }
                break;
            }
            case 41: {
                int item = msg.getWord();
                int rsvd = msg.getWord();
                int at = (int)msg.getDWord();
                int len = (int)msg.getDWord();
                int i = 0;
                byte[] byArray = this.m_actions = len <= 0 ? null : new byte[len];
                while (len-- > 0) {
                    this.m_actions[i++] = (byte)msg.getByte();
                }
                break;
            }
            case 42: {
                int count = msg.getWord();
                int targetIsolate = msg.getTargetIsolate();
                for (int i = 0; i < count; ++i) {
                    long index = msg.getDWord();
                    long id = msg.getPtr();
                    DSwfInfo info = null;
                    this.getIsolateState((int)targetIsolate).m_lastSwfInfo = info = this.getOrCreateSwfInfo((int)index, targetIsolate);
                    if (id != 0L) {
                        boolean justCreated;
                        boolean debugComing = msg.getByte() != 0;
                        byte vmVersion = (byte)msg.getByte();
                        int rsvd1 = msg.getWord();
                        long swfSize = msg.getDWord();
                        long swdSize = msg.getDWord();
                        long scriptCount = msg.getDWord();
                        long offsetCount = msg.getDWord();
                        long breakpointCount = msg.getDWord();
                        long port = msg.getDWord();
                        String path = msg.getString();
                        String url = msg.getString();
                        String host = msg.getString();
                        HashMap<Long, Integer> local2global = new HashMap<Long, Integer>();
                        int minId = Integer.MAX_VALUE;
                        int maxId = Integer.MIN_VALUE;
                        if (swdSize > 0L) {
                            long num = msg.getDWord();
                            int j = 0;
                            while ((long)j < num && msg.getRemaining() >= DMessage.getSizeofPtr()) {
                                long local = msg.getPtr();
                                int global = (int)msg.getDWord();
                                local2global.put(local, global);
                                minId = global < minId ? global : minId;
                                maxId = global > maxId ? global : maxId;
                                ++j;
                            }
                        }
                        boolean bl = justCreated = info.getSwfSize() == 0;
                        if (vmVersion > 0) {
                            debugComing = false;
                            info.setVmVersion(vmVersion);
                            info.setPopulated();
                        }
                        info.freshen(id, path, url, host, port, debugComing, swfSize, swdSize, breakpointCount, offsetCount, scriptCount, local2global, minId, maxId);
                        this.tieScriptsToSwf(info, targetIsolate);
                        if (!justCreated) continue;
                        this.addEvent(new SwfLoadedEvent(id, (int)index, path, url, host, port, swfSize));
                        continue;
                    }
                    boolean alreadyUnloaded = info.isUnloaded();
                    info.setUnloaded();
                    if (alreadyUnloaded) continue;
                    this.addEvent(new SwfUnloadedEvent(info.getId(), info.getPath(), (int)index));
                }
                break;
            }
            case 43: {
                int item = msg.getWord();
                int count = (int)msg.getDWord();
                String[] pool = new String[count];
                for (int i = 0; i < count; ++i) {
                    long id = msg.getPtr();
                    DVariable var = this.extractVariable(msg);
                    pool[i] = var.getValue().getValueAsString();
                }
                this.m_lastConstantPool = pool;
                break;
            }
            case 45: {
                long id = msg.getDWord();
                long count = msg.getDWord();
                DModule m = this.getSource((int)id, msg.getTargetIsolate());
                if (m == null) break;
                int i = 0;
                while ((long)i < count) {
                    int offset = (int)msg.getDWord();
                    int firstLine = (int)msg.getDWord();
                    int lastLine = (int)msg.getDWord();
                    String name = msg.getString();
                    m.addLineFunctionInfo(offset, firstLine, lastLine, name);
                    ++i;
                }
                break;
            }
            case 54: 
            case 57: {
                DValue parent = null;
                int targetIsolate = msg.getTargetIsolate();
                DVariable child = null;
                String definingClass = null;
                int level = 0;
                int highestLevelWithMembers = -1;
                ArrayList<String> classes = new ArrayList<String>();
                if (type == 57) {
                    msg.getDWord();
                }
                while (msg.getRemaining() > 0) {
                    String classWithoutDollar;
                    int indexOfClass;
                    long parentId = msg.getPtr();
                    if (parent == null) {
                        String name = msg.getString();
                        DVariable var = this.extractVariable(msg, name);
                        if (type == 54) {
                            this.getIsolateState((int)targetIsolate).m_lastInCallFunction = var;
                        } else {
                            this.getIsolateState((int)targetIsolate).m_lastInBinaryOp = var;
                        }
                        parent = this.getOrCreateValue(parentId, targetIsolate);
                        continue;
                    }
                    child = this.extractVariable(msg);
                    if (this.showMember(child)) {
                        if (child.isAttributeSet(131072)) {
                            if (classes.size() > 0) {
                                child.setDefiningClass(0, (String)classes.get(0));
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, 0);
                            }
                        } else {
                            child.setDefiningClass(level, definingClass);
                            if (definingClass != null) {
                                highestLevelWithMembers = Math.max(highestLevelWithMembers, level);
                            }
                        }
                        this.addVariableMember(parent.getId(), child, targetIsolate);
                        continue;
                    }
                    if (!this.isTraits(child)) continue;
                    definingClass = child.getQualifiedName();
                    level = classes.size();
                    if (definingClass.endsWith("$") && (indexOfClass = classes.indexOf(classWithoutDollar = definingClass.substring(0, definingClass.length() - 1))) != -1) {
                        level = indexOfClass;
                        definingClass = classWithoutDollar;
                    }
                    if (level != classes.size()) continue;
                    classes.add(definingClass);
                }
                if (parent == null || parent.getClassHierarchy(true) != null) break;
                parent.setClassHierarchy(classes.toArray(new String[classes.size()]), highestLevelWithMembers + 1);
                break;
            }
            case 58: {
                long id = msg.getDWord();
                this.isolateCreate((int)id);
                break;
            }
            case 59: {
                long id = msg.getDWord();
                DIsolate isolate = this.removeIsolate((int)id);
                this.addEvent(new IsolateExitEvent(isolate));
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                long id = msg.getDWord();
                boolean success = msg.getByte() != 0;
                break;
            }
            case 62: {
                long id = msg.getDWord();
                Object success = this.m_inIsolateLock;
                synchronized (success) {
                    int at = this.findIsolate((int)id);
                    if (at != -1) {
                        this.setInIsolate(this.getIsolate(at));
                    } else if (id != 1L) {
                        this.setInIsolate(this.isolateCreate((int)id));
                    } else {
                        this.setInIsolate(null);
                    }
                    break;
                }
            }
            case 63: {
                int result = msg.getWord();
                String exceptionBP = msg.getString();
                int remaining = msg.getRemaining();
                break;
            }
            case 64: {
                int result = msg.getWord();
                String exceptionBP = msg.getString();
                int remaining = msg.getRemaining();
                break;
            }
        }
    }

    private DIsolate isolateCreate(int id) {
        int idx = this.findIsolate(id);
        if (idx == -1) {
            DIsolate isolate = new DIsolate(id);
            this.addIsolate(isolate);
            this.setInIsolate(isolate);
            this.addEvent(new IsolateCreateEvent(isolate));
            return isolate;
        }
        return this.getIsolate(idx);
    }

    private void appendIsolateInfoToFrame(int isolateid) {
        block2: {
            try {
                DStackContext c = this.getFrame(0, isolateid);
                c.setIsolateId(isolateid);
            }
            catch (Exception e) {
                if (!Trace.error) break block2;
                Trace.trace("Oh my god, gag me with a spoon...getFrame(0) call failed");
                e.printStackTrace();
            }
        }
    }

    private boolean showMember(DVariable child) {
        return !this.isTraits(child);
    }

    private boolean isTraits(DVariable variable) {
        Value value = variable.getValue();
        return value.getType() == 8 && "traits".equals(value.getTypeName());
    }

    void populateRootNode(DValue frame, ArrayList<DVariable> orderedChildList, int isolateId) {
        this.populateFrame(0, orderedChildList, isolateId);
        DValue base = this.getOrCreateValue(-100L, isolateId);
        base.setMembersObtained(true);
    }

    void populateFrame(int depth, ArrayList<DVariable> frameVars, int isolateId) {
        DStackContext context = null;
        boolean inArgs = false;
        int nArgs = -1;
        boolean inScopeChain = false;
        DValue root = this.getOrCreateValue(-100L - (long)depth, isolateId);
        if (depth < this.getFrameCount(isolateId)) {
            context = this.getFrame(depth, isolateId);
        }
        if (context != null) {
            context.removeAllVariables();
        }
        for (DVariable v : frameVars) {
            String name = v.getName();
            v.clearAttribute(32);
            v.clearAttribute(65536);
            if (name.equals("this")) {
                if (context != null) {
                    context.setThis(v);
                }
                v.setAttribute(65536);
                this.addVariableMember(root, v, isolateId);
                if (depth != 0) continue;
                this.putValue(-3L, (DValue)v.getValue(), isolateId);
                continue;
            }
            if (name.equals("super")) {
                inArgs = false;
                continue;
            }
            if (name.equals(ARGUMENTS_MARKER)) {
                inArgs = true;
                try {
                    nArgs = ((Number)v.getValue().getValueAsObject()).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (name.equals(SCOPE_CHAIN_MARKER)) {
                inArgs = false;
                inScopeChain = true;
                continue;
            }
            if (inArgs) {
                v.setAttribute(65536);
                if (context != null) {
                    context.addArgument(v);
                }
                if (nArgs > -1 && --nArgs <= 0) {
                    inArgs = false;
                }
            } else if (inScopeChain) {
                if (context != null) {
                    context.addScopeChainEntry(v);
                }
            } else {
                v.setAttribute(32);
                if (context != null) {
                    context.addLocal(v);
                }
            }
            if (inScopeChain) continue;
            this.addVariableMember(root, v, isolateId);
        }
    }

    int toAttributes(int pAttr) {
        int attr = pAttr;
        return attr;
    }

    DVariable extractVariable(DMessage msg) {
        DVariable v = this.extractVariable(msg, msg.getString());
        return v;
    }

    DVariable extractVariable(DMessage msg, String name) {
        int oType = msg.getWord();
        int flags = (int)msg.getDWord();
        return this.extractAtom(msg, name, oType, flags);
    }

    DVariable extractRegister(DMessage msg, int number) {
        int oType = msg.getWord();
        return this.extractAtom(msg, "$" + number, oType, 0);
    }

    DVariable extractAtom(DMessage msg, String name, int oType, int flags) {
        int vType = 8;
        Object value = null;
        String typeName = "";
        String className = "";
        boolean isPrimitive = false;
        switch (oType) {
            case 0: {
                String s = msg.getString();
                double dval = Double.NaN;
                try {
                    dval = Double.parseDouble(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                value = new Double(dval);
                isPrimitive = true;
                break;
            }
            case 1: {
                int bval = msg.getByte();
                value = new Boolean(bval != 0);
                isPrimitive = true;
                break;
            }
            case 2: {
                String s = msg.getString();
                value = s;
                isPrimitive = true;
                break;
            }
            case 3: 
            case 18: {
                long oid = msg.getPtr();
                long cType = oid == -1L ? 0L : msg.getDWord();
                int isFnc = oid == -1L ? 0 : msg.getWord();
                int rsvd = oid == -1L ? 0 : msg.getWord();
                String string = typeName = oid == -1L ? "" : msg.getString();
                if (typeName.startsWith("<")) {
                    int atIndex = typeName.indexOf(64);
                    String dateVal = typeName;
                    if (atIndex > -1) {
                        dateVal = typeName.substring(0, atIndex);
                    }
                    SimpleDateFormat dFormat = new SimpleDateFormat("<EEE MMM d HH:mm:ss 'GMT'z yyyy>");
                    try {
                        Date dateObj = dFormat.parse(dateVal);
                        if (dateObj != null && dateObj.getTime() != 0L) {
                            oType = 11;
                            typeName = "Date" + typeName.substring(atIndex);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                className = DVariable.classNameFor(cType, false);
                value = new Long(oid);
                vType = isFnc == 0 ? 3 : 4;
                break;
            }
            case 4: {
                long oid = msg.getPtr();
                long cType = oid == -1L ? 0L : msg.getDWord();
                long rsvd = oid == -1L ? 0L : msg.getDWord();
                typeName = oid == -1L ? "" : msg.getString();
                className = DVariable.classNameFor(cType, true);
                value = new Long(oid);
                vType = 5;
                break;
            }
            case 5: {
                value = null;
                isPrimitive = true;
                break;
            }
            case 6: {
                value = Value.UNDEFINED;
                isPrimitive = true;
                break;
            }
            case 19: {
                vType = 8;
                typeName = "traits";
                break;
            }
        }
        int isolateId = msg.getTargetIsolate();
        DValue valueObject = null;
        if (value instanceof Long) {
            valueObject = this.getValue((Long)value, isolateId);
        }
        if (valueObject == null) {
            if (isPrimitive) {
                valueObject = DValue.forPrimitive(value, isolateId);
                valueObject.setAttributes(this.toAttributes(flags));
            } else {
                valueObject = new DValue(vType, typeName, className, this.toAttributes(flags), value, isolateId);
            }
            if (value instanceof Long && (this.toAttributes(flags) & 0x80000) == 0) {
                this.putValue((Long)value, valueObject, isolateId);
            }
        } else {
            if (isPrimitive) {
                DValue temp = DValue.forPrimitive(value, isolateId);
                vType = temp.getType();
                typeName = temp.getTypeName();
                className = temp.getClassName();
            }
            valueObject.setType(vType);
            valueObject.setTypeName(typeName);
            valueObject.setClassName(className);
            valueObject.setAttributes(this.toAttributes(flags));
            valueObject.setValue(value);
        }
        if (valueObject != null) {
            valueObject.setIsolateId(isolateId);
        }
        DVariable var = new DVariable(name, valueObject, isolateId);
        return var;
    }

    public static String convertToURI(String playerURL) {
        int index = playerURL.indexOf(124);
        StringBuilder sb = new StringBuilder(playerURL);
        while (index > 0) {
            sb.setCharAt(index, ':');
            index = playerURL.indexOf(124, index + 1);
        }
        return sb.toString();
    }

    public void beginPlayerCodeExecution(int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        state.m_executingPlayerCode = true;
        state.m_faultEventDuringPlayerCodeExecution = null;
    }

    public FaultEvent endPlayerCodeExecution(int isolateId) {
        DManagerIsolateState state = this.getIsolateState(isolateId);
        state.m_executingPlayerCode = false;
        FaultEvent e = state.m_faultEventDuringPlayerCodeExecution;
        state.m_faultEventDuringPlayerCodeExecution = null;
        return e;
    }

    private void handleFaultEvent(FaultEvent faultEvent) {
        DManagerIsolateState isolateState = this.getIsolateState(faultEvent.isolateId);
        boolean executingPlayerCode = isolateState.m_executingPlayerCode;
        if (executingPlayerCode) {
            FaultEvent faultEventDuringPlayerCodeExecution = isolateState.m_faultEventDuringPlayerCodeExecution;
            if (faultEventDuringPlayerCodeExecution == null) {
                isolateState.m_faultEventDuringPlayerCodeExecution = faultEvent;
            }
        } else {
            this.addEvent(faultEvent);
        }
    }

    @Override
    public InputStream locateSource(String path, String pkg, String name) {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.locateSource(path, pkg, name);
        }
        return null;
    }

    @Override
    public int getChangeCount() {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.getChangeCount();
        }
        return 0;
    }

    public String getOption(String optionName) {
        return this.m_options.get(optionName);
    }

    class DManagerIsolateState {
        public DSuspendInfo m_suspendInfo = null;
        public DSwfInfo m_lastSwfInfo;
        public DVariable m_lastInGetVariable = null;
        public boolean m_attachChildren = true;
        public DVariable m_lastInCallFunction = null;
        public DVariable m_lastInBinaryOp;
        private boolean m_executingPlayerCode;
        private FaultEvent m_faultEventDuringPlayerCodeExecution;
        public final ArrayList<DLocation> m_breakpoints;
        public final Map<Integer, DModule> m_source = new HashMap<Integer, DModule>();
        private final ArrayList<DSwfInfo> m_swfInfo;
        private final ArrayList<DWatch> m_watchpoints;
        public ArrayList<DStackContext> m_frames;
        public ArrayList<DStackContext> m_previousFrames;
        public Map<Long, DValue> m_values = new HashMap<Long, DValue>();
        public Map<Long, DValue> m_previousValues = new HashMap<Long, DValue>();

        public DManagerIsolateState() {
            this.m_frames = new ArrayList();
            this.m_previousFrames = new ArrayList();
            this.m_breakpoints = new ArrayList();
            this.m_swfInfo = new ArrayList();
            this.m_watchpoints = new ArrayList();
        }
    }
}

