/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Location;
import flash.tools.debugger.SourceFile;

public class DLocation
implements Location {
    SourceFile m_source;
    int m_line;
    int m_isolateId;
    boolean m_removed;

    DLocation(SourceFile src, int line, int isolateId) {
        this.m_source = src;
        this.m_line = line;
        this.m_removed = false;
        this.m_isolateId = isolateId;
    }

    @Override
    public SourceFile getFile() {
        return this.m_source;
    }

    @Override
    public int getLine() {
        return this.m_line;
    }

    public boolean isRemoved() {
        return this.m_removed;
    }

    public void setRemoved(boolean removed) {
        this.m_removed = removed;
    }

    public int getId() {
        return DLocation.encodeId(this.getFile().getId(), this.getLine());
    }

    public static final int encodeId(int fileId, int line) {
        return line << 16 | fileId;
    }

    public static final int decodeFile(long id) {
        return (int)(id & 0xFFFFL);
    }

    public static final int decodeLine(long id) {
        return (int)(id >> 16 & 0xFFFFL);
    }

    public String toString() {
        return this.m_source.toString() + ":" + this.m_line;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }
}

