/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import java.io.IOException;
import java.util.List;
import org.apache.royale.compiler.codegen.ISourceMapEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;

public class JSSourceMapEmitter
implements ISourceMapEmitter {
    private IMappingEmitter emitter;
    private SourceMapGeneratorV3 sourceMapGenerator;

    public JSSourceMapEmitter(IMappingEmitter emitter) {
        this.emitter = emitter;
        this.sourceMapGenerator = new SourceMapGeneratorV3();
    }

    @Override
    public String emitSourceMap(String fileName, String sourceMapPath, String sourceRoot) {
        List<IMappingEmitter.SourceMapMapping> mappings = this.emitter.getSourceMapMappings();
        for (IMappingEmitter.SourceMapMapping mapping : mappings) {
            this.sourceMapGenerator.addMapping(mapping.sourcePath, mapping.name, mapping.sourceStartPosition, mapping.destStartPosition, mapping.destEndPosition);
        }
        if (sourceRoot != null) {
            this.sourceMapGenerator.setSourceRoot(sourceRoot);
        }
        StringBuilder builder = new StringBuilder();
        try {
            this.sourceMapGenerator.appendTo(builder, fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }
}

