/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.Set;

public class FindRoyaleMXMLPropertyNamesToKeep
extends NodeTraversal.AbstractPostOrderCallback {
    private final AbstractCompiler compiler;
    private Set<String> propertyNamesToKeep;

    public FindRoyaleMXMLPropertyNamesToKeep(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public void process(Node externs, Node root, Set<String> propertyNamesToKeep) {
        this.propertyNamesToKeep = propertyNamesToKeep;
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.checkForGenerateMXMLAttributes(t, n, parent);
        this.checkForMXMLDescriptor(t, n, parent);
        this.checkForBindings(t, n, parent);
    }

    private void checkForMXMLDescriptor(NodeTraversal t, Node n, Node parent) {
        if (!n.isArrayLit()) {
            return;
        }
        if (parent == null || !parent.isName()) {
            return;
        }
        if (!"mxmldd".equals(parent.getQualifiedName())) {
            return;
        }
        Node mxmlDescriptorNode = null;
        if (parent.getGrandparent() != null && parent.getGrandparent().getGrandparent() != null && parent.getGrandparent().getGrandparent().getGrandparent() != null) {
            mxmlDescriptorNode = parent.getGrandparent().getGrandparent().getGrandparent().getGrandparent();
        }
        if (mxmlDescriptorNode == null || !mxmlDescriptorNode.isStringKey() || mxmlDescriptorNode.getChildCount() == 0) {
            return;
        }
        if (!"MXMLDescriptor".equals(mxmlDescriptorNode.getString())) {
            return;
        }
        Node descriptorParent = mxmlDescriptorNode.getParent();
        if (descriptorParent == null || !descriptorParent.isObjectLit()) {
            return;
        }
        Node descriptorGP = mxmlDescriptorNode.getGrandparent();
        if (descriptorGP == null) {
            return;
        }
        if (descriptorGP.getIndexOfChild(descriptorParent) != 2) {
            return;
        }
        Node prototype = descriptorGP.getChildBefore(descriptorParent);
        String qualifiedName = prototype.getQualifiedName();
        if (!qualifiedName.endsWith(".prototype")) {
            return;
        }
        qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 10);
        Node defineProps = descriptorGP.getChildBefore(prototype);
        if (!"Object.defineProperties".equals(defineProps.getQualifiedName())) {
            return;
        }
        this.traverseMXMLAttributes(n, null);
    }

    private void checkForGenerateMXMLAttributes(NodeTraversal t, Node n, Node parent) {
        if (!n.isGetProp()) {
            return;
        }
        if (parent == null || !parent.isCall()) {
            return;
        }
        if (!"this.generateMXMLAttributes".equals(n.getQualifiedName())) {
            return;
        }
        if (parent.getChildCount() != 2) {
            return;
        }
        Node arrayArg = parent.getChildAtIndex(1);
        if (!arrayArg.isArrayLit()) {
            return;
        }
        if (arrayArg.getChildCount() == 0) {
            return;
        }
        Node functionNode = null;
        if (parent.getGrandparent() != null) {
            functionNode = parent.getGrandparent().getParent();
        }
        if (functionNode == null) {
            return;
        }
        if (!functionNode.isFunction()) {
            return;
        }
        String constructorName = functionNode.getOriginalName();
        this.traverseMXMLAttributes(arrayArg, constructorName);
    }

    private void traverseMXMLAttributes(Node arrayArg, String qualifiedName) {
        if (arrayArg.getChildCount() == 0) {
            return;
        }
        boolean alreadyHadQualifiedName = qualifiedName != null;
        int i = 0;
        while (i < arrayArg.getChildCount()) {
            int numStyles;
            if (qualifiedName == null) {
                Node nameChild = arrayArg.getChildAtIndex(i);
                ++i;
                if (!nameChild.isGetProp() && !nameChild.isName()) {
                    this.throwParseException(nameChild);
                }
                qualifiedName = nameChild.getQualifiedName();
            }
            Node numPropsChild = arrayArg.getChildAtIndex(i);
            ++i;
            if (!numPropsChild.isNumber()) {
                this.throwParseException(numPropsChild);
            }
            int numProps = (int)numPropsChild.getDouble();
            int minNumPropsChildren = i + numProps * 3;
            if (arrayArg.getChildCount() < minNumPropsChildren) {
                this.throwParseException(arrayArg);
            }
            while (i < minNumPropsChildren) {
                Node valueNode;
                Node nameNode = arrayArg.getChildAtIndex(i);
                ++i;
                String propName = null;
                if (nameNode.isString()) {
                    propName = nameNode.getString();
                    this.propertyNamesToKeep.add(propName);
                }
                Node propTypeNode = arrayArg.getChildAtIndex(i);
                if (("id".equals(propName) || "_id".equals(propName)) && propTypeNode.isTrue() && (valueNode = arrayArg.getChildAtIndex(++i)).isString()) {
                    this.propertyNamesToKeep.add(valueNode.getString());
                }
                if (!propTypeNode.isTrue()) {
                    valueNode = arrayArg.getChildAtIndex(i);
                    ++i;
                    if (!valueNode.isArrayLit()) continue;
                    this.traverseMXMLAttributes(valueNode, null);
                    continue;
                }
                ++i;
            }
            if (i >= arrayArg.getChildCount()) {
                this.throwParseException(arrayArg);
            }
            Node numStylesChild = arrayArg.getChildAtIndex(i);
            ++i;
            if (!numStylesChild.isNumber()) {
                this.throwParseException(numStylesChild);
            }
            if ((numStyles = (int)numStylesChild.getDouble()) != 0) {
                this.throwParseException(numStylesChild);
            }
            if (i >= arrayArg.getChildCount()) {
                this.throwParseException(arrayArg);
            }
            Node numEventsChild = arrayArg.getChildAtIndex(i);
            ++i;
            if (!numEventsChild.isNumber()) {
                this.throwParseException(numEventsChild);
            }
            int numEvents = (int)numEventsChild.getDouble();
            i += numEvents * 2;
            if (alreadyHadQualifiedName) continue;
            if (i >= arrayArg.getChildCount()) {
                this.throwParseException(arrayArg);
            }
            Node childrenChild = arrayArg.getChildAtIndex(i);
            ++i;
            if (!childrenChild.isNull() && !childrenChild.isArrayLit()) {
                this.throwParseException(childrenChild);
            }
            if (childrenChild.isArrayLit()) {
                this.traverseMXMLAttributes(childrenChild, null);
            }
            qualifiedName = null;
        }
    }

    private void traverseWatchers(Node n, int startIndex) {
        if (n.isNull()) {
            return;
        }
        if (!n.isArrayLit()) {
            this.throwParseException(n);
        }
        for (int i = startIndex; i < n.getChildCount(); ++i) {
            Node indexNode = n.getChildAtIndex(i);
            ++i;
            if (indexNode.isNull()) {
                return;
            }
            if (!indexNode.isNumber()) {
                this.throwParseException(indexNode);
            }
            Node watcherTypeNode = n.getChildAtIndex(i);
            ++i;
            if (!watcherTypeNode.isNumber()) {
                this.throwParseException(watcherTypeNode);
            }
            int watcherType = (int)watcherTypeNode.getDouble();
            switch (watcherType) {
                case 0: {
                    Node nameNode = n.getChildAtIndex(i);
                    ++i;
                    if (!nameNode.isString()) {
                        this.throwParseException(nameNode);
                    }
                    String propName = nameNode.getString();
                    this.propertyNamesToKeep.add(propName);
                    ++i;
                    ++i;
                    ++i;
                    break;
                }
                case 1: {
                    Node nameNode = n.getChildAtIndex(i);
                    ++i;
                    if (!nameNode.isString()) {
                        this.throwParseException(nameNode);
                    }
                    String propName = nameNode.getString();
                    this.propertyNamesToKeep.add(propName);
                    ++i;
                    ++i;
                    ++i;
                    ++i;
                    break;
                }
                case 2: {
                    Node nameNode = n.getChildAtIndex(i);
                    ++i;
                    if (!nameNode.isString()) {
                        this.throwParseException(nameNode);
                    }
                    String propName = nameNode.getString();
                    this.propertyNamesToKeep.add(propName);
                    ++i;
                    ++i;
                    ++i;
                    break;
                }
                case 3: {
                    Node nameNode = n.getChildAtIndex(i);
                    ++i;
                    if (!nameNode.isString()) {
                        this.throwParseException(nameNode);
                    }
                    String propName = nameNode.getString();
                    this.propertyNamesToKeep.add(propName);
                    ++i;
                    break;
                }
                default: {
                    this.throwParseException(watcherTypeNode);
                }
            }
            Node watcherChildren = n.getChildAtIndex(i);
            this.traverseWatchers(watcherChildren, 0);
        }
    }

    private void throwParseException(Node unexpectedNode) {
        throw new RuntimeException("Find MXML property names to keep parse failure: " + unexpectedNode);
    }

    private void checkForBindings(NodeTraversal t, Node n, Node parent) {
        int i;
        Node firstChild;
        if (!n.isGetProp()) {
            return;
        }
        if (parent == null || !parent.isAssign() || parent.getChildCount() < 2) {
            return;
        }
        String qualifiedName = n.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (!qualifiedName.endsWith(".prototype._bindings")) {
            return;
        }
        Node bindingsNode = parent.getChildAtIndex(1);
        if (!bindingsNode.isArrayLit()) {
            this.throwParseException(bindingsNode);
        }
        if ((firstChild = bindingsNode.getChildAtIndex(i = 0)).isGetProp()) {
            ++i;
        }
        Node numBindingsChild = bindingsNode.getChildAtIndex(i);
        ++i;
        if (!numBindingsChild.isNumber()) {
            this.throwParseException(numBindingsChild);
        }
        int numBindings = (int)numBindingsChild.getDouble();
        int minNumBindingsChildren = i + numBindings * 3;
        if (bindingsNode.getChildCount() < minNumBindingsChildren) {
            this.throwParseException(bindingsNode);
        }
        while (i < minNumBindingsChildren) {
            Node sourceNode = bindingsNode.getChildAtIndex(i);
            ++i;
            if (sourceNode.isString()) {
                String propName = sourceNode.getString();
                this.propertyNamesToKeep.add(propName);
            } else if (sourceNode.isArrayLit()) {
                for (int j = 0; j < sourceNode.getChildCount(); ++j) {
                    String propName;
                    Node child = sourceNode.getChildAtIndex(j);
                    if (!child.isString() || (propName = child.getString()).contains(".")) continue;
                    this.propertyNamesToKeep.add(propName);
                }
            }
            Node targetNode = bindingsNode.getChildAtIndex(++i);
            ++i;
            if (targetNode.isString()) {
                String propName = targetNode.getString();
                this.propertyNamesToKeep.add(propName);
                continue;
            }
            if (!targetNode.isArrayLit()) continue;
            for (int j = 0; j < sourceNode.getChildCount(); ++j) {
                String propName;
                Node child = sourceNode.getChildAtIndex(j);
                if (!child.isString() || (propName = child.getString()).contains(".")) continue;
                this.propertyNamesToKeep.add(propName);
            }
        }
        this.traverseWatchers(bindingsNode, i);
    }
}

