/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.FrameImpl;
import com.microsoft.playwright.impl.JSHandleImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.Utils;
import com.microsoft.playwright.options.BoundingBox;
import com.microsoft.playwright.options.ElementState;
import com.microsoft.playwright.options.FilePayload;
import com.microsoft.playwright.options.ScreenshotType;
import com.microsoft.playwright.options.SelectOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class ElementHandleImpl
extends JSHandleImpl
implements ElementHandle {
    ElementHandleImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public ElementHandle asElement() {
        return this;
    }

    @Override
    public ElementHandle querySelector(String selector) {
        return this.withLogging("ElementHandle.querySelector", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("selector", selector);
            JsonElement json = this.sendMessage("querySelector", params);
            JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
            if (element == null) {
                return null;
            }
            return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
        });
    }

    @Override
    public List<ElementHandle> querySelectorAll(String selector) {
        return this.withLogging("ElementHandle.<", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("selector", selector);
            JsonElement json = this.sendMessage("querySelectorAll", params);
            JsonArray elements = json.getAsJsonObject().getAsJsonArray("elements");
            if (elements == null) {
                return null;
            }
            ArrayList handles = new ArrayList();
            for (JsonElement item : elements) {
                handles.add(this.connection.getExistingObject(item.getAsJsonObject().get("guid").getAsString()));
            }
            return handles;
        });
    }

    @Override
    public Object evalOnSelector(String selector, String pageFunction, Object arg) {
        return this.withLogging("ElementHandle.evalOnSelector", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("selector", selector);
            params.addProperty("expression", pageFunction);
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evalOnSelector", params);
            SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
            return Serialization.deserialize(value);
        });
    }

    @Override
    public Object evalOnSelectorAll(String selector, String pageFunction, Object arg) {
        return this.withLogging("ElementHandle.evalOnSelectorAll", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("selector", selector);
            params.addProperty("expression", pageFunction);
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evalOnSelectorAll", params);
            SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
            return Serialization.deserialize(value);
        });
    }

    @Override
    public BoundingBox boundingBox() {
        return this.withLogging("ElementHandle.boundingBox", () -> {
            JsonObject json = this.sendMessage("boundingBox").getAsJsonObject();
            if (!json.has("value")) {
                return null;
            }
            return (BoundingBox)Serialization.gson().fromJson(json.get("value"), BoundingBox.class);
        });
    }

    @Override
    public void check(ElementHandle.CheckOptions options) {
        this.withLogging("ElementHandle.check", () -> this.checkImpl(options));
    }

    private void checkImpl(ElementHandle.CheckOptions options) {
        if (options == null) {
            options = new ElementHandle.CheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("check", params);
    }

    @Override
    public void click(ElementHandle.ClickOptions options) {
        this.withLogging("ElementHandle.click", () -> this.clickImpl(options));
    }

    private void clickImpl(ElementHandle.ClickOptions options) {
        if (options == null) {
            options = new ElementHandle.ClickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("click", params);
    }

    @Override
    public Frame contentFrame() {
        return this.withLogging("ElementHandle.contentFrame", () -> this.contentFrameImpl());
    }

    private Frame contentFrameImpl() {
        JsonObject json = this.sendMessage("contentFrame").getAsJsonObject();
        if (!json.has("frame")) {
            return null;
        }
        return (Frame)this.connection.getExistingObject(json.getAsJsonObject("frame").get("guid").getAsString());
    }

    @Override
    public void dblclick(ElementHandle.DblclickOptions options) {
        this.withLogging("ElementHandle.dblclick", () -> this.dblclickImpl(options));
    }

    private void dblclickImpl(ElementHandle.DblclickOptions options) {
        if (options == null) {
            options = new ElementHandle.DblclickOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("dblclick", params);
    }

    @Override
    public void dispatchEvent(String type, Object eventInit) {
        this.withLogging("ElementHandle.dispatchEvent", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("type", type);
            params.add("eventInit", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(eventInit)));
            this.sendMessage("dispatchEvent", params);
        });
    }

    @Override
    public void fill(String value, ElementHandle.FillOptions options) {
        this.withLogging("ElementHandle.fill", () -> this.fillImpl(value, options));
    }

    private void fillImpl(String value, ElementHandle.FillOptions options) {
        if (options == null) {
            options = new ElementHandle.FillOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("value", value);
        this.sendMessage("fill", params);
    }

    @Override
    public void focus() {
        this.withLogging("ElementHandle.focus", () -> this.sendMessage("focus"));
    }

    @Override
    public String getAttribute(String name) {
        return this.withLogging("ElementHandle.getAttribute", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("name", name);
            JsonObject json = this.sendMessage("getAttribute", params).getAsJsonObject();
            return json.has("value") ? json.get("value").getAsString() : null;
        });
    }

    @Override
    public void hover(ElementHandle.HoverOptions options) {
        this.withLogging("ElementHandle.hover", () -> this.hoverImpl(options));
    }

    private void hoverImpl(ElementHandle.HoverOptions options) {
        if (options == null) {
            options = new ElementHandle.HoverOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("hover", params);
    }

    @Override
    public String innerHTML() {
        return this.withLogging("ElementHandle.innerHTML", () -> {
            JsonObject json = this.sendMessage("innerHTML").getAsJsonObject();
            return json.get("value").getAsString();
        });
    }

    @Override
    public String innerText() {
        return this.withLogging("ElementHandle.innerText", () -> {
            JsonObject json = this.sendMessage("innerText").getAsJsonObject();
            return json.get("value").getAsString();
        });
    }

    @Override
    public String inputValue(ElementHandle.InputValueOptions options) {
        return this.withLogging("ElementHandle.inputValue", () -> this.inputValueImpl(options));
    }

    private String inputValueImpl(ElementHandle.InputValueOptions options) {
        if (options == null) {
            options = new ElementHandle.InputValueOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        JsonObject json = this.sendMessage("inputValue", params).getAsJsonObject();
        return json.get("value").getAsString();
    }

    @Override
    public boolean isChecked() {
        return this.withLogging("ElementHandle.isChecked", () -> {
            JsonObject json = this.sendMessage("isChecked").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public boolean isDisabled() {
        return this.withLogging("ElementHandle.isDisabled", () -> {
            JsonObject json = this.sendMessage("isDisabled").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public boolean isEditable() {
        return this.withLogging("ElementHandle.isEditable", () -> {
            JsonObject json = this.sendMessage("isEditable").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public boolean isEnabled() {
        return this.withLogging("ElementHandle.isEnabled", () -> {
            JsonObject json = this.sendMessage("isEnabled").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public boolean isHidden() {
        return this.withLogging("ElementHandle.isHidden", () -> {
            JsonObject json = this.sendMessage("isHidden").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public boolean isVisible() {
        return this.withLogging("ElementHandle.isVisible", () -> {
            JsonObject json = this.sendMessage("isVisible").getAsJsonObject();
            return json.get("value").getAsBoolean();
        });
    }

    @Override
    public FrameImpl ownerFrame() {
        return this.withLogging("ElementHandle.ownerFrame", () -> {
            JsonObject json = this.sendMessage("ownerFrame").getAsJsonObject();
            if (!json.has("frame")) {
                return null;
            }
            return (FrameImpl)this.connection.getExistingObject(json.getAsJsonObject("frame").get("guid").getAsString());
        });
    }

    @Override
    public void press(String key, ElementHandle.PressOptions options) {
        this.withLogging("ElementHandle.press", () -> this.pressImpl(key, options));
    }

    private void pressImpl(String key, ElementHandle.PressOptions options) {
        if (options == null) {
            options = new ElementHandle.PressOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("key", key);
        this.sendMessage("press", params);
    }

    @Override
    public byte[] screenshot(ElementHandle.ScreenshotOptions options) {
        return this.withLogging("ElementHandle.screenshot", () -> this.screenshotImpl(options));
    }

    private byte[] screenshotImpl(ElementHandle.ScreenshotOptions options) {
        if (options == null) {
            options = new ElementHandle.ScreenshotOptions();
        }
        if (options.type == null) {
            String extension;
            String fileName;
            int extStart;
            options.type = ScreenshotType.PNG;
            if (options.path != null && (extStart = (fileName = options.path.getFileName().toString()).lastIndexOf(46)) != -1 && (".jpeg".equals(extension = fileName.substring(extStart).toLowerCase()) || ".jpg".equals(extension))) {
                options.type = ScreenshotType.JPEG;
            }
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.remove("path");
        JsonObject json = this.sendMessage("screenshot", params).getAsJsonObject();
        byte[] buffer = Base64.getDecoder().decode(json.get("binary").getAsString());
        if (options.path != null) {
            Utils.writeToFile(buffer, options.path);
        }
        return buffer;
    }

    @Override
    public void scrollIntoViewIfNeeded(ElementHandle.ScrollIntoViewIfNeededOptions options) {
        this.withLogging("ElementHandle.scrollIntoViewIfNeeded", () -> this.scrollIntoViewIfNeededImpl(options));
    }

    @Override
    public List<String> selectOption(String value, ElementHandle.SelectOptionOptions options) {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        String[] values = stringArray;
        return this.selectOption(values, options);
    }

    @Override
    public List<String> selectOption(ElementHandle value, ElementHandle.SelectOptionOptions options) {
        ElementHandle[] elementHandleArray;
        if (value == null) {
            elementHandleArray = null;
        } else {
            ElementHandle[] elementHandleArray2 = new ElementHandle[1];
            elementHandleArray = elementHandleArray2;
            elementHandleArray2[0] = value;
        }
        ElementHandle[] values = elementHandleArray;
        return this.selectOption(values, options);
    }

    @Override
    public List<String> selectOption(String[] values, ElementHandle.SelectOptionOptions options) {
        if (values == null) {
            return this.selectOption(new SelectOption[0], options);
        }
        return this.selectOption((SelectOption[])Arrays.asList(values).stream().map(v -> new SelectOption().setValue((String)v)).toArray(SelectOption[]::new), options);
    }

    @Override
    public List<String> selectOption(SelectOption value, ElementHandle.SelectOptionOptions options) {
        SelectOption[] selectOptionArray;
        if (value == null) {
            selectOptionArray = null;
        } else {
            SelectOption[] selectOptionArray2 = new SelectOption[1];
            selectOptionArray = selectOptionArray2;
            selectOptionArray2[0] = value;
        }
        SelectOption[] values = selectOptionArray;
        return this.selectOption(values, options);
    }

    private void scrollIntoViewIfNeededImpl(ElementHandle.ScrollIntoViewIfNeededOptions options) {
        if (options == null) {
            options = new ElementHandle.ScrollIntoViewIfNeededOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("scrollIntoViewIfNeeded", params);
    }

    @Override
    public List<String> selectOption(SelectOption[] values, ElementHandle.SelectOptionOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (values != null) {
            params.add("options", Serialization.gson().toJsonTree((Object)values));
        }
        return this.selectOption(params);
    }

    @Override
    public List<String> selectOption(ElementHandle[] values, ElementHandle.SelectOptionOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectOptionOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        if (values != null) {
            params.add("elements", (JsonElement)Serialization.toProtocol(values));
        }
        return this.selectOption(params);
    }

    private List<String> selectOption(JsonObject params) {
        return this.withLogging("SelectOption", () -> {
            JsonObject json = this.sendMessage("selectOption", params).getAsJsonObject();
            return Serialization.parseStringList(json.getAsJsonArray("values"));
        });
    }

    @Override
    public void selectText(ElementHandle.SelectTextOptions options) {
        this.withLogging("ElementHandle.selectText", () -> this.selectTextImpl(options));
    }

    @Override
    public void setChecked(boolean checked, ElementHandle.SetCheckedOptions options) {
        if (checked) {
            this.check(Utils.convertType(options, ElementHandle.CheckOptions.class));
        } else {
            this.uncheck(Utils.convertType(options, ElementHandle.UncheckOptions.class));
        }
    }

    @Override
    public void setInputFiles(Path files, ElementHandle.SetInputFilesOptions options) {
        this.setInputFiles(new Path[]{files}, options);
    }

    private void selectTextImpl(ElementHandle.SelectTextOptions options) {
        if (options == null) {
            options = new ElementHandle.SelectTextOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("selectText", params);
    }

    @Override
    public void setInputFiles(Path[] files, ElementHandle.SetInputFilesOptions options) {
        this.withLogging("ElementHandle.setInputFiles", () -> this.setInputFilesImpl(files, options));
    }

    void setInputFilesImpl(Path[] files, ElementHandle.SetInputFilesOptions options) {
        FrameImpl frame = this.ownerFrame();
        if (frame == null) {
            throw new Error("Cannot set input files to detached element");
        }
        if (Utils.hasLargeFile(files)) {
            if (options == null) {
                options = new ElementHandle.SetInputFilesOptions();
            }
            JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
            Utils.addLargeFileUploadParams(files, params, frame.page().context());
            this.sendMessage("setInputFilePaths", params);
        } else {
            this.setInputFilesImpl(Utils.toFilePayloads(files), options);
        }
    }

    @Override
    public void setInputFiles(FilePayload files, ElementHandle.SetInputFilesOptions options) {
        this.setInputFiles(new FilePayload[]{files}, options);
    }

    @Override
    public void setInputFiles(FilePayload[] files, ElementHandle.SetInputFilesOptions options) {
        this.withLogging("ElementHandle.setInputFiles", () -> this.setInputFilesImpl(files, options));
    }

    void setInputFilesImpl(FilePayload[] files, ElementHandle.SetInputFilesOptions options) {
        Utils.checkFilePayloadSize(files);
        if (options == null) {
            options = new ElementHandle.SetInputFilesOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.add("files", (JsonElement)Serialization.toJsonArray(files));
        this.sendMessage("setInputFiles", params);
    }

    @Override
    public void tap(ElementHandle.TapOptions options) {
        this.withLogging("ElementHandle.tap", () -> this.tapImpl(options));
    }

    private void tapImpl(ElementHandle.TapOptions options) {
        if (options == null) {
            options = new ElementHandle.TapOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("tap", params);
    }

    @Override
    public String textContent() {
        return this.withLogging("ElementHandle.textContent", () -> this.textContentImpl());
    }

    private String textContentImpl() {
        return this.withLogging("ElementHandle.textContent", () -> {
            JsonObject json = this.sendMessage("textContent").getAsJsonObject();
            return json.has("value") ? json.get("value").getAsString() : null;
        });
    }

    @Override
    public void type(String text, ElementHandle.TypeOptions options) {
        this.withLogging("ElementHandle.type", () -> this.typeImpl(text, options));
    }

    private void typeImpl(String text, ElementHandle.TypeOptions options) {
        if (options == null) {
            options = new ElementHandle.TypeOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("text", text);
        this.sendMessage("type", params);
    }

    @Override
    public void uncheck(ElementHandle.UncheckOptions options) {
        this.withLogging("ElementHandle.uncheck", () -> this.uncheckImpl(options));
    }

    private void uncheckImpl(ElementHandle.UncheckOptions options) {
        if (options == null) {
            options = new ElementHandle.UncheckOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        this.sendMessage("uncheck", params);
    }

    @Override
    public void waitForElementState(ElementState state, ElementHandle.WaitForElementStateOptions options) {
        this.withLogging("ElementHandle.waitForElementState", () -> this.waitForElementStateImpl(state, options));
    }

    private void waitForElementStateImpl(ElementState state, ElementHandle.WaitForElementStateOptions options) {
        if (options == null) {
            options = new ElementHandle.WaitForElementStateOptions();
        }
        if (state == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("state", ElementHandleImpl.toProtocol(state));
        this.sendMessage("waitForElementState", params);
    }

    private static String toProtocol(ElementState state) {
        return state.toString().toLowerCase();
    }

    @Override
    public ElementHandle waitForSelector(String selector, ElementHandle.WaitForSelectorOptions options) {
        return this.withLogging("ElementHandle.waitForSelector", () -> this.waitForSelectorImpl(selector, options));
    }

    private ElementHandle waitForSelectorImpl(String selector, ElementHandle.WaitForSelectorOptions options) {
        if (options == null) {
            options = new ElementHandle.WaitForSelectorOptions();
        }
        JsonObject params = Serialization.gson().toJsonTree((Object)options).getAsJsonObject();
        params.addProperty("selector", selector);
        JsonElement json = this.sendMessage("waitForSelector", params);
        JsonObject element = json.getAsJsonObject().getAsJsonObject("element");
        if (element == null) {
            return null;
        }
        return (ElementHandle)this.connection.getExistingObject(element.get("guid").getAsString());
    }
}

