/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.threadsafe;

import flash.tools.debugger.Frame;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Variable;
import flash.tools.debugger.threadsafe.ThreadSafeDebuggerObject;
import flash.tools.debugger.threadsafe.ThreadSafeLocation;
import flash.tools.debugger.threadsafe.ThreadSafeSession;
import flash.tools.debugger.threadsafe.ThreadSafeVariable;

public class ThreadSafeFrame
extends ThreadSafeDebuggerObject
implements Frame {
    private Frame fFrame;

    private ThreadSafeFrame(Object syncObj, Frame frame) {
        super(syncObj);
        this.fFrame = frame;
    }

    public static ThreadSafeFrame wrap(Object syncObj, Frame frame) {
        if (frame != null) {
            return new ThreadSafeFrame(syncObj, frame);
        }
        return null;
    }

    public static ThreadSafeFrame[] wrapArray(Object syncObj, Frame[] frames) {
        ThreadSafeFrame[] threadSafeFrames = new ThreadSafeFrame[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            threadSafeFrames[i] = ThreadSafeFrame.wrap(syncObj, frames[i]);
        }
        return threadSafeFrames;
    }

    public static Object getSyncObject(Frame f) {
        return ((ThreadSafeFrame)f).getSyncObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fFrame.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        Object object = this.getSyncObject();
        synchronized (object) {
            if (other == null) {
                return false;
            }
            if (other instanceof ThreadSafeFrame) {
                return this.fFrame.equals(((ThreadSafeFrame)other).fFrame);
            }
            if (other instanceof Frame) {
                return this.fFrame.equals(other);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fFrame.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getArguments(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fFrame.getArguments(ThreadSafeSession.getRaw(s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallSignature() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fFrame.getCallSignature();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getLocals(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fFrame.getLocals(ThreadSafeSession.getRaw(s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location getLocation() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeLocation.wrap(this.getSyncObject(), this.fFrame.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getThis(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrap(this.getSyncObject(), this.fFrame.getThis(ThreadSafeSession.getRaw(s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable[] getScopeChain(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        Object object = this.getSyncObject();
        synchronized (object) {
            return ThreadSafeVariable.wrapArray(this.getSyncObject(), this.fFrame.getScopeChain(ThreadSafeSession.getRaw(s)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsolateId() {
        Object object = this.getSyncObject();
        synchronized (object) {
            return this.fFrame.getIsolateId();
        }
    }
}

