/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.tools.debugger.expression.FoldedExpressionNode;
import flash.tools.debugger.expression.IASTFolder;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalAndAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalAndNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalOrAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorLogicalOrNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;

public class LogicalOperatorsFolder
implements IASTFolder {
    @Override
    public IASNode fold(IASNode rootNode) {
        this.foldLazyRHSOperandsForLogicalOperators(rootNode);
        return rootNode;
    }

    private void foldLazyRHSOperandsForLogicalOperators(IASNode node) {
        if (node instanceof BinaryOperatorLogicalAndNode || node instanceof BinaryOperatorLogicalAndAssignmentNode) {
            BinaryOperatorLogicalAndNode opNode = (BinaryOperatorLogicalAndNode)node;
            opNode.setRightOperandNode(this.fold(opNode.getRightOperandNode()));
            this.foldLazyRHSOperandsForLogicalOperators(opNode.getLeftOperandNode());
        } else if (node instanceof BinaryOperatorLogicalOrNode || node instanceof BinaryOperatorLogicalOrAssignmentNode) {
            BinaryOperatorLogicalOrNode opNode = (BinaryOperatorLogicalOrNode)node;
            opNode.setRightOperandNode(this.fold(opNode.getRightOperandNode()));
            this.foldLazyRHSOperandsForLogicalOperators(opNode.getLeftOperandNode());
        } else {
            int chCount = node.getChildCount();
            for (int i = 0; i < chCount; ++i) {
                IASNode childNode = node.getChild(i);
                this.foldLazyRHSOperandsForLogicalOperators(childNode);
            }
        }
    }

    private ExpressionNodeBase fold(IExpressionNode rightOperandNode) {
        return new FoldedExpressionNode(rightOperandNode);
    }

    @Override
    public IASNode unfoldOneLevel(FoldedExpressionNode foldedExpressionNode) {
        IASNode node = foldedExpressionNode.getUnderLyingNode();
        this.fold(node);
        return node;
    }
}

