/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DValue
implements Value {
    private int m_type;
    private String m_typeName;
    private String m_className;
    private int m_attribs;
    private Map<String, DVariable> m_members;
    long m_nonProtoId;
    private Object m_value;
    private String[] m_classHierarchy;
    private int m_levelsWithMembers;
    private Session m_session;
    private Map<String, List<DVariable>> m_inheritedPrivates;
    private int m_isolateId;

    public DValue(long id, int isolateId) {
        this.init(8, null, null, 0, new Long(id));
        this.setIsolateId(isolateId);
    }

    public DValue(int type, String typeName, String className, int attribs, Object value, int isolateId) {
        this.init(type, typeName, className, attribs, value);
        this.setIsolateId(isolateId);
    }

    public static DValue forPrimitive(Object primitiveValue, int isolateId) {
        if (primitiveValue == null) {
            return new DValue(6, "null", "", 0, primitiveValue, isolateId);
        }
        if (primitiveValue == Value.UNDEFINED) {
            return new DValue(7, "undefined", "", 0, primitiveValue, isolateId);
        }
        if (primitiveValue instanceof Boolean) {
            return new DValue(1, "Boolean", "", 0, primitiveValue, isolateId);
        }
        if (primitiveValue instanceof Double) {
            return new DValue(0, "Number", "", 0, primitiveValue, isolateId);
        }
        if (primitiveValue instanceof String) {
            return new DValue(2, "String", "", 0, primitiveValue, isolateId);
        }
        assert (false);
        return null;
    }

    private void init(int type, String typeName, String className, int attribs, Object value) {
        if (value == null && type == 7) {
            value = Value.UNDEFINED;
        }
        this.m_type = type;
        this.m_typeName = typeName;
        this.m_className = className;
        this.m_attribs = attribs;
        this.m_value = value;
        this.m_members = null;
        this.m_inheritedPrivates = null;
        this.m_nonProtoId = this.getId();
        this.m_isolateId = 1;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }

    public void setIsolateId(int isolateid) {
        this.m_isolateId = isolateid;
    }

    @Override
    public int getAttributes() {
        return this.m_attribs;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public long getId() {
        if (this.m_value instanceof Long) {
            return (Long)this.m_value;
        }
        return -1L;
    }

    @Override
    public int getMemberCount(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        return this.m_members == null ? 0 : this.m_members.size();
    }

    @Override
    public Variable getMemberNamed(Session s, String name) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        return this.findMember(name);
    }

    @Override
    public String[] getClassHierarchy(boolean allLevels) {
        String[] partialClassHierarchy;
        if (allLevels) {
            return this.m_classHierarchy;
        }
        if (this.m_classHierarchy != null) {
            partialClassHierarchy = new String[this.m_levelsWithMembers];
            System.arraycopy(this.m_classHierarchy, 0, partialClassHierarchy, 0, this.m_levelsWithMembers);
        } else {
            partialClassHierarchy = new String[]{};
        }
        return partialClassHierarchy;
    }

    public DVariable findMember(String named) {
        if (this.m_members == null) {
            return null;
        }
        return this.m_members.get(named);
    }

    @Override
    public Variable[] getMembers(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(s);
        int count = this.getMemberCount(s);
        Object[] ar = new DVariable[count];
        if (count > 0) {
            count = 0;
            for (DVariable sf : this.m_members.values()) {
                ar[count++] = sf;
            }
            Arrays.sort(ar);
        }
        return ar;
    }

    private void obtainMembers(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        long id;
        if (s == null) {
            s = this.m_session;
        } else {
            this.m_session = s;
        }
        if (this.m_members == null && s != null && (id = this.getId()) != -1L) {
            if (((PlayerSession)s).getRawValue(id, this.m_isolateId) == this) {
                ((PlayerSession)s).obtainMembers(id, this.m_isolateId);
            }
            if (this.m_members != null) {
                for (DVariable next : this.m_members.values()) {
                    if (!(next instanceof DVariable)) continue;
                    next.setSession(s);
                }
            }
        }
    }

    public boolean membersObtained() {
        return this.getId() == -1L || this.m_members != null;
    }

    public void setMembersObtained(boolean obtained) {
        if (obtained) {
            if (this.m_members == null) {
                this.m_members = Collections.emptyMap();
            }
            if (this.m_inheritedPrivates == null) {
                this.m_inheritedPrivates = Collections.emptyMap();
            }
        } else {
            this.m_members = null;
            this.m_inheritedPrivates = null;
        }
    }

    public void addMember(DVariable v) {
        if (this.m_members == null) {
            this.m_members = new HashMap<String, DVariable>();
        }
        String name = v.getName();
        DValue val = (DValue)v.getValue();
        val.m_nonProtoId = name != null && name.equals("__proto__") ? this.m_nonProtoId : val.getId();
        v.m_nonProtoParentId = this.m_nonProtoId;
        this.m_members.put(name, v);
    }

    public void addInheritedPrivateMember(DVariable v) {
        if (this.m_inheritedPrivates == null) {
            this.m_inheritedPrivates = new HashMap<String, List<DVariable>>();
        }
        String name = v.getName();
        DValue val = (DValue)v.getValue();
        val.m_nonProtoId = name != null && name.equals("__proto__") ? this.m_nonProtoId : val.getId();
        v.m_nonProtoParentId = this.m_nonProtoId;
        List<DVariable> resultList = this.m_inheritedPrivates.get(name);
        if (resultList == null) {
            resultList = new ArrayList<DVariable>();
            resultList.add(v);
            this.m_inheritedPrivates.put(name, resultList);
        } else {
            resultList.add(v);
        }
    }

    public void removeAllMembers() {
        this.m_members = null;
        this.m_inheritedPrivates = null;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public Object getValueAsObject() {
        return this.m_value;
    }

    @Override
    public String getValueAsString() {
        return DValue.getValueAsString(this.m_value);
    }

    public static String getValueAsString(Object value) {
        long longValue;
        double doubleValue;
        if (value == null) {
            return "null";
        }
        if (value instanceof Double && (doubleValue = ((Double)value).doubleValue()) == (double)(longValue = (long)doubleValue)) {
            return Long.toString(longValue);
        }
        return value.toString();
    }

    @Override
    public boolean isAttributeSet(int variableAttribute) {
        return (this.m_attribs & variableAttribute) != 0;
    }

    public void setTypeName(String s) {
        this.m_typeName = s;
    }

    public void setClassName(String s) {
        this.m_className = s;
    }

    public void setType(int t) {
        this.m_type = t;
    }

    public void setValue(Object o) {
        this.m_value = o;
    }

    public void setAttributes(int f) {
        this.m_attribs = f;
    }

    public void setClassHierarchy(String[] classHierarchy, int levelsWithMembers) {
        this.m_classHierarchy = classHierarchy;
        this.m_levelsWithMembers = levelsWithMembers;
    }

    public String membersToString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_members == null) {
            sb.append(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("empty"));
        } else {
            for (DVariable sf : this.m_members.values()) {
                sb.append(sf);
                sb.append(",\n");
            }
        }
        return sb.toString();
    }

    public void setSession(Session s) {
        this.m_session = s;
    }

    public String toString() {
        return this.getValueAsString();
    }

    @Override
    public Variable[] getPrivateInheritedMembers() {
        if (this.m_inheritedPrivates == null) {
            return new DVariable[0];
        }
        ArrayList<DVariable> finalList = new ArrayList<DVariable>();
        for (List<DVariable> varList : this.m_inheritedPrivates.values()) {
            finalList.addAll(varList);
        }
        Object[] ar = finalList.toArray(new DVariable[0]);
        Arrays.sort(ar);
        return ar;
    }

    @Override
    public Variable[] getPrivateInheritedMemberNamed(String name) {
        if (this.m_inheritedPrivates == null) {
            return new DVariable[0];
        }
        List<DVariable> list = this.m_inheritedPrivates.get(name);
        if (list != null) {
            return list.toArray(new Variable[0]);
        }
        return new DVariable[0];
    }
}

