/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.royale.test.ant.IRoyaleUnitServer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.tools.ant.BuildException;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class RoyaleUnitWebSocketServer
extends WebSocketServer
implements IRoyaleUnitServer {
    private static final String START_OF_TEST_RUN_ACK = "<startOfTestRunAck/>";
    private static final String END_OF_TEST_RUN_ACK = "<endOfTestRunAck/>";
    private int timeout;
    private Timer timeoutTimer;
    private List<String> queue = new ArrayList<String>();
    private Exception resultException;

    public RoyaleUnitWebSocketServer(int port, int timeout) {
        super(new InetSocketAddress(port));
        this.timeout = timeout;
        this.setReuseAddr(true);
    }

    @Override
    public Exception getException() {
        return this.resultException;
    }

    @Override
    public void stop() throws IOException, InterruptedException {
        LoggingUtil.log("\nStopping server ...");
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel();
            this.timeoutTimer = null;
        }
        for (WebSocket socket : this.getConnections()) {
            this.sendTestRunEndAcknowledgement(socket);
        }
        super.stop();
    }

    public void onOpen(WebSocket connection, ClientHandshake handshake) {
        if (this.timeoutTimer != null) {
            this.timeoutTimer.cancel();
            this.timeoutTimer = null;
        }
        LoggingUtil.log("Client connected.");
        LoggingUtil.log("Receiving data ...");
        this.sendTestRunStartAcknowledgement(connection);
    }

    public void onClose(WebSocket connection, int code, String reason, boolean remote) {
        Thread.currentThread().interrupt();
    }

    public void onMessage(WebSocket connection, String message) {
        this.queue.add(message);
    }

    public void onError(WebSocket connection, Exception ex) {
        this.resultException = ex;
    }

    public void onStart() {
        LoggingUtil.log("Starting server ...");
        LoggingUtil.log("Waiting for client connection ...");
        this.timeoutTimer = new Timer();
        this.timeoutTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                RoyaleUnitWebSocketServer.this.resultException = (Exception)new BuildException("Socket timeout waiting for royaleunit report");
            }
        }, this.timeout);
    }

    @Override
    public boolean isPending() {
        return this.resultException == null && this.queue.size() == 0;
    }

    @Override
    public String readNextTokenFromSocket() throws IOException {
        return this.queue.remove(0);
    }

    private void sendOutboundMessage(WebSocket connection, String message) {
        connection.send(message);
    }

    private void sendTestRunStartAcknowledgement(WebSocket connection) {
        LoggingUtil.log("Sending acknowledgement to player to start sending test data ...\n");
        this.sendOutboundMessage(connection, START_OF_TEST_RUN_ACK);
    }

    private void sendTestRunEndAcknowledgement(WebSocket connection) {
        LoggingUtil.log("End of test data reached, sending acknowledgement to player ...");
        this.sendOutboundMessage(connection, END_OF_TEST_RUN_ACK);
    }
}

