/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.royale.test.ant.IRoyaleUnitServer;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.report.Report;
import org.apache.royale.test.ant.report.Suite;
import org.apache.tools.ant.BuildException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class RoyaleUnitSocketThread
implements Callable<Object> {
    private static final String END_OF_SUCCESS = "status=\"success\" />";
    private static final String END_OF_FAILURE = "</testcase>";
    private static final String END_OF_IGNORE = "<skipped /></testcase>";
    private static final String END_OF_TEST_RUN = "<endOfTestRun/>";
    private static final String SUITE_ATTRIBUTE = "classname";
    private File reportDir;
    private IRoyaleUnitServer server;
    private Map<String, Report> reports;

    public RoyaleUnitSocketThread(IRoyaleUnitServer server, File reportDir, Map<String, Report> reports) {
        this.server = server;
        this.reportDir = reportDir;
        this.reports = reports;
    }

    @Override
    public Object call() throws Exception {
        try {
            this.server.start();
            this.parseInboundMessages();
        }
        catch (IOException e) {
            throw new BuildException("error receiving report from royaleunit", (Throwable)e);
        }
        finally {
            try {
                this.server.stop();
            }
            catch (IOException e) {
                throw new BuildException("could not close client/server socket");
            }
        }
        return null;
    }

    private void parseInboundMessages() throws IOException {
        block5: {
            String request;
            while (true) {
                if (this.server.isPending()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (this.server.getException() != null) {
                    throw new BuildException((Throwable)this.server.getException());
                }
                request = this.server.readNextTokenFromSocket();
                if (request == null || request.equals(END_OF_TEST_RUN)) break block5;
                if (!request.endsWith(END_OF_FAILURE) && !request.endsWith(END_OF_SUCCESS) && !request.endsWith(END_OF_IGNORE)) break;
                this.processTestReport(request);
            }
            throw new BuildException("command [" + request + "] not understood");
        }
    }

    private void processTestReport(String xml) {
        Document test = this.parseReport(xml);
        String suiteName = test.getRootElement().attributeValue(SUITE_ATTRIBUTE);
        if (!this.reports.containsKey(suiteName = suiteName.replaceAll("::", "."))) {
            this.reports.put(suiteName, new Report(new Suite(suiteName)));
        }
        Report report = this.reports.get(suiteName);
        report.addTest(test);
        report.save(this.reportDir);
    }

    private Document parseReport(String report) {
        try {
            Document document = DocumentHelper.parseText((String)report);
            return document;
        }
        catch (DocumentException e) {
            LoggingUtil.log(report);
            throw new BuildException("Error parsing report.", (Throwable)e);
        }
    }
}

