/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;

@Mojo(name="compile-playerglobal", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class CompilePlayerglobalMojo
extends BaseMojo {
    @Parameter(defaultValue="src/main/playerglobal")
    private String playerglobalSourceDirectory;
    @Parameter(defaultValue="${project.artifactId}-${project.version}.swc")
    protected String outputFileName;
    @Parameter(defaultValue="false")
    private boolean skipPlayerglobal;
    @Parameter(defaultValue="false")
    private boolean playerglobalAir;
    @Component
    private MavenProjectHelper projectHelper;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "COMPC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "compile-playerglobal-config.xml";
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.outputFileName);
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        List<String> args = super.getCompilerArgs(configFile);
        args.add("-compiler.targets=SWF");
        return args;
    }

    @Override
    protected boolean skip() {
        if (this.skipPlayerglobal) {
            return true;
        }
        File inputFolder = new File(this.project.getBasedir(), this.playerglobalSourceDirectory);
        return !inputFolder.exists() || !inputFolder.isDirectory();
    }

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getOutput().exists()) {
            this.projectHelper.attachArtifact(this.project, this.getOutput(), "swf");
        }
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "false"));
        defines.add(new Define("COMPILE::SWF", "true"));
        return defines;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        return "typedefs".equalsIgnoreCase(library.getClassifier());
    }
}

