/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;

@Mojo(name="compile-asdoc", defaultPhase=LifecyclePhase.SITE)
public class CompileASDocMojo
extends BaseMojo {
    @Parameter(defaultValue="asdoc")
    private String asdocDirectoryName;
    @Parameter(defaultValue="false")
    private boolean skipASDoc;
    @Parameter(defaultValue="false")
    private boolean skipAS;
    private ThreadLocal<Type> type = new ThreadLocal();

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "ASDOC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        if (this.type.get() == null) {
            throw new MojoExecutionException("type not set");
        }
        switch (this.type.get()) {
            case SWF: {
                return "compile-asdoc-swf-config.xml";
            }
            case JS: {
                return "compile-asdoc-js-config.xml";
            }
        }
        return null;
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        if (this.type.get() == null) {
            throw new MojoExecutionException("type not set");
        }
        switch (this.type.get()) {
            case SWF: {
                return new File(new File(this.outputDirectory, this.asdocDirectoryName), "swf");
            }
            case JS: {
                return new File(new File(this.outputDirectory, this.asdocDirectoryName), "js");
            }
        }
        return null;
    }

    @Override
    protected boolean skip() {
        return this.skipASDoc;
    }

    @Override
    public void execute() throws MojoExecutionException {
        try {
            if (!this.skipAS) {
                this.getLog().info((CharSequence)"Generating SWF apidocs");
                this.type.set(Type.SWF);
                File outputDirectory = this.getOutput();
                if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                    throw new MojoExecutionException("Could not create output directory for apidocs " + outputDirectory.getPath());
                }
                super.execute();
                this.getLog().info((CharSequence)"Finished");
            }
            this.getLog().info((CharSequence)"Generating JS apidocs");
            this.type.set(Type.JS);
            this.outputDirectory = this.getOutput();
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not create output directory for apidocs " + this.outputDirectory.getPath());
            }
            super.execute();
            this.getLog().info((CharSequence)"Finished");
        }
        finally {
            this.type.remove();
        }
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        List<String> args = super.getCompilerArgs(configFile);
        args.add("-js-output-type=royale_dita");
        return args;
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        if (this.type.get() == null) {
            throw new MojoExecutionException("type not set");
        }
        switch (this.type.get()) {
            case SWF: {
                defines.add(new Define("COMPILE::JS", "false"));
                defines.add(new Define("COMPILE::SWF", "true"));
                break;
            }
            case JS: {
                defines.add(new Define("COMPILE::JS", "true"));
                defines.add(new Define("COMPILE::SWF", "false"));
            }
        }
        return defines;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        switch (this.type.get()) {
            case SWF: {
                String classifier = library.getClassifier();
                return "swf".equalsIgnoreCase(classifier) || classifier == null && "runtime".equalsIgnoreCase(library.getScope());
            }
            case JS: {
                String classifier = library.getClassifier();
                return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
            }
        }
        return false;
    }

    private static enum Type {
        SWF,
        JS;

    }
}

