/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.royale.maven.BaseMojo;
import org.apache.velocity.VelocityContext;

@Mojo(name="generate-playerglobal", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GeneratePlayerglobalMojo
extends BaseMojo {
    @Parameter(defaultValue="src/main/playerglobal")
    private String playerglobalSourceDirectory;
    @Parameter(defaultValue="generated-sources/playerglobal")
    private String outputDirectoryName;
    @Parameter(defaultValue="false")
    private boolean skipPlayerglobal;
    @Parameter(defaultValue="false")
    private boolean playerglobalAir;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "PLAYERGLOBALC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "generate-playerglobal-config.xml";
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.outputDirectoryName);
    }

    @Override
    protected VelocityContext getVelocityContext() throws MojoExecutionException {
        VelocityContext context = super.getVelocityContext();
        context.put("asdocRoot", (Object)new File(this.project.getBasedir(), this.playerglobalSourceDirectory));
        context.put("air", (Object)this.playerglobalAir);
        return context;
    }

    @Override
    protected boolean skip() {
        if (this.skipPlayerglobal) {
            return true;
        }
        File inputFolder = new File(this.project.getBasedir(), this.playerglobalSourceDirectory);
        return !inputFolder.exists() || !inputFolder.isDirectory();
    }

    @Override
    public void execute() throws MojoExecutionException {
        File outputDirectory = this.getOutput();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create output directory " + outputDirectory.getPath());
        }
        super.execute();
        if (outputDirectory.exists()) {
            this.project.addCompileSourceRoot(outputDirectory.getPath());
        }
    }
}

