/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

@Mojo(name="compile-tests", defaultPhase=LifecyclePhase.PROCESS_TEST_SOURCES)
public class CompileTestsMojo
extends BaseMojo {
    private static final Pattern suiteMetadataPattern = Pattern.compile("\\[Suite\\]\\s*((public|dynamic|final)\\s+)+class\\s+\\w+");
    private static final Pattern testMetadataPattern = Pattern.compile("\\[Test\\]\\s*((public|override|final)\\s+)+function\\s+\\w+\\(");
    @Parameter
    private String testsMainClass;
    @Parameter(defaultValue="${basedir}/src/test/royale", required=true, readonly=true)
    private File testSrcDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/royaleunit", required=true, readonly=true)
    private File testGeneratedSrcDirectory;
    @Parameter(defaultValue="${project.artifactId}-tests-${project.version}.swf")
    private String flashTestsOutputFileName;
    @Parameter(defaultValue="javascript-tests")
    private String javascriptTestsOutputDirectoryName;
    @Parameter
    protected String targets = "SWF,JSRoyale";
    @Parameter
    protected String htmlTemplate;
    @Parameter(defaultValue="true")
    protected boolean removeCirculars;
    @Parameter(property="maven.test.skip", readonly=true)
    private boolean skip;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "MXMLC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "compile-app-config.xml";
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.flashTestsOutputFileName);
    }

    @Override
    protected boolean isForceSwcExternalLibraryPath() {
        return false;
    }

    @Override
    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        if (this.testsMainClass == null) {
            throw new MojoExecutionException("The mainClass has to be declared for SWF type modules.");
        }
        String mainClassPath = this.getSourcePath(this.testsMainClass);
        if (mainClassPath == null) {
            throw new MojoExecutionException("Could not find main class");
        }
        List<String> args = super.getCompilerArgs(configFile);
        File jsOutput = new File(this.outputDirectory, this.javascriptTestsOutputDirectoryName);
        args.add("-js-output=" + jsOutput.getAbsolutePath());
        args.add("-compiler.targets=" + this.targets);
        args.add(mainClassPath);
        return args;
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not building test sources");
            return;
        }
        if (this.testsMainClass == null) {
            try {
                boolean hasTests = this.generateTestSources();
                if (!hasTests) {
                    this.project.getProperties().setProperty("maven.test.skip", "true");
                    return;
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to generate RoyaleUnit tests sources");
            }
        }
        super.execute();
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "AUTO"));
        defines.add(new Define("COMPILE::SWF", "AUTO"));
        return defines;
    }

    @Override
    protected VelocityContext getVelocityContext() throws MojoExecutionException {
        VelocityContext context = super.getVelocityContext();
        context.put("removeCirculars", (Object)this.removeCirculars);
        context.put("htmlTemplate", (Object)this.htmlTemplate);
        context.put("includeClasses", null);
        context.put("includeSources", (Object)false);
        return context;
    }

    protected VelocityContext getTestsApplicationVelocityContext(List<String> testQnames) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("testQnames", testQnames);
        return context;
    }

    protected String getRoyaleUnitApplicationTemplateFileName() {
        return "RoyaleUnitApplication.mxml";
    }

    protected String getRoyaleUnitApplicationOutputFileName() {
        return "$__ROYALE_MAVEN_PLUGIN__RoyaleUnitApplication.mxml";
    }

    @Override
    protected List<String> getSourcePaths() {
        List<String> sourcePaths = super.getSourcePaths();
        sourcePaths.add(this.testSrcDirectory.getAbsolutePath());
        sourcePaths.add(this.testGeneratedSrcDirectory.getAbsolutePath());
        return sourcePaths;
    }

    protected boolean generateTestSources() throws MojoExecutionException, IOException {
        if (!this.testSrcDirectory.exists()) {
            return false;
        }
        Path testSrcDirectoryPath = this.testSrcDirectory.toPath();
        List<String> testQualifiedNames = Files.walk(testSrcDirectoryPath, new FileVisitOption[0]).map(Path::toFile).filter(file -> {
            String fileText;
            if (!file.getName().endsWith(".as")) {
                return false;
            }
            try {
                fileText = FileUtils.readFileToString((File)file, (Charset)Charset.forName("utf-8"));
            }
            catch (IOException e) {
                return false;
            }
            Matcher testMetadataMatcher = testMetadataPattern.matcher(fileText);
            boolean hasTestMetadata = testMetadataMatcher.find();
            Matcher suiteMetadataMatcher = suiteMetadataPattern.matcher(fileText);
            boolean hasSuiteMetadata = suiteMetadataMatcher.find();
            return hasTestMetadata || hasSuiteMetadata;
        }).map(File::toPath).map(path -> testSrcDirectoryPath.relativize((Path)path).toString().replace("/", ".").replace("\\", ".").replace(".as", "")).collect(Collectors.toList());
        if (testQualifiedNames.size() == 0) {
            return false;
        }
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.setProperty("parser.space_gobbling", (Object)"bc");
        velocityEngine.setProperty("directive.if.empty_check", (Object)false);
        velocityEngine.setProperty("runtime.conversion.handler", (Object)"none");
        velocityEngine.init();
        VelocityContext context = this.getTestsApplicationVelocityContext(testQualifiedNames);
        File royaleUnitAppFile = new File(this.testGeneratedSrcDirectory, this.getRoyaleUnitApplicationOutputFileName());
        Template royaleUnitAppTemplate = velocityEngine.getTemplate("royale/" + this.getRoyaleUnitApplicationTemplateFileName());
        if (!royaleUnitAppFile.getParentFile().exists() && !royaleUnitAppFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory: " + royaleUnitAppFile.getParent());
        }
        FileWriter royaleUnitAppWriter = null;
        try {
            royaleUnitAppWriter = new FileWriter(royaleUnitAppFile);
            royaleUnitAppTemplate.merge((Context)context, (Writer)royaleUnitAppWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating RoyaleUnit application file at " + royaleUnitAppFile.getPath());
        }
        finally {
            if (royaleUnitAppWriter != null) {
                try {
                    royaleUnitAppWriter.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating RoyaleUnit application file at " + royaleUnitAppFile.getPath());
                }
            }
        }
        this.testsMainClass = this.getRoyaleUnitApplicationOutputFileName();
        return true;
    }

    @Override
    protected boolean includeLibrary(Artifact library) {
        String classifier = library.getClassifier();
        return classifier == null && !"runtime".equalsIgnoreCase(library.getScope());
    }

    @Override
    protected boolean includeLibraryJS(Artifact library) {
        String classifier = library.getClassifier();
        return "typedefs".equalsIgnoreCase(classifier) || "js".equalsIgnoreCase(classifier);
    }

    @Override
    protected boolean includeLibrarySWF(Artifact library) {
        String classifier = library.getClassifier();
        return "swf".equalsIgnoreCase(classifier) || classifier == null && "runtime".equalsIgnoreCase(library.getScope());
    }
}

