/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.royale.maven.BaseMojo;
import org.apache.royale.maven.Define;
import org.apache.royale.maven.ExterncConfig;
import org.apache.velocity.VelocityContext;

@Mojo(name="generate-extern", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class GenerateExterncMojo
extends BaseMojo {
    @Parameter
    private FileSet[] externcInput;
    @Parameter(defaultValue="generated-sources/externc")
    private String outputDirectoryName;
    @Parameter
    private ExterncConfig externcConfig;

    @Override
    protected String getToolGroupName() {
        return "Royale";
    }

    @Override
    protected String getFlexTool() {
        return "EXTERNC";
    }

    @Override
    protected String getConfigFileName() throws MojoExecutionException {
        return "generate-externc-config.xml";
    }

    @Override
    protected boolean skip() {
        return this.externcInput == null;
    }

    @Override
    protected File getOutput() throws MojoExecutionException {
        return new File(this.outputDirectory, this.outputDirectoryName);
    }

    @Override
    protected VelocityContext getVelocityContext() throws MojoExecutionException {
        VelocityContext context = super.getVelocityContext();
        LinkedList<File> includedFiles = new LinkedList<File>();
        FileSetManager fileSetManager = new FileSetManager();
        for (FileSet fileSet : this.externcInput) {
            String[] fileSetIncludes = fileSetManager.getIncludedFiles(fileSet);
            if (fileSetIncludes == null || fileSetIncludes.length <= 0) continue;
            for (String include : fileSetIncludes) {
                includedFiles.add(new File(fileSet.getDirectory(), include));
            }
        }
        context.put("sourcePath", includedFiles);
        if (this.externcConfig != null) {
            context.put("classExcludes", (Object)this.externcConfig.classExcludes);
            context.put("fieldExcludes", (Object)this.externcConfig.fieldExcludes);
            context.put("excludes", (Object)this.externcConfig.excludes);
        }
        return context;
    }

    @Override
    public void execute() throws MojoExecutionException {
        File[] typeDirectories;
        File outputDirectory = this.getOutput();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create output directory " + outputDirectory.getPath());
        }
        super.execute();
        if (outputDirectory.exists() && (typeDirectories = outputDirectory.listFiles()) != null) {
            for (File typeDirectory : typeDirectories) {
                this.project.addCompileSourceRoot(typeDirectory.getPath());
            }
        }
    }

    @Override
    protected List<Define> getDefines() throws MojoExecutionException {
        List<Define> defines = super.getDefines();
        defines.add(new Define("COMPILE::JS", "true"));
        defines.add(new Define("COMPILE::SWF", "false"));
        return defines;
    }
}

