/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.flex.tools.FlexTool;
import org.apache.flex.tools.FlexToolGroup;
import org.apache.flex.tools.FlexToolRegistry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.royale.maven.Define;
import org.apache.royale.maven.IncludeFile;
import org.apache.royale.maven.ManifestComponent;
import org.apache.royale.maven.Namespace;
import org.apache.royale.maven.utils.DependencyHelper;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.eclipse.aether.RepositorySystemSession;

public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter
    private Namespace[] namespaces;
    @Parameter
    private String[] includeClasses;
    @Parameter
    private IncludeFile[] includeFiles;
    @Parameter
    private Define[] defines;
    @Parameter
    private String[] keepAs3Metadata;
    @Parameter(defaultValue="false")
    private boolean forceSwcExternalLibraryPath;
    @Parameter(defaultValue="11.1")
    private String targetPlayer;
    @Parameter(defaultValue="false")
    private boolean includeSources;
    @Parameter
    protected boolean debug = false;
    @Parameter
    protected boolean failOnCompilerWarnings = false;
    @Parameter
    protected boolean allowSubclassOverrides = false;
    @Parameter
    private Boolean includeLookupOnly = null;
    @Parameter(readonly=true, defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Parameter
    private String additionalCompilerOptions = null;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Component
    private LifecycleExecutionPlanCalculator lifecycleExecutionPlanCalculator;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;

    protected boolean skip() {
        return false;
    }

    protected abstract String getConfigFileName() throws MojoExecutionException;

    protected abstract File getOutput() throws MojoExecutionException;

    protected String getLanguageManifestFileName() {
        return "mxml-language-manifest.xml";
    }

    protected String getLanguageNamespaceURI() {
        return "http://ns.adobe.com/mxml/2009";
    }

    protected VelocityContext getVelocityContext() throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        List<Artifact> allLibraries = DependencyHelper.getAllLibraries(this.project, this.repositorySystemSession, this.projectDependenciesResolver);
        List<Artifact> filteredLibraries = this.getFilteredLibraries(allLibraries);
        List<Artifact> libraries = this.getLibraries(filteredLibraries);
        List<Artifact> jsLibraries = this.getJSLibraries(filteredLibraries);
        List<Artifact> swfLibraries = this.getSWFLibraries(filteredLibraries);
        List<Artifact> externalLibraries = this.getExternalLibraries(filteredLibraries);
        List<Artifact> jsExternalLibraries = this.getJSExternalLibraries(filteredLibraries);
        List<Artifact> swfExternalLibraries = this.getSWFExternalLibraries(filteredLibraries);
        List<Artifact> themeLibraries = this.getThemeLibraries(filteredLibraries);
        List<String> sourcePaths = this.getSourcePaths();
        context.put("libraries", libraries);
        context.put("externalLibraries", externalLibraries);
        context.put("jsLibraries", jsLibraries);
        context.put("jsExternalLibraries", jsExternalLibraries);
        context.put("swfLibraries", swfLibraries);
        context.put("swfExternalLibraries", swfExternalLibraries);
        context.put("themeLibraries", themeLibraries);
        context.put("sourcePaths", sourcePaths);
        context.put("languageNamespace", (Object)this.getLanguageNamespace());
        context.put("namespaces", this.getNamespaces());
        context.put("jsNamespaces", this.getNamespacesJS());
        context.put("namespaceUris", this.getNamespaceUris());
        context.put("includeClasses", (Object)this.includeClasses);
        context.put("includeFiles", (Object)this.includeFiles);
        context.put("defines", this.getDefines());
        context.put("keepAs3Metadata", (Object)this.keepAs3Metadata);
        context.put("targetPlayer", (Object)this.targetPlayer);
        context.put("includeSources", (Object)this.includeSources);
        context.put("debug", (Object)this.debug);
        context.put("allowSubclassOverrides", (Object)this.allowSubclassOverrides);
        if (this.includeLookupOnly != null) {
            context.put("includeLookupOnly", (Object)this.includeLookupOnly);
        }
        context.put("output", (Object)this.getOutput());
        context.put("manifestComponents", this.getLanguageManifestComponents());
        return context;
    }

    protected abstract String getToolGroupName();

    protected abstract String getFlexTool();

    protected List<Namespace> getNamespaces() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        if (this.namespaces != null) {
            for (Namespace namespace : this.namespaces) {
                namespaces.add(namespace);
            }
        }
        return namespaces;
    }

    protected Namespace getLanguageNamespace() {
        File manifestFile = new File(this.outputDirectory, this.getLanguageManifestFileName());
        Namespace namespace = new Namespace();
        namespace.setUri(this.getLanguageNamespaceURI());
        namespace.setManifest(manifestFile.getAbsolutePath());
        return namespace;
    }

    protected List<Namespace> getNamespacesJS() {
        LinkedList<Namespace> namespaces = new LinkedList<Namespace>();
        if (this.namespaces != null) {
            for (Namespace namespace : this.namespaces) {
                namespaces.add(namespace);
            }
        }
        return namespaces;
    }

    protected Set<String> getNamespaceUris() {
        HashSet<String> namespaceUris = new HashSet<String>();
        for (Namespace namespace : this.getNamespaces()) {
            namespaceUris.add(namespace.getUri());
        }
        return namespaceUris;
    }

    protected List<ManifestComponent> getLanguageManifestComponents() {
        ArrayList<ManifestComponent> manifestComponents = new ArrayList<ManifestComponent>();
        manifestComponents.add(new ManifestComponent("Array", "Array", true));
        manifestComponents.add(new ManifestComponent("Boolean", "Boolean", true));
        manifestComponents.add(new ManifestComponent("Class", "Class", true));
        manifestComponents.add(new ManifestComponent("Date", "Date", true));
        manifestComponents.add(new ManifestComponent("DesignLayer", "mx.core.DesignLayer", false));
        manifestComponents.add(new ManifestComponent("Function", "Function", true));
        manifestComponents.add(new ManifestComponent("int", "int", true));
        manifestComponents.add(new ManifestComponent("Number", "Number", true));
        manifestComponents.add(new ManifestComponent("Object", "Object", true));
        manifestComponents.add(new ManifestComponent("RegExp", "RegExp", true));
        manifestComponents.add(new ManifestComponent("String", "String", true));
        manifestComponents.add(new ManifestComponent("uint", "uint", true));
        manifestComponents.add(new ManifestComponent("Vector", "__AS3__.vec.Vector", true));
        manifestComponents.add(new ManifestComponent("XML", "XML", true));
        manifestComponents.add(new ManifestComponent("XMLList", "XMLList", true));
        return manifestComponents;
    }

    protected List<String> getSourcePaths() {
        LinkedList<String> sourcePaths = new LinkedList<String>();
        for (String sourcePath : this.project.getCompileSourceRoots()) {
            if (!new File(sourcePath).exists()) continue;
            sourcePaths.add(sourcePath);
        }
        return sourcePaths;
    }

    protected String getSourcePath(String resourceOnPath) {
        for (String path : this.getSourcePaths()) {
            File tmpFile = new File(path, resourceOnPath);
            if (!tmpFile.exists()) continue;
            return tmpFile.getPath();
        }
        return null;
    }

    protected List<String> getCompilerArgs(File configFile) throws MojoExecutionException {
        LinkedList<String> args = new LinkedList<String>();
        args.add("-load-config=" + configFile.getPath());
        if (this.additionalCompilerOptions != null) {
            this.additionalCompilerOptions = this.additionalCompilerOptions.replaceAll("=\\s+", "=");
            this.additionalCompilerOptions = this.additionalCompilerOptions.replaceAll("\\s*,\\s*", ",");
            this.additionalCompilerOptions = this.additionalCompilerOptions.replaceAll("(\\r\\n?|\\n)+", ";");
            if (this.additionalCompilerOptions.contains(";")) {
                String[] options;
                for (String option : options = this.additionalCompilerOptions.split(";")) {
                    if (option.trim().length() <= 0) continue;
                    args.add(option.trim());
                }
            } else if (this.additionalCompilerOptions.trim().length() > 0) {
                args.add(this.additionalCompilerOptions.trim());
            }
        }
        return args;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip()) {
            return;
        }
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        VelocityContext context = this.getVelocityContext();
        File configFile = new File(this.outputDirectory, this.getConfigFileName());
        Template configTemplate = velocityEngine.getTemplate("config/" + this.getConfigFileName());
        if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory: " + configFile.getParent());
        }
        FileWriter configWriter = null;
        try {
            configWriter = new FileWriter(configFile);
            configTemplate.merge((Context)context, (Writer)configWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating config file at " + configFile.getPath());
        }
        finally {
            if (configWriter != null) {
                try {
                    configWriter.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating config file at " + configFile.getPath());
                }
            }
        }
        File manifestFile = new File(this.outputDirectory, this.getLanguageManifestFileName());
        Template manifestTemplate = velocityEngine.getTemplate("config/" + this.getLanguageManifestFileName());
        if (!manifestFile.getParentFile().exists() && !manifestFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory: " + manifestFile.getParent());
        }
        FileWriter manifestWriter = null;
        try {
            manifestWriter = new FileWriter(manifestFile);
            manifestTemplate.merge((Context)context, (Writer)manifestWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating manifest file at " + manifestFile.getPath());
        }
        finally {
            if (manifestWriter != null) {
                try {
                    manifestWriter.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating manifest file at " + manifestFile.getPath());
                }
            }
        }
        FlexToolRegistry toolRegistry = new FlexToolRegistry();
        FlexToolGroup toolGroup = toolRegistry.getToolGroup(this.getToolGroupName());
        if (toolGroup == null) {
            throw new MojoExecutionException("Could not find tool group: " + this.getToolGroupName());
        }
        FlexTool tool = toolGroup.getFlexTool(this.getFlexTool());
        Object[] args = this.getCompilerArgs(configFile).toArray(new String[0]);
        this.getLog().info((CharSequence)("Executing " + this.getFlexTool() + " in tool group " + this.getToolGroupName() + " with args: " + Arrays.toString(args)));
        int exitCode = tool.execute((String[])args);
        this.handleExitCode(exitCode);
    }

    protected void handleExitCode(int exitCode) throws MojoExecutionException {
        if (exitCode == 1000) {
            this.checkForInvalidGoalOrPhaseAfterCompile();
            try {
                while (true) {
                    Thread.sleep(60000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("There were errors during the build. Got return code " + exitCode);
        }
    }

    protected void checkForInvalidGoalOrPhaseAfterCompile() throws MojoExecutionException {
        List segments = null;
        try {
            segments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(this.session);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to calculate session task segments for --watch=true");
        }
        for (TaskSegment segment : segments) {
            List tasks = segment.getTasks();
            MavenExecutionPlan plan = null;
            try {
                plan = this.lifecycleExecutionPlanCalculator.calculateExecutionPlan(this.session, this.project, tasks, false);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to calculate execution plan for --watch=true");
            }
            boolean foundCompile = false;
            for (MojoExecution exec : plan.getMojoExecutions()) {
                String phase = exec.getLifecyclePhase();
                if (foundCompile) {
                    throw new MojoExecutionException("Additional goals or lifecycle phases after 'compile' are not allowed when using the --watch=true compiler option");
                }
                if (!"compile".equals(phase)) continue;
                foundCompile = true;
            }
        }
    }

    protected List<Artifact> getFilteredLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> filteredLibraries = new LinkedList<Artifact>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (!"swc".equals(artifact.getType())) continue;
                filteredLibraries.add(artifact);
            }
        }
        return filteredLibraries;
    }

    protected List<Artifact> getLibraries(List<Artifact> artifacts) {
        if (!this.isForceSwcExternalLibraryPath()) {
            return this.internalGetLibraries(artifacts);
        }
        return Collections.emptyList();
    }

    protected List<Artifact> getJSLibraries(List<Artifact> artifacts) {
        if (!this.isForceSwcExternalLibraryPath()) {
            return this.internalGetLibrariesJS(artifacts);
        }
        return Collections.emptyList();
    }

    protected List<Artifact> getSWFLibraries(List<Artifact> artifacts) {
        if (!this.isForceSwcExternalLibraryPath()) {
            return this.internalGetLibrariesSWF(artifacts);
        }
        return Collections.emptyList();
    }

    protected List<Artifact> getThemeLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> themeLibraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!"theme".equalsIgnoreCase(artifact.getScope())) continue;
            themeLibraries.add(artifact);
        }
        return themeLibraries;
    }

    protected List<Artifact> getExternalLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> externalLibraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!"provided".equalsIgnoreCase(artifact.getScope()) && !"runtime".equalsIgnoreCase(artifact.getScope()) || !this.includeLibrary(artifact) || "pom".equals(artifact.getType())) continue;
            externalLibraries.add(artifact);
        }
        if (this.isForceSwcExternalLibraryPath()) {
            externalLibraries.addAll(this.internalGetLibraries(artifacts));
        }
        return externalLibraries;
    }

    protected List<Artifact> getJSExternalLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> externalLibraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!"provided".equalsIgnoreCase(artifact.getScope()) && !"runtime".equalsIgnoreCase(artifact.getScope()) || !this.includeLibraryJS(artifact) || "pom".equals(artifact.getType())) continue;
            externalLibraries.add(artifact);
        }
        if (this.isForceSwcExternalLibraryPath()) {
            externalLibraries.addAll(this.internalGetLibrariesJS(artifacts));
        }
        return externalLibraries;
    }

    protected List<Artifact> getSWFExternalLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> externalLibraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!"provided".equalsIgnoreCase(artifact.getScope()) && !"runtime".equalsIgnoreCase(artifact.getScope()) || !this.includeLibrarySWF(artifact) || "pom".equals(artifact.getType())) continue;
            externalLibraries.add(artifact);
        }
        if (this.isForceSwcExternalLibraryPath()) {
            externalLibraries.addAll(this.internalGetLibrariesSWF(artifacts));
        }
        return externalLibraries;
    }

    protected boolean isForceSwcExternalLibraryPath() {
        return this.forceSwcExternalLibraryPath;
    }

    private List<Artifact> internalGetLibraries(List<Artifact> artifacts) {
        LinkedList<Artifact> libraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if ("provided".equalsIgnoreCase(artifact.getScope()) || "runtime".equalsIgnoreCase(artifact.getScope()) || "theme".equalsIgnoreCase(artifact.getScope()) || !this.includeLibrary(artifact) || "pom".equals(artifact.getType())) continue;
            libraries.add(artifact);
        }
        return libraries;
    }

    private List<Artifact> internalGetLibrariesJS(List<Artifact> artifacts) {
        LinkedList<Artifact> libraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if ("provided".equalsIgnoreCase(artifact.getScope()) || "runtime".equalsIgnoreCase(artifact.getScope()) || !this.includeLibraryJS(artifact) || "pom".equals(artifact.getType())) continue;
            libraries.add(artifact);
        }
        return libraries;
    }

    private List<Artifact> internalGetLibrariesSWF(List<Artifact> artifacts) {
        LinkedList<Artifact> libraries = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if ("provided".equalsIgnoreCase(artifact.getScope()) || "runtime".equalsIgnoreCase(artifact.getScope()) || !this.includeLibrarySWF(artifact) || "pom".equals(artifact.getType())) continue;
            libraries.add(artifact);
        }
        return libraries;
    }

    protected List<Define> getDefines() throws MojoExecutionException {
        LinkedList<Define> defines = new LinkedList<Define>();
        if (this.defines != null) {
            for (Define define : this.defines) {
                defines.add(define);
            }
        }
        return defines;
    }

    protected boolean includeLibrary(Artifact library) {
        return true;
    }

    protected boolean includeLibraryJS(Artifact library) {
        return true;
    }

    protected boolean includeLibrarySWF(Artifact library) {
        return true;
    }
}

