/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestVariableDeclaration
extends BaseFormatterTests {
    @Test
    public void testWithoutTypeAndWithoutInitializer() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithoutInitializer() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar:String", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:String;", (Object)result);
    }

    @Test
    public void testWithTypeAndWithInitializer() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar:Number = 123.4;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Number = 123.4;", (Object)result);
    }

    @Test
    public void testWithAnyType() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar:*;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:*;", (Object)result);
    }

    @Test
    public void testWithVectorAnyType() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar:Vector.<*>;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Vector.<*>;", (Object)result);
    }

    @Test
    public void testChained() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("var myVar:Number = what(hi, 2), myVar2:Number = 456.7;", (Collection)this.problems);
        Assert.assertEquals((Object)"var myVar:Number = what(hi, 2), myVar2:Number = 456.7;", (Object)result);
    }
}

