/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestTryCatchStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try {\n}\ncatch (e:Object) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n}\ncatch (e:Object)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try\n{\n}\ncatch (e:Object)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try {\n}\ncatch (e:Object) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try\n{\n\tstatement;\n}\ncatch(e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = false;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch(e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try {\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try\n{\n\tstatement;\n}\ncatch (e:Object)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try {\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testWithCommentBetweenTryStatementAndBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("try // comment\n{\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"try // comment\n{\n\tstatement;\n}\ncatch (e:Object) {\n\tstatement;\n}", (Object)result);
    }
}

