/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestThrowStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.ignoreProblems = true;
        String result = formatter.formatActionScriptText("throw;", null);
        Assert.assertEquals((Object)"throw;\n;", (Object)result);
    }

    @Test
    public void testWithoutValueAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.ignoreProblems = true;
        String result = formatter.formatActionScriptText("throw", null);
        Assert.assertEquals((Object)"throw;", (Object)result);
    }

    @Test
    public void testWithValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("throw new Error();", (Collection)this.problems);
        Assert.assertEquals((Object)"throw new Error();", (Object)result);
    }

    @Test
    public void testWithValueAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("throw new Error()", (Collection)this.problems);
        Assert.assertEquals((Object)"throw new Error();", (Object)result);
    }

    @Test
    public void testWithValueOnNextLineCausesAutomaticSemicolonInsertion() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.ignoreProblems = true;
        String result = formatter.formatActionScriptText("throw\nnew Error();", null);
        Assert.assertEquals((Object)"throw;\nnew Error();", (Object)result);
    }
}

