/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestSwitchStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition) {\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndMultipleStatements() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t\tstatement;\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tstatement;\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\t{\n\t\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndBlockWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\t{\n\t\t\tbreak;\n\t\t}\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseAndStatementAfterBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndMultipleStatements() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault:\n\t\tstatement;\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\tstatement;\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault:\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\t{\n\t\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndBlockWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault:\n\t{\n\t\tbreak;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\t{\n\t\t\tbreak;\n\t\t}\n}", (Object)result);
    }

    @Test
    public void testWithDefaultClauseAndStatementAfterBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault:\n\t{\n\t\tstatement;\n\t}\n\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault:\n\t\t{\n\t\t\tstatement;\n\t\t}\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithMultipleCaseClauses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseAndDefaultClauses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tdefault:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\t\tbreak;\n\tdefault:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testWithCaseClauseFallthrough() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase condition:\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase condition:\n\tcase condition:\n\t\tbreak;\n\tcase condition:\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClause() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClauseAndEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\t{\n\t\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithCaseClauseAndBlockWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tcase clause:\n\t\t\t{\n\t\t\t\tbreak;\n\t\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClause() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\tbreak;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClauseAndEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\t{\n\t\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithDefaultClauseAndBlockWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t{\n\t\t\tbreak;\n\t\t}\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tswitch (condition)\n\t{\n\t\tdefault:\n\t\t\t{\n\t\t\t\tbreak;\n\t\t\t}\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentOnSameLineAsCaseClause() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tcase clause://what\n\t\tbreak;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tcase clause: // what\n\t\tbreak;\n}", (Object)result);
    }

    @Test
    public void testCommentOnSameLineAsDefaultClause() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("switch (condition)\n{\n\tdefault://what\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"switch (condition)\n{\n\tdefault: // what\n}", (Object)result);
    }
}

