/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestStringLiteral
extends BaseFormatterTests {
    @Test
    public void testEmptyString() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("\"\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\";", (Object)result);
    }

    @Test
    public void testWithNewLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("\"\\n\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\\n\";", (Object)result);
    }

    @Test
    public void testDoubleQuoteWithEscapedDoubleQuote() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("\"\\\"\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"\\\"\";", (Object)result);
    }

    @Test
    public void testDoubleQuoteWithUnescapedSingleQuote() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("\"'\";", (Collection)this.problems);
        Assert.assertEquals((Object)"\"'\";", (Object)result);
    }

    @Test
    public void testSingleQuoteWithEscapedSingleQuote() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("'\\'';", (Collection)this.problems);
        Assert.assertEquals((Object)"'\\'';", (Object)result);
    }

    @Test
    public void testSingleQuoteWithUnescapedDoubleQuote() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("'\"';", (Collection)this.problems);
        Assert.assertEquals((Object)"'\"';", (Object)result);
    }
}

