/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleLineComment
extends BaseFormatterTests {
    @Test
    public void testInsertSpaceAtStartOfLineComment() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("//this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAtStartOfLineComment() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = false;
        String result = formatter.formatActionScriptText("// this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"//this is a comment", (Object)result);
    }

    @Test
    public void testAtEndOfStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("statement; // this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"statement; // this is a comment", (Object)result);
    }

    @Test
    public void testOnLineBeforeStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("// this is a comment\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment\nstatement;", (Object)result);
    }

    @Test
    public void testWithExtraLineBeforeStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        formatter.maxPreserveNewLines = 2;
        String result = formatter.formatActionScriptText("// this is a comment\n\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"// this is a comment\n\nstatement;", (Object)result);
    }

    @Test
    public void testOnLineAfterStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("statement;\n// this is a comment", (Collection)this.problems);
        Assert.assertEquals((Object)"statement;\n// this is a comment", (Object)result);
    }

    @Test
    public void testAtEndOfControlFlowStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("if (statement) // this is a comment\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (statement) // this is a comment\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testAtEndOfBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        formatter.insertSpaceAtStartOfLineComment = true;
        String result = formatter.formatActionScriptText("{\n\tstatement;\n} // this is a comment\nstatement;", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tstatement;\n} // this is a comment\nstatement;", (Object)result);
    }
}

