/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestReturnStatement
extends BaseFormatterTests {
    @Test
    public void testWithoutValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("return;", (Collection)this.problems);
        Assert.assertEquals((Object)"return;", (Object)result);
    }

    @Test
    public void testWithoutValueAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("return", (Collection)this.problems);
        Assert.assertEquals((Object)"return;", (Object)result);
    }

    @Test
    public void testWithValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("return 123;", (Collection)this.problems);
        Assert.assertEquals((Object)"return 123;", (Object)result);
    }

    @Test
    public void testWithValueAndWithoutSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("return 123", (Collection)this.problems);
        Assert.assertEquals((Object)"return 123;", (Object)result);
    }

    @Test
    public void testWithValueOnNextLineCausesAutomaticSemicolonInsertion() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("return\n123;", (Collection)this.problems);
        Assert.assertEquals((Object)"return;\n123;", (Object)result);
    }
}

