/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestPreserveNewLines
extends BaseFormatterTests {
    @Test
    public void testNoMaxPreserveNewLines() {
        FORMATTER formatter = new FORMATTER();
        formatter.maxPreserveNewLines = 0;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/* this is a comment */\n\n\n/* this is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/* this is a comment */\n\n\n/* this is a comment */", (Object)result);
    }

    @Test
    public void testMaxPreserveNewLines() {
        FORMATTER formatter = new FORMATTER();
        formatter.maxPreserveNewLines = 2;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/* this is a comment */\n\n\n/* this is a comment */", (Collection)this.problems);
        Assert.assertEquals((Object)"/* this is a comment */\n\n/* this is a comment */", (Object)result);
    }

    @Test
    public void testNewLinesBeforeEndOfStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.maxPreserveNewLines = 0;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("1 + 2\n\n+ 3\n\t+ 4;", (Collection)this.problems);
        Assert.assertEquals((Object)"1 + 2\n\n\t+ 3\n\t+ 4;", (Object)result);
    }
}

