/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestMethodDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithMethod\n{\n\tfunction myFunction() {\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithMethod\n{\n\tfunction myFunction()\n\t{\n\t}\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithMethod\n{\n\tfunction myFunction()\n\t{\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithMethod {\n\tfunction myFunction() {\n\t}\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithMethod\n{\n\tfunction myFunction() {\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithMethod\n{\n\tfunction myFunction()\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithMethod\n{\n\tfunction myFunction()\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithMethod {\n\tfunction myFunction() {\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class ClassWithMethod\n{\n\tfunction myFunction() {\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class ClassWithMethod {\n\tfunction myFunction() {}\n}", (Object)result);
    }
}

