/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadata
extends BaseFormatterTests {
    @Test
    public void testUnknownMetaTagOnClassWithoutAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("[UnknownMetaTag]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithoutAttributeNameAndWithValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("[UnknownMetaTag(\"value\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(\"value\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithAttributeAndWithValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("[UnknownMetaTag(unknownAttr=\"value\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(unknownAttr=\"value\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testUnknownMetaTagOnClassWithMultipleAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("[UnknownMetaTag(unknownAttr1=\"value1\",unknownAttr2=\"value2\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[UnknownMetaTag(unknownAttr1=\"value1\", unknownAttr2=\"value2\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testEventMetaTagOnClassWithNameAndTypeAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("[Event(name=\"change\", type=\"flash.events.Event\")]\nclass MyClass\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"[Event(name=\"change\", type=\"flash.events.Event\")]\nclass MyClass\n{\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithoutAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class MyClass\n{\n\t[Bindable]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithValue() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class MyClass\n{\n\t[Bindable(\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable(\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testBindableMetaTagOnFieldWithEventAttribute() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("class MyClass\n{\n\t[Bindable(event = \"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"class MyClass\n{\n\t[Bindable(event=\"myVarChanged\")]\n\tpublic var myVar:String;\n}", (Object)result);
    }

    @Test
    public void testAfterSingleLineComment() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("// comment\n[UnknownMetaTag(attr1=\"one\")]\n", (Collection)this.problems);
        Assert.assertEquals((Object)"// comment\n[UnknownMetaTag(attr1=\"one\")]\n", (Object)result);
    }

    @Test
    public void testAfterMultiLineComment() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("/* comment */\n[UnknownMetaTag(attr1=\"one\")]\n", (Collection)this.problems);
        Assert.assertEquals((Object)"/* comment */\n[UnknownMetaTag(attr1=\"one\")]\n", (Object)result);
    }
}

