/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestMXMLTag
extends BaseFormatterTests {
    @Test
    public void testSelfClosingTag() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag />", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag/>", (Object)result);
    }

    @Test
    public void testTagWithEmptyText() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag></s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithText() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>Hello World</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>Hello World</s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithTextAndNewLines() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>\n\tHello World\n</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\tHello World\n</s:Tag>", (Object)result);
    }

    @Test
    public void testTagWithNewLineText() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>\n</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n</s:Tag>", (Object)result);
    }

    @Test
    public void testNewLinesBetweenTags() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>\n\n</s:Tag>\n\n<s:Tag/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\n</s:Tag>\n\n<s:Tag/>", (Object)result);
    }

    @Test
    public void testExcessWhitespaceBetweenTags() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>\t\n\n\t\t</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>\n\n</s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren1() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag>text <s:Tag/></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag>text <s:Tag/></s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren2() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag><s:Tag/> text</s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag><s:Tag/> text</s:Tag>", (Object)result);
    }

    @Test
    public void testMixedTextAndTagChildren3() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Tag><s:Tag/> text <s:Tag/></s:Tag>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag><s:Tag/> text <s:Tag/></s:Tag>", (Object)result);
    }

    @Test
    public void testMultipleAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        formatter.mxmlInsertNewLineBetweenAttributes = false;
        formatter.mxmlAlignAttributes = false;
        String result = formatter.formatMXMLText("<s:Tag one=\"1\"   two=\"2\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\" two=\"2\"/>", (Object)result);
    }

    @Test
    public void testMultipleAttributesOnePerLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        formatter.mxmlInsertNewLineBetweenAttributes = true;
        formatter.mxmlAlignAttributes = false;
        String result = formatter.formatMXMLText("<s:Tag one=\"1\" two=\"2\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\"\n\ttwo=\"2\"/>", (Object)result);
    }

    @Test
    public void testMXMLAlignAttributes() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        formatter.mxmlInsertNewLineBetweenAttributes = true;
        formatter.mxmlAlignAttributes = true;
        String result = formatter.formatMXMLText("<s:Tag one=\"1\" two=\"2\" three=\"3\"/>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Tag one=\"1\"\n\t   two=\"2\"\n\t   three=\"3\"/>", (Object)result);
    }
}

