/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestMXMLScript
extends BaseFormatterTests {
    @Test
    public void testEmptyScriptNoCdata() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Application>\n<fx:Script>\n</fx:Script>\n</s:Application>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Application>\n\t<fx:Script>\n\t\t<![CDATA[\n\t\t]]>\n\t</fx:Script>\n</s:Application>", (Object)result);
    }

    @Test
    public void testEmptyScriptWithCdata() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Application>\n<fx:Script>\n<![CDATA[\n]]>\n</fx:Script>\n</s:Application>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Application>\n\t<fx:Script>\n\t\t<![CDATA[\n\t\t]]>\n\t</fx:Script>\n</s:Application>", (Object)result);
    }

    @Test
    public void testScriptWithActionScript() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaces = false;
        String result = formatter.formatMXMLText("<s:Application>\n<fx:Script>\n<![CDATA[\npublic var a: Number=123.4;\n]]>\n</fx:Script>\n</s:Application>", (Collection)this.problems);
        Assert.assertEquals((Object)"<s:Application>\n\t<fx:Script>\n\t\t<![CDATA[\n\t\t\tpublic var a:Number = 123.4;\n\t\t]]>\n\t</fx:Script>\n</s:Application>", (Object)result);
    }
}

