/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestInterfaceDeclaration
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testOneMethod() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface\n{\n\tfunction myMethod():void;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tfunction myMethod():void;\n}", (Object)result);
    }

    @Test
    public void testMultipleMethods() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("interface MyInterface\n{\n\tfunction myMethod1():void;\n\tfunction myMethod2():void;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface\n{\n\tfunction myMethod1():void;\n\tfunction myMethod2():void;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("interface MyInterface {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"interface MyInterface {}", (Object)result);
    }
}

