/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestIfStatement
extends BaseFormatterTests {
    @Test
    public void testPlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true) {\n}", (Object)result);
    }

    @Test
    public void testInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if(true)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisableInsertSpaceAfterControlFlowKeyword() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = false;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if(true)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testPlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true) {\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testDisablePlaceOpenBraceOnNewLineWithStatement() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true) {\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true) statement;", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n\tstatement;", (Object)result);
    }

    @Test
    public void testWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true);", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true);", (Object)result);
    }

    @Test
    public void testCommentBeforeStartBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true) //comment\n{\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true) // comment\n{\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCommentBeforeEndBody() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (true)\n{\n\tstatement; // comment\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (true)\n{\n\tstatement; // comment\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (condition)\n\t{\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition)\n\t{\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true)\n\t\tstatement;\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t\tstatement;\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIndentWithBodyWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true)\n\t{\n\t\tstatement;\n\t}\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNextIntentWithBodyIsSemicolonOnSameLine() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{\n\tif (true);\n\tstatement;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (true);\n\tstatement;\n}", (Object)result);
    }

    @Test
    public void testNested() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("if (condition1)\n{\n\tif (condition2)\n\t{\n\t\tstatement;\n\t}\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1)\n{\n\tif (condition2)\n\t{\n\t\tstatement;\n\t}\n}", (Object)result);
    }

    @Test
    public void testNestedBodiesWithoutParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = true;
        formatter.insertSpaces = false;
        String result = formatter.formatActionScriptText("{if (condition1) if (condition2) statement;}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\tif (condition1)\n\t\tif (condition2)\n\t\t\tstatement;\n}", (Object)result);
    }

    @Test
    public void testCollapseEmptyBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceAfterKeywordsInControlFlowStatements = true;
        formatter.placeOpenBraceOnNewLine = false;
        formatter.collapseEmptyBlocks = true;
        String result = formatter.formatActionScriptText("if (condition1) {\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"if (condition1) {}", (Object)result);
    }
}

