/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.util.Collection;
import org.apache.royale.formatter.BaseFormatterTests;
import org.apache.royale.formatter.FORMATTER;
import org.junit.Assert;
import org.junit.Test;

public class TestIdentifier
extends BaseFormatterTests {
    @Test
    public void testBasic() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"identifier;", (Object)result);
    }

    @Test
    public void testUnaryPlus() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("+identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"+identifier;", (Object)result);
    }

    @Test
    public void testUnaryPlusWithLeadingOperator() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var a = +identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"var a = +identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinus() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("-identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"-identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithLeadingOperator() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var a = -identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"var a = -identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithParentheses() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("(-identifier);", (Collection)this.problems);
        Assert.assertEquals((Object)"(-identifier);", (Object)result);
    }

    @Test
    public void testUnaryMinusWithBrackets() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("a[-identifier];", (Collection)this.problems);
        Assert.assertEquals((Object)"a[-identifier];", (Object)result);
    }

    @Test
    public void testUnaryMinusWithBlock() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("{\n\t-identifier;\n}", (Collection)this.problems);
        Assert.assertEquals((Object)"{\n\t-identifier;\n}", (Object)result);
    }

    @Test
    public void testUnaryMinusWithSemicolon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("a;\n-identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"a;\n-identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithReturn() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("return -identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"return -identifier;", (Object)result);
    }

    @Test
    public void testUnaryMinusWithComma() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var array = [identifier, -identifier];", (Collection)this.problems);
        Assert.assertEquals((Object)"var array = [identifier, -identifier];", (Object)result);
    }

    @Test
    public void testUnaryMinusWithColon() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("var obj = {field: -identifier};", (Collection)this.problems);
        Assert.assertEquals((Object)"var obj = {field: -identifier};", (Object)result);
    }

    @Test
    public void testNot() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("!identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"!identifier;", (Object)result);
    }

    @Test
    public void testDoubleNot() {
        FORMATTER formatter = new FORMATTER();
        formatter.insertSpaceBeforeAndAfterBinaryOperators = true;
        String result = formatter.formatActionScriptText("!!identifier;", (Collection)this.problems);
        Assert.assertEquals((Object)"!!identifier;", (Object)result);
    }
}

